/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.media;

import android.content.Context;
import android.media.AudioManager;
import android.util.Log;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.annotation.RobocopTarget;
import org.mozilla.gecko.annotation.WrapForJNI;

public class AudioFocusAgent {
    private static final String LOGTAG = "AudioFocusAgent";
    private static Context mContext;
    private AudioManager mAudioManager;
    private AudioManager.OnAudioFocusChangeListener mAfChangeListener;
    private boolean mIsOwningAudioFocus = false;

    @WrapForJNI
    public static void notifyStartedPlaying() {
        if (!AudioFocusAgent.isAttachedToContext()) {
            return;
        }
        Log.d((String)LOGTAG, (String)"NotifyStartedPlaying");
        AudioFocusAgent.getInstance().requestAudioFocusIfNeeded();
    }

    @WrapForJNI
    public static void notifyStoppedPlaying() {
        if (!AudioFocusAgent.isAttachedToContext()) {
            return;
        }
        Log.d((String)LOGTAG, (String)"NotifyStoppedPlaying");
        AudioFocusAgent.getInstance().abandonAudioFocusIfNeeded();
    }

    public synchronized void attachToContext(Context context) {
        if (AudioFocusAgent.isAttachedToContext()) {
            return;
        }
        mContext = context;
        this.mAudioManager = (AudioManager)mContext.getSystemService("audio");
        this.mAfChangeListener = new AudioManager.OnAudioFocusChangeListener(){

            public void onAudioFocusChange(int n) {
                switch (n) {
                    case -1: {
                        Log.d((String)AudioFocusAgent.LOGTAG, (String)"onAudioFocusChange, AUDIOFOCUS_LOSS");
                        AudioFocusAgent.this.notifyObservers("AudioFocusChanged", "lostAudioFocus");
                        break;
                    }
                    case -2: {
                        Log.d((String)AudioFocusAgent.LOGTAG, (String)"onAudioFocusChange, AUDIOFOCUS_LOSS_TRANSIENT");
                        AudioFocusAgent.this.notifyObservers("AudioFocusChanged", "lostAudioFocusTransiently");
                        break;
                    }
                    case 1: {
                        Log.d((String)AudioFocusAgent.LOGTAG, (String)"onAudioFocusChange, AUDIOFOCUS_GAIN");
                        AudioFocusAgent.this.notifyObservers("AudioFocusChanged", "gainAudioFocus");
                        break;
                    }
                }
            }
        };
    }

    @RobocopTarget
    public static AudioFocusAgent getInstance() {
        return SingletonHolder.INSTANCE;
    }

    private static boolean isAttachedToContext() {
        return mContext != null;
    }

    private void notifyObservers(String string2, String string3) {
        GeckoAppShell.notifyObservers(string2, string3);
    }

    private AudioFocusAgent() {
    }

    private void requestAudioFocusIfNeeded() {
        if (this.mIsOwningAudioFocus) {
            return;
        }
        int n = this.mAudioManager.requestAudioFocus(this.mAfChangeListener, 3, 1);
        String string2 = n == 1 ? "AudioFocus request granted" : "AudioFoucs request failed";
        Log.d((String)LOGTAG, (String)string2);
        if (n == 1) {
            this.mIsOwningAudioFocus = true;
        }
    }

    private void abandonAudioFocusIfNeeded() {
        if (!this.mIsOwningAudioFocus) {
            return;
        }
        Log.d((String)LOGTAG, (String)"Abandon AudioFocus");
        this.mAudioManager.abandonAudioFocus(this.mAfChangeListener);
        this.mIsOwningAudioFocus = false;
    }

    private static class SingletonHolder {
        private static final AudioFocusAgent INSTANCE = new AudioFocusAgent();

        private SingletonHolder() {
        }
    }
}

