/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.promotion;

import android.app.Activity;
import android.content.Context;
import android.database.Cursor;
import android.os.Bundle;
import android.util.Log;
import ch.boye.httpclientandroidlib.util.TextUtils;
import com.keepsafe.switchboard.SwitchBoard;
import java.lang.ref.WeakReference;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.gecko.AboutPages;
import org.mozilla.gecko.BrowserApp;
import org.mozilla.gecko.GeckoProfile;
import org.mozilla.gecko.Tab;
import org.mozilla.gecko.Tabs;
import org.mozilla.gecko.db.BrowserDB;
import org.mozilla.gecko.db.UrlAnnotations;
import org.mozilla.gecko.delegates.BrowserAppDelegate;
import org.mozilla.gecko.promotion.HomeScreenPrompt;
import org.mozilla.gecko.tabs.TabsPanel;
import org.mozilla.gecko.util.ThreadUtils;

public class AddToHomeScreenPromotion
extends BrowserAppDelegate
implements Tabs.OnTabsChangedListener {
    private static final String LOGTAG = "GeckoPromoteShortcut";
    private static final String EXPERIMENT_MINIMUM_TOTAL_VISITS = "minimumTotalVisits";
    private static final String EXPERIMENT_LAST_VISIT_MINIMUM_AGE = "lastVisitMinimumAgeMs";
    private static final String EXPERIMENT_LAST_VISIT_MAXIMUM_AGE = "lastVisitMaximumAgeMs";
    private WeakReference<Activity> activityReference;
    private boolean isEnabled;
    private boolean isInForeground;
    private int minimumVisits;
    private int lastVisitMinimumAgeMs;
    private int lastVisitMaximumAgeMs;

    @Override
    public void onCreate(BrowserApp browserApp, Bundle bundle) {
        this.activityReference = new WeakReference<BrowserApp>(browserApp);
        this.isInForeground = true;
        this.initializeExperiment((Context)browserApp);
    }

    @Override
    public void onResume(BrowserApp browserApp) {
        Tabs.registerOnTabsChangedListener(this);
    }

    @Override
    public void onPause(BrowserApp browserApp) {
        Tabs.unregisterOnTabsChangedListener(this);
    }

    @Override
    public void onTabsTrayShown(BrowserApp browserApp, TabsPanel tabsPanel) {
        this.isInForeground = false;
    }

    @Override
    public void onTabsTrayHidden(BrowserApp browserApp, TabsPanel tabsPanel) {
        this.isInForeground = true;
    }

    private void initializeExperiment(Context context) {
        if (!SwitchBoard.isInExperiment((Context)context, (String)"promote-add-to-homescreen")) {
            Log.v((String)LOGTAG, (String)"Experiment not enabled");
            return;
        }
        JSONObject jSONObject = SwitchBoard.getExperimentValuesFromJson((Context)context, (String)"promote-add-to-homescreen");
        if (jSONObject == null) {
            return;
        }
        try {
            this.initializeWithValues(jSONObject.getInt(EXPERIMENT_MINIMUM_TOTAL_VISITS), jSONObject.getInt(EXPERIMENT_LAST_VISIT_MINIMUM_AGE), jSONObject.getInt(EXPERIMENT_LAST_VISIT_MAXIMUM_AGE));
        }
        catch (JSONException jSONException) {
            Log.w((String)LOGTAG, (String)"Could not read experiment values", (Throwable)jSONException);
        }
    }

    private void initializeWithValues(int n, int n2, int n3) {
        this.isEnabled = true;
        this.minimumVisits = n;
        this.lastVisitMinimumAgeMs = n2;
        this.lastVisitMaximumAgeMs = n3;
    }

    @Override
    public void onTabChanged(final Tab tab, Tabs.TabEvents tabEvents, String string2) {
        if (tab == null) {
            return;
        }
        if (!Tabs.getInstance().isSelectedTab(tab)) {
            return;
        }
        if (Tabs.TabEvents.LOADED != tabEvents) {
            return;
        }
        if (!this.isInForeground) {
            return;
        }
        ThreadUtils.postToBackgroundThread((Runnable)new Runnable(){

            @Override
            public void run() {
                AddToHomeScreenPromotion.this.maybeShowPromotionForUrl(tab.getURL(), tab.getTitle());
            }
        });
    }

    private void maybeShowPromotionForUrl(String string2, String string3) {
        if (!this.isEnabled) {
            return;
        }
        Context context = (Context)this.activityReference.get();
        if (context == null) {
            return;
        }
        if (!this.shouldShowPromotion(context, string2, string3)) {
            return;
        }
        HomeScreenPrompt.show(context, string2, string3);
    }

    private boolean shouldShowPromotion(Context context, String string2, String string3) {
        if (TextUtils.isEmpty((CharSequence)string2) || TextUtils.isEmpty((CharSequence)string3)) {
            return false;
        }
        if (AboutPages.isAboutPage(string2)) {
            return false;
        }
        if (!string2.startsWith("https://")) {
            return false;
        }
        URLHistory uRLHistory = this.getHistoryForURL(context, string2);
        if (uRLHistory == null) {
            return false;
        }
        if (uRLHistory.visits < (long)this.minimumVisits) {
            return false;
        }
        if (uRLHistory.lastVisit > System.currentTimeMillis() - (long)this.lastVisitMinimumAgeMs) {
            return false;
        }
        if (uRLHistory.lastVisit < System.currentTimeMillis() - (long)this.lastVisitMaximumAgeMs) {
            return false;
        }
        return !this.hasAcceptedOrDeclinedHomeScreenShortcut(context, string2);
    }

    protected boolean hasAcceptedOrDeclinedHomeScreenShortcut(Context context, String string2) {
        UrlAnnotations urlAnnotations = GeckoProfile.get(context).getDB().getUrlAnnotations();
        return urlAnnotations.hasAcceptedOrDeclinedHomeScreenShortcut(context.getContentResolver(), string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected URLHistory getHistoryForURL(Context context, String string2) {
        GeckoProfile geckoProfile = GeckoProfile.get(context);
        BrowserDB browserDB = geckoProfile.getDB();
        try (Cursor cursor = null;){
            cursor = browserDB.getHistoryForURL(context.getContentResolver(), string2);
            if (cursor.moveToFirst()) {
                URLHistory uRLHistory = new URLHistory(cursor.getInt(cursor.getColumnIndex("visits")), cursor.getLong(cursor.getColumnIndex("date")));
                return uRLHistory;
            }
        }
        return null;
    }

    private static class URLHistory {
        public final long visits;
        public final long lastVisit;

        private URLHistory(long l, long l2) {
            this.visits = l;
            this.lastVisit = l2;
        }
    }
}

