/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.promotion;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import com.keepsafe.switchboard.SwitchBoard;
import org.mozilla.gecko.BrowserApp;
import org.mozilla.gecko.GeckoSharedPrefs;
import org.mozilla.gecko.R;
import org.mozilla.gecko.Tab;
import org.mozilla.gecko.Tabs;
import org.mozilla.gecko.delegates.BrowserAppDelegateWithReference;
import org.mozilla.gecko.promotion.SimpleHelperUI;
import org.mozilla.gecko.reader.ReaderModeUtils;

public class ReaderViewBookmarkPromotion
extends BrowserAppDelegateWithReference
implements Tabs.OnTabsChangedListener {
    private static final String PREF_FIRST_RV_HINT_SHOWN = "first_reader_view_hint_shown";
    private static final String FIRST_READERVIEW_OPEN_TELEMETRYEXTRA = "first_readerview_open_prompt";
    private boolean hasEnteredReaderMode = false;

    @Override
    public void onResume(BrowserApp browserApp) {
        Tabs.registerOnTabsChangedListener(this);
    }

    @Override
    public void onPause(BrowserApp browserApp) {
        Tabs.unregisterOnTabsChangedListener(this);
    }

    @Override
    public void onTabChanged(Tab tab, Tabs.TabEvents tabEvents, String string2) {
        switch (tabEvents) {
            case LOCATION_CHANGE: {
                boolean bl = ReaderModeUtils.isEnteringReaderMode(tab.getURL(), string2);
                if (this.hasEnteredReaderMode || !bl) break;
                this.hasEnteredReaderMode = true;
                this.promoteBookmarking();
            }
        }
    }

    @Override
    public void onActivityResult(BrowserApp browserApp, int n, int n2, Intent intent) {
        switch (n) {
            case 4001: {
                if (n2 == 4002) {
                    Tab tab = Tabs.getInstance().getSelectedTab();
                    if (tab == null) break;
                    tab.addBookmark();
                    break;
                }
                if (n2 != 4003) break;
            }
        }
    }

    private void promoteBookmarking() {
        BrowserApp browserApp = this.getBrowserApp();
        if (browserApp == null) {
            return;
        }
        SharedPreferences sharedPreferences = GeckoSharedPrefs.forProfile((Context)browserApp);
        boolean bl = SwitchBoard.isInExperiment((Context)browserApp, (String)"triple-readerview-bookmark-prompt");
        if (!bl || sharedPreferences.getBoolean(PREF_FIRST_RV_HINT_SHOWN, false)) {
            return;
        }
        SimpleHelperUI.show((Activity)browserApp, FIRST_READERVIEW_OPEN_TELEMETRYEXTRA, 4001, R.string.helper_triple_readerview_open_title, R.string.helper_triple_readerview_open_message, R.drawable.helper_readerview_bookmark, R.string.helper_triple_readerview_open_button, 4002, 4003);
        sharedPreferences.edit().putBoolean(PREF_FIRST_RV_HINT_SHOWN, true).apply();
    }
}

