/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.telemetry;

import android.content.Context;
import android.content.SharedPreferences;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import android.util.Log;
import java.io.IOException;
import java.lang.ref.WeakReference;
import org.mozilla.gecko.BrowserApp;
import org.mozilla.gecko.GeckoProfile;
import org.mozilla.gecko.GeckoSharedPrefs;
import org.mozilla.gecko.search.SearchEngine;
import org.mozilla.gecko.search.SearchEngineManager;
import org.mozilla.gecko.sync.ExtendedJSONObject;
import org.mozilla.gecko.telemetry.TelemetryUploadService;
import org.mozilla.gecko.telemetry.measurements.SearchCountMeasurements;
import org.mozilla.gecko.telemetry.measurements.SessionMeasurements;
import org.mozilla.gecko.telemetry.pingbuilders.TelemetryCorePingBuilder;
import org.mozilla.gecko.util.StringUtils;
import org.mozilla.gecko.util.ThreadUtils;

public class UploadTelemetryCorePingCallback
implements SearchEngineManager.SearchEngineCallback {
    private static final String LOGTAG = StringUtils.safeSubstring((String)("Gecko" + UploadTelemetryCorePingCallback.class.getSimpleName()), (int)0, (int)23);
    private final WeakReference<BrowserApp> activityWeakReference;

    public UploadTelemetryCorePingCallback(BrowserApp browserApp) {
        this.activityWeakReference = new WeakReference<BrowserApp>(browserApp);
    }

    @Override
    public void execute(final @Nullable SearchEngine searchEngine) {
        if (this.activityWeakReference.get() == null) {
            return;
        }
        ThreadUtils.postToBackgroundThread((Runnable)new Runnable(){

            @Override
            @WorkerThread
            public void run() {
                String string2;
                BrowserApp browserApp = (BrowserApp)UploadTelemetryCorePingCallback.this.activityWeakReference.get();
                if (browserApp == null) {
                    return;
                }
                GeckoProfile geckoProfile = browserApp.getProfile();
                if (!TelemetryUploadService.isUploadEnabledByProfileConfig((Context)browserApp, geckoProfile)) {
                    Log.d((String)LOGTAG, (String)"Core ping upload disabled by profile config. Returning.");
                    return;
                }
                try {
                    string2 = geckoProfile.getClientId();
                }
                catch (IOException iOException) {
                    Log.w((String)LOGTAG, (String)("Unable to get client ID to generate core ping: " + iOException));
                    return;
                }
                SharedPreferences sharedPreferences = GeckoSharedPrefs.forProfileName((Context)browserApp, geckoProfile.getName());
                SessionMeasurements.SessionMeasurementsContainer sessionMeasurementsContainer = browserApp.getSessionMeasurementDelegate().getAndResetSessionMeasurements((Context)browserApp);
                TelemetryCorePingBuilder telemetryCorePingBuilder = new TelemetryCorePingBuilder((Context)browserApp).setClientID(string2).setDefaultSearchEngine(TelemetryCorePingBuilder.getEngineIdentifier(searchEngine)).setProfileCreationDate(TelemetryCorePingBuilder.getProfileCreationDate((Context)browserApp, geckoProfile)).setSequenceNumber(TelemetryCorePingBuilder.getAndIncrementSequenceNumber(sharedPreferences)).setSessionCount(sessionMeasurementsContainer.sessionCount).setSessionDuration(sessionMeasurementsContainer.elapsedSeconds);
                UploadTelemetryCorePingCallback.maybeSetOptionalMeasurements(sharedPreferences, telemetryCorePingBuilder);
                browserApp.getTelemetryDispatcher().queuePingForUpload((Context)browserApp, telemetryCorePingBuilder);
            }
        });
    }

    private static void maybeSetOptionalMeasurements(SharedPreferences sharedPreferences, TelemetryCorePingBuilder telemetryCorePingBuilder) {
        ExtendedJSONObject extendedJSONObject;
        String string2 = sharedPreferences.getString("distribution.id", null);
        if (string2 != null) {
            telemetryCorePingBuilder.setOptDistributionID(string2);
        }
        if ((extendedJSONObject = SearchCountMeasurements.getAndZeroSearch(sharedPreferences)).size() > 0) {
            telemetryCorePingBuilder.setOptSearchCounts(extendedJSONObject);
        }
    }
}

