/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.telemetry.pingbuilders;

import java.util.Set;
import java.util.UUID;
import org.mozilla.gecko.sync.ExtendedJSONObject;
import org.mozilla.gecko.telemetry.TelemetryPing;

abstract class TelemetryPingBuilder {
    private static final String SERVER_INITIAL_PATH = "submit/telemetry";
    private final String serverPath;
    protected final ExtendedJSONObject payload;
    private final String docID = UUID.randomUUID().toString();

    public TelemetryPingBuilder() {
        this.serverPath = TelemetryPingBuilder.getTelemetryServerPath(this.getDocType(), this.docID);
        this.payload = new ExtendedJSONObject();
    }

    public abstract String getDocType();

    public abstract String[] getMandatoryFields();

    public TelemetryPing build() {
        this.validatePayload();
        return new TelemetryPing(this.serverPath, this.payload, this.docID);
    }

    private void validatePayload() {
        Set set = this.payload.keySet();
        for (String string2 : this.getMandatoryFields()) {
            if (set.contains(string2)) continue;
            throw new IllegalArgumentException("Builder does not contain mandatory field: " + string2);
        }
    }

    private static String getTelemetryServerPath(String string2, String string3) {
        return "submit/telemetry/" + string3 + '/' + string2 + '/' + "Fennec" + '/' + "49.0a1" + '/' + "nightly" + '/' + "20160601061753";
    }
}

