/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.telemetry.stores;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.WorkerThread;
import android.util.Log;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.gecko.sync.ExtendedJSONObject;
import org.mozilla.gecko.sync.NonObjectJSONException;
import org.mozilla.gecko.telemetry.TelemetryPing;
import org.mozilla.gecko.telemetry.stores.TelemetryPingStore;
import org.mozilla.gecko.util.FileUtils;
import org.mozilla.gecko.util.StringUtils;
import org.mozilla.gecko.util.UUIDUtil;

public class TelemetryJSONFilePingStore
implements TelemetryPingStore {
    private static final String LOGTAG = StringUtils.safeSubstring((String)("Gecko" + TelemetryJSONFilePingStore.class.getSimpleName()), (int)0, (int)23);
    static final int MAX_PING_COUNT = 40;
    static final String KEY_PAYLOAD = "p";
    static final String KEY_URL_PATH = "u";
    private final File storeDir;
    private final FilenameFilter uuidFilenameFilter;
    private final FileUtils.FileLastModifiedComparator fileLastModifiedComparator = new FileUtils.FileLastModifiedComparator();
    public static final Parcelable.Creator<TelemetryJSONFilePingStore> CREATOR = new Parcelable.Creator<TelemetryJSONFilePingStore>(){

        public TelemetryJSONFilePingStore createFromParcel(Parcel parcel) {
            String string2 = parcel.readString();
            return new TelemetryJSONFilePingStore(new File(string2));
        }

        public TelemetryJSONFilePingStore[] newArray(int n) {
            return new TelemetryJSONFilePingStore[n];
        }
    };

    @WorkerThread
    public TelemetryJSONFilePingStore(File file) {
        this.storeDir = file;
        this.storeDir.mkdirs();
        this.uuidFilenameFilter = new FileUtils.FilenameRegexFilter(UUIDUtil.UUID_PATTERN);
    }

    File getPingFile(String string2) {
        return new File(this.storeDir, string2);
    }

    @Override
    public void storePing(TelemetryPing telemetryPing) throws IOException {
        String string2;
        try {
            string2 = new JSONObject().put(KEY_PAYLOAD, (Object)telemetryPing.getPayload()).put(KEY_URL_PATH, (Object)telemetryPing.getURLPath()).toString();
        }
        catch (JSONException jSONException) {
            throw new IOException("Unable to create JSON to store to disk");
        }
        FileOutputStream fileOutputStream = new FileOutputStream(this.getPingFile(telemetryPing.getDocID()), false);
        TelemetryJSONFilePingStore.blockForLockAndWriteFileAndCloseStream(fileOutputStream, string2);
    }

    @Override
    public void maybePrunePings() {
        File[] fileArray = this.storeDir.listFiles(this.uuidFilenameFilter);
        if (fileArray.length < 40) {
            return;
        }
        TreeSet<File> treeSet = new TreeSet<File>((Comparator<File>)this.fileLastModifiedComparator);
        treeSet.addAll(Arrays.asList(fileArray));
        this.deleteSmallestFiles(treeSet, fileArray.length - 40);
    }

    private void deleteSmallestFiles(SortedSet<File> sortedSet, int n) {
        Iterator iterator = sortedSet.iterator();
        for (int i = 0; i < n; ++i) {
            File file = (File)iterator.next();
            file.delete();
        }
    }

    public ArrayList<TelemetryPing> getAllPings() {
        List<File> list = Arrays.asList(this.storeDir.listFiles(this.uuidFilenameFilter));
        Collections.sort(list, this.fileLastModifiedComparator);
        ArrayList<TelemetryPing> arrayList = new ArrayList<TelemetryPing>(list.size());
        for (File file : list) {
            JSONObject jSONObject = this.lockAndReadJSONFromFile(file);
            if (jSONObject == null) continue;
            try {
                String string2 = jSONObject.getString(KEY_URL_PATH);
                ExtendedJSONObject extendedJSONObject = new ExtendedJSONObject(jSONObject.getString(KEY_PAYLOAD));
                arrayList.add(new TelemetryPing(string2, extendedJSONObject, file.getName()));
            }
            catch (IOException | JSONException | NonObjectJSONException throwable) {
                Log.w((String)LOGTAG, (String)"Bad json in ping. Ignoring.");
            }
        }
        return arrayList;
    }

    private JSONObject lockAndReadJSONFromFile(File file) {
        JSONObject jSONObject;
        FileInputStream fileInputStream;
        if (file.length() == 0L) {
            Log.w((String)LOGTAG, (String)("Unexpected empty file: " + file.getName() + ". Ignoring"));
            return null;
        }
        try {
            fileInputStream = new FileInputStream(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new IllegalStateException("Expected file to exist");
        }
        try {
            jSONObject = TelemetryJSONFilePingStore.lockAndReadFileAndCloseStream(fileInputStream, (int)file.length());
        }
        catch (IOException | JSONException throwable) {
            Log.w((String)LOGTAG, (String)("Error when reading file: " + file.getName() + " Likely corrupted. Ignoring"));
            return null;
        }
        if (jSONObject == null) {
            Log.d((String)LOGTAG, (String)("Could not read given file: " + file.getName() + " File is locked. Ignoring"));
        }
        return jSONObject;
    }

    @Override
    public void onUploadAttemptComplete(Set<String> set) {
        File[] fileArray;
        if (set.isEmpty()) {
            return;
        }
        for (File file : fileArray = this.storeDir.listFiles((FilenameFilter)new FileUtils.FilenameWhitelistFilter(set))) {
            file.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void blockForLockAndWriteFileAndCloseStream(FileOutputStream fileOutputStream, String string2) throws IOException {
        try {
            FileLock fileLock = fileOutputStream.getChannel().lock(0L, Long.MAX_VALUE, false);
            if (fileLock != null) {
                FileUtils.writeStringToOutputStreamAndCloseStream((OutputStream)fileOutputStream, (String)string2);
            }
        }
        finally {
            fileOutputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JSONObject lockAndReadFileAndCloseStream(FileInputStream fileInputStream, int n) throws IOException, JSONException {
        try {
            FileLock fileLock = fileInputStream.getChannel().tryLock(0L, Long.MAX_VALUE, true);
            if (fileLock == null) {
                JSONObject jSONObject = null;
                return jSONObject;
            }
            JSONObject jSONObject = new JSONObject(FileUtils.readStringFromInputStreamAndCloseStream((InputStream)fileInputStream, (int)n));
            return jSONObject;
        }
        finally {
            fileInputStream.close();
        }
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeString(this.storeDir.getAbsolutePath());
    }
}

