/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.text;

import android.annotation.TargetApi;
import android.app.Activity;
import android.graphics.Rect;
import android.util.Log;
import android.view.ActionMode;
import ch.boye.httpclientandroidlib.util.TextUtils;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.gecko.EventDispatcher;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.Telemetry;
import org.mozilla.gecko.TelemetryContract;
import org.mozilla.gecko.gfx.LayerView;
import org.mozilla.gecko.text.FloatingActionModeCallback;
import org.mozilla.gecko.text.TextAction;
import org.mozilla.gecko.text.TextSelection;
import org.mozilla.gecko.util.GeckoEventListener;
import org.mozilla.gecko.util.ThreadUtils;

@TargetApi(value=23)
public class FloatingToolbarTextSelection
implements TextSelection,
GeckoEventListener {
    private static final String LOGTAG = "GeckoFloatTextSelection";
    private Activity activity;
    private ActionMode actionMode;
    private FloatingActionModeCallback actionModeCallback;
    private LayerView layerView;
    private int[] locationInWindow;
    private String selectionID;
    Rect contentRect;

    public FloatingToolbarTextSelection(Activity activity, LayerView layerView) {
        this.activity = activity;
        this.layerView = layerView;
        this.locationInWindow = new int[2];
    }

    @Override
    public boolean dismiss() {
        if (this.finishActionMode()) {
            this.endTextSelection();
            return true;
        }
        return false;
    }

    private void endTextSelection() {
        if (TextUtils.isEmpty((CharSequence)this.selectionID)) {
            return;
        }
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("selectionID", (Object)this.selectionID);
        }
        catch (JSONException jSONException) {
            Log.e((String)LOGTAG, (String)"Error building JSON arguments for TextSelection:End", (Throwable)jSONException);
            return;
        }
        GeckoAppShell.notifyObservers("TextSelection:End", jSONObject.toString());
    }

    @Override
    public void create() {
        this.registerForEvents();
    }

    @Override
    public void destroy() {
        this.unregisterFromEvents();
    }

    private void registerForEvents() {
        EventDispatcher.getInstance().registerGeckoThreadListener(this, "TextSelection:ActionbarInit", "TextSelection:ActionbarStatus", "TextSelection:ActionbarUninit", "TextSelection:Update", "TextSelection:Visibility");
    }

    private void unregisterFromEvents() {
        EventDispatcher.getInstance().unregisterGeckoThreadListener(this, "TextSelection:ActionbarInit", "TextSelection:ActionbarStatus", "TextSelection:ActionbarUninit", "TextSelection:Update", "TextSelection:Visibility");
    }

    public void handleMessage(final String string2, final JSONObject jSONObject) {
        ThreadUtils.postToUiThread((Runnable)new Runnable(){

            @Override
            public void run() {
                FloatingToolbarTextSelection.this.handleOnMainThread(string2, jSONObject);
            }
        });
    }

    private void handleOnMainThread(String string2, JSONObject jSONObject) {
        if ("TextSelection:ActionbarInit".equals(string2)) {
            Telemetry.sendUIEvent(TelemetryContract.Event.SHOW, TelemetryContract.Method.CONTENT, "text_selection");
            this.selectionID = jSONObject.optString("selectionID");
        } else if ("TextSelection:ActionbarStatus".equals(string2)) {
            if (this.selectionID != jSONObject.optString("selectionID")) {
                return;
            }
            this.updateRect(jSONObject);
            if (!this.isRectVisible()) {
                this.finishActionMode();
            } else {
                this.startActionMode(TextAction.fromEventMessage(jSONObject));
            }
        } else if ("TextSelection:ActionbarUninit".equals(string2)) {
            this.finishActionMode();
        } else if ("TextSelection:Update".equals(string2)) {
            this.startActionMode(TextAction.fromEventMessage(jSONObject));
        } else if ("TextSelection:Visibility".equals(string2)) {
            this.finishActionMode();
        }
    }

    private void startActionMode(List<TextAction> list) {
        if (this.actionMode != null) {
            this.actionModeCallback.updateActions(list);
            this.actionMode.invalidate();
            return;
        }
        this.actionModeCallback = new FloatingActionModeCallback(this, list);
        this.actionMode = this.activity.startActionMode((ActionMode.Callback)this.actionModeCallback, 1);
    }

    private boolean finishActionMode() {
        if (this.actionMode != null) {
            this.actionMode.finish();
            this.actionMode = null;
            this.actionModeCallback = null;
            return true;
        }
        return false;
    }

    private boolean isRectVisible() {
        return this.contentRect.left != this.contentRect.right || this.contentRect.top != this.contentRect.bottom;
    }

    private void updateRect(JSONObject jSONObject) {
        try {
            double d = jSONObject.getDouble("x");
            double d2 = (int)jSONObject.getDouble("y");
            double d3 = (int)jSONObject.getDouble("width");
            double d4 = (int)jSONObject.getDouble("height");
            float f = this.layerView.getZoomFactor();
            this.layerView.getLocationInWindow(this.locationInWindow);
            this.contentRect = new Rect((int)(d * (double)f + (double)this.locationInWindow[0]), (int)(d2 * (double)f + (double)this.locationInWindow[1] + (double)this.layerView.getSurfaceTranslation()), (int)((d + d3) * (double)f + (double)this.locationInWindow[0]), (int)((d2 + d4) * (double)f + (double)this.locationInWindow[1] + (double)this.layerView.getSurfaceTranslation()));
        }
        catch (JSONException jSONException) {
            Log.w((String)LOGTAG, (String)"Could not calculate content rect", (Throwable)jSONException);
        }
    }
}

