/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.trackingprotection;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.MotionEvent;
import android.view.View;
import org.mozilla.gecko.Locales;
import org.mozilla.gecko.R;
import org.mozilla.gecko.preferences.GeckoPreferences;
import org.mozilla.gecko.util.HardwareUtils;

public class TrackingProtectionPrompt
extends Locales.LocaleAwareActivity {
    public static final String LOGTAG = "Gecko" + TrackingProtectionPrompt.class.getSimpleName();
    private boolean isAnimating;
    private View containerView;

    protected void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        this.showPrompt();
    }

    private void showPrompt() {
        this.setContentView(R.layout.tracking_protection_prompt);
        this.findViewById(R.id.ok_button).setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                TrackingProtectionPrompt.this.onConfirmButtonPressed();
            }
        });
        this.findViewById(R.id.link_text).setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                TrackingProtectionPrompt.this.slideOut();
                Intent intent = new Intent((Context)TrackingProtectionPrompt.this, GeckoPreferences.class);
                GeckoPreferences.setResourceToOpen(intent, "preferences_privacy");
                TrackingProtectionPrompt.this.startActivity(intent);
                if (HardwareUtils.IS_KINDLE_DEVICE) {
                    TrackingProtectionPrompt.this.overridePendingTransition(0, 0);
                }
            }
        });
        this.containerView = this.findViewById(R.id.tracking_protection_inner_container);
        this.containerView.setTranslationY(500.0f);
        this.containerView.setAlpha(0.0f);
        ObjectAnimator objectAnimator = ObjectAnimator.ofFloat((Object)this.containerView, (String)"translationY", (float[])new float[]{0.0f});
        objectAnimator.setDuration(400L);
        ObjectAnimator objectAnimator2 = ObjectAnimator.ofFloat((Object)this.containerView, (String)"alpha", (float[])new float[]{1.0f});
        objectAnimator2.setStartDelay(200L);
        objectAnimator2.setDuration(600L);
        AnimatorSet animatorSet = new AnimatorSet();
        animatorSet.playTogether(new Animator[]{objectAnimator2, objectAnimator});
        animatorSet.setStartDelay(400L);
        animatorSet.start();
    }

    public void finish() {
        super.finish();
        this.overridePendingTransition(0, 0);
    }

    private void onConfirmButtonPressed() {
        this.slideOut();
    }

    private void slideOut() {
        if (this.isAnimating) {
            return;
        }
        this.isAnimating = true;
        ObjectAnimator objectAnimator = ObjectAnimator.ofFloat((Object)this.containerView, (String)"translationY", (float[])new float[]{this.containerView.getHeight()});
        objectAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animator) {
                TrackingProtectionPrompt.this.finish();
            }
        });
        objectAnimator.start();
    }

    public void onBackPressed() {
        this.slideOut();
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        this.slideOut();
        return true;
    }
}

