/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.updater;

import android.app.AlarmManager;
import android.app.IntentService;
import android.app.Notification;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.net.wifi.WifiManager;
import android.os.Environment;
import android.support.v4.app.NotificationCompat;
import android.support.v4.app.NotificationManagerCompat;
import android.support.v4.content.ContextCompat;
import android.support.v4.net.ConnectivityManagerCompat;
import android.util.Log;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.mozilla.apache.commons.codec.binary.Hex;
import org.mozilla.gecko.CrashHandler;
import org.mozilla.gecko.R;
import org.mozilla.gecko.permissions.Permissions;
import org.mozilla.gecko.updater.UpdateServiceHelper;
import org.mozilla.gecko.util.ProxySelector;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class UpdateService
extends IntentService {
    private static final int BUFSIZE = 8192;
    private static final int NOTIFICATION_ID = 1044438461;
    private static final String LOGTAG = "UpdateService";
    private static final int INTERVAL_LONG = 86400000;
    private static final int INTERVAL_SHORT = 14400000;
    private static final int INTERVAL_RETRY = 3600000;
    private static final String PREFS_NAME = "UpdateService";
    private static final String KEY_LAST_BUILDID = "UpdateService.lastBuildID";
    private static final String KEY_LAST_HASH_FUNCTION = "UpdateService.lastHashFunction";
    private static final String KEY_LAST_HASH_VALUE = "UpdateService.lastHashValue";
    private static final String KEY_LAST_FILE_NAME = "UpdateService.lastFileName";
    private static final String KEY_LAST_ATTEMPT_DATE = "UpdateService.lastAttemptDate";
    private static final String KEY_AUTODOWNLOAD_POLICY = "UpdateService.autoDownloadPolicy";
    private static final String KEY_UPDATE_URL = "UpdateService.updateUrl";
    private SharedPreferences mPrefs;
    private NotificationManagerCompat mNotificationManager;
    private ConnectivityManager mConnectivityManager;
    private NotificationCompat.Builder mBuilder;
    private volatile WifiManager.WifiLock mWifiLock;
    private boolean mDownloading;
    private boolean mCancelDownload;
    private boolean mApplyImmediately;
    private CrashHandler mCrashHandler;

    public UpdateService() {
        super("updater");
    }

    public void onCreate() {
        this.mCrashHandler = CrashHandler.createDefaultCrashHandler(this.getApplicationContext());
        super.onCreate();
        this.mPrefs = this.getSharedPreferences("UpdateService", 0);
        this.mNotificationManager = NotificationManagerCompat.from((Context)this);
        this.mConnectivityManager = (ConnectivityManager)this.getSystemService("connectivity");
        this.mWifiLock = ((WifiManager)this.getSystemService("wifi")).createWifiLock(3, "UpdateService");
        this.mCancelDownload = false;
    }

    public void onDestroy() {
        this.mCrashHandler.unregister();
        this.mCrashHandler = null;
        if (this.mWifiLock.isHeld()) {
            this.mWifiLock.release();
        }
    }

    public synchronized int onStartCommand(Intent intent, int n, int n2) {
        if (this.mDownloading && "org.mozilla.fennec.APPLY_UPDATE".equals(intent.getAction())) {
            Log.i((String)"UpdateService", (String)"will apply update when download finished");
            this.mApplyImmediately = true;
            this.showDownloadNotification();
        } else if ("org.mozilla.fennec.CANCEL_DOWNLOAD".equals(intent.getAction())) {
            this.mCancelDownload = true;
        } else {
            super.onStartCommand(intent, n, n2);
        }
        return 3;
    }

    protected void onHandleIntent(Intent intent) {
        if ("org.mozilla.fennec.REGISTER_FOR_UPDATES".equals(intent.getAction())) {
            String string2;
            AutoDownloadPolicy autoDownloadPolicy = AutoDownloadPolicy.get(intent.getIntExtra("autodownload", AutoDownloadPolicy.NONE.value));
            if (autoDownloadPolicy != AutoDownloadPolicy.NONE) {
                this.setAutoDownloadPolicy(autoDownloadPolicy);
            }
            if ((string2 = intent.getStringExtra("updateUrl")) != null) {
                this.setUpdateUrl(string2);
            }
            this.registerForUpdates(false);
        } else if ("org.mozilla.fennec.CHECK_FOR_UPDATE".equals(intent.getAction())) {
            this.startUpdate(intent.getIntExtra("updateFlags", 0));
        } else if ("org.mozilla.fennec.DOWNLOAD_UPDATE".equals(intent.getAction())) {
            this.mApplyImmediately = true;
            this.startUpdate(1);
        } else if ("org.mozilla.fennec.APPLY_UPDATE".equals(intent.getAction())) {
            this.applyUpdate(intent.getStringExtra("packagePath"));
        }
    }

    private static boolean hasFlag(int n, int n2) {
        return (n & n2) == n2;
    }

    private void sendCheckUpdateResult(CheckUpdateResult checkUpdateResult) {
        Intent intent = new Intent("org.mozilla.fennec.CHECK_UPDATE_RESULT");
        intent.putExtra("result", checkUpdateResult.toString());
        this.sendBroadcast(intent);
    }

    private int getUpdateInterval(boolean bl) {
        int n = bl ? 3600000 : 14400000;
        return n;
    }

    private void registerForUpdates(boolean bl) {
        Calendar calendar = this.getLastAttemptDate();
        GregorianCalendar gregorianCalendar = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
        int n = this.getUpdateInterval(bl);
        if (calendar == null || gregorianCalendar.getTimeInMillis() - calendar.getTimeInMillis() > (long)n) {
            Log.i((String)"UpdateService", (String)"no update has ever been attempted, checking now");
            this.startUpdate(0);
            return;
        }
        AlarmManager alarmManager = (AlarmManager)this.getSystemService("alarm");
        if (alarmManager == null) {
            return;
        }
        PendingIntent pendingIntent = PendingIntent.getService((Context)this, (int)0, (Intent)new Intent("org.mozilla.fennec.CHECK_FOR_UPDATE", null, (Context)this, UpdateService.class), (int)0x8000000);
        alarmManager.cancel(pendingIntent);
        calendar.setTimeInMillis(calendar.getTimeInMillis() + (long)n);
        Log.i((String)"UpdateService", (String)("next update will be at: " + calendar.getTime()));
        alarmManager.set(0, calendar.getTimeInMillis(), pendingIntent);
    }

    private void startUpdate(final int n) {
        boolean bl;
        this.setLastAttemptDate();
        NetworkInfo networkInfo = this.mConnectivityManager.getActiveNetworkInfo();
        if (networkInfo == null || !networkInfo.isConnected()) {
            Log.i((String)"UpdateService", (String)"not connected to the network");
            this.registerForUpdates(true);
            this.sendCheckUpdateResult(CheckUpdateResult.NOT_AVAILABLE);
            return;
        }
        this.registerForUpdates(false);
        final UpdateInfo updateInfo = this.findUpdate(UpdateService.hasFlag(n, 4));
        boolean bl2 = bl = updateInfo != null;
        if (!bl) {
            Log.i((String)"UpdateService", (String)"no update available");
            this.sendCheckUpdateResult(CheckUpdateResult.NOT_AVAILABLE);
            return;
        }
        Log.i((String)"UpdateService", (String)("update available, buildID = " + updateInfo.buildID));
        Permissions.from((Context)this).withPermissions("android.permission.WRITE_EXTERNAL_STORAGE").doNotPrompt().andFallback(new Runnable(){

            @Override
            public void run() {
                UpdateService.this.showPermissionNotification();
                UpdateService.this.sendCheckUpdateResult(CheckUpdateResult.NOT_AVAILABLE);
            }
        }).run(new Runnable(){

            @Override
            public void run() {
                UpdateService.this.startDownload(updateInfo, n);
            }
        });
    }

    private void startDownload(UpdateInfo updateInfo, int n) {
        boolean bl;
        AutoDownloadPolicy autoDownloadPolicy = this.getAutoDownloadPolicy();
        boolean bl2 = bl = UpdateService.hasFlag(n, 1) || autoDownloadPolicy == AutoDownloadPolicy.ENABLED || autoDownloadPolicy == AutoDownloadPolicy.WIFI && !ConnectivityManagerCompat.isActiveNetworkMetered((ConnectivityManager)this.mConnectivityManager);
        if (!bl) {
            Log.i((String)"UpdateService", (String)("not initiating automatic update download due to policy " + autoDownloadPolicy.toString()));
            this.sendCheckUpdateResult(CheckUpdateResult.AVAILABLE);
            Intent intent = new Intent("org.mozilla.fennec.DOWNLOAD_UPDATE");
            intent.setClass((Context)this, UpdateService.class);
            PendingIntent pendingIntent = PendingIntent.getService((Context)this, (int)0, (Intent)intent, (int)0x8000000);
            NotificationCompat.Builder builder = new NotificationCompat.Builder((Context)this);
            builder.setSmallIcon(R.drawable.ic_status_logo);
            builder.setWhen(System.currentTimeMillis());
            builder.setAutoCancel(true);
            builder.setContentTitle((CharSequence)this.getString(R.string.updater_start_title));
            builder.setContentText((CharSequence)this.getString(R.string.updater_start_select));
            builder.setContentIntent(pendingIntent);
            this.mNotificationManager.notify(1044438461, builder.build());
            return;
        }
        File file = this.downloadUpdatePackage(updateInfo, UpdateService.hasFlag(n, 2));
        if (file == null) {
            this.sendCheckUpdateResult(CheckUpdateResult.NOT_AVAILABLE);
            return;
        }
        Log.i((String)"UpdateService", (String)("have update package at " + file));
        this.saveUpdateInfo(updateInfo, file);
        this.sendCheckUpdateResult(CheckUpdateResult.DOWNLOADED);
        if (this.mApplyImmediately) {
            this.applyUpdate(file);
        } else {
            Intent intent = new Intent("org.mozilla.fennec.APPLY_UPDATE");
            intent.setClass((Context)this, UpdateService.class);
            intent.putExtra("packagePath", file.getAbsolutePath());
            PendingIntent pendingIntent = PendingIntent.getService((Context)this, (int)0, (Intent)intent, (int)0x8000000);
            NotificationCompat.Builder builder = new NotificationCompat.Builder((Context)this);
            builder.setSmallIcon(R.drawable.ic_status_logo);
            builder.setWhen(System.currentTimeMillis());
            builder.setAutoCancel(true);
            builder.setContentTitle((CharSequence)this.getString(R.string.updater_apply_title));
            builder.setContentText((CharSequence)this.getString(R.string.updater_apply_select));
            builder.setContentIntent(pendingIntent);
            this.mNotificationManager.notify(1044438461, builder.build());
        }
    }

    private UpdateInfo findUpdate(boolean bl) {
        try {
            URI uRI = this.getUpdateURI(bl);
            if (uRI == null) {
                Log.e((String)"UpdateService", (String)"failed to get update URI");
                return null;
            }
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = documentBuilder.parse(ProxySelector.openConnectionWithProxy((URI)uRI).getInputStream());
            NodeList nodeList = document.getElementsByTagName("update");
            if (nodeList == null || nodeList.getLength() == 0) {
                return null;
            }
            Node node = nodeList.item(0);
            Node node2 = node.getAttributes().getNamedItem("buildID");
            if (node2 == null) {
                return null;
            }
            nodeList = document.getElementsByTagName("patch");
            if (nodeList == null || nodeList.getLength() == 0) {
                return null;
            }
            Node node3 = nodeList.item(0);
            Node node4 = node3.getAttributes().getNamedItem("URL");
            Node node5 = node3.getAttributes().getNamedItem("hashFunction");
            Node node6 = node3.getAttributes().getNamedItem("hashValue");
            Node node7 = node3.getAttributes().getNamedItem("size");
            if (node4 == null || node5 == null || node6 == null || node7 == null) {
                return null;
            }
            UpdateInfo updateInfo = new UpdateInfo();
            updateInfo.uri = new URI(node4.getTextContent());
            updateInfo.buildID = node2.getTextContent();
            updateInfo.hashFunction = node5.getTextContent();
            updateInfo.hashValue = node6.getTextContent();
            try {
                updateInfo.size = Integer.parseInt(node7.getTextContent());
            }
            catch (NumberFormatException numberFormatException) {
                Log.e((String)"UpdateService", (String)"Failed to find APK size: ", (Throwable)numberFormatException);
                return null;
            }
            if (!updateInfo.isValid()) {
                Log.e((String)"UpdateService", (String)("missing some required update information, have: " + updateInfo));
                return null;
            }
            return updateInfo;
        }
        catch (Exception exception) {
            Log.e((String)"UpdateService", (String)"failed to check for update: ", (Throwable)exception);
            return null;
        }
    }

    private MessageDigest createMessageDigest(String string2) {
        String string3 = null;
        if (!"sha512".equalsIgnoreCase(string2)) {
            Log.e((String)"UpdateService", (String)("Unhandled hash function: " + string2));
            return null;
        }
        string3 = "SHA-512";
        try {
            return MessageDigest.getInstance(string3);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            Log.e((String)"UpdateService", (String)("Couldn't find algorithm " + string3), (Throwable)noSuchAlgorithmException);
            return null;
        }
    }

    private void showDownloadNotification() {
        this.showDownloadNotification(null);
    }

    private void showDownloadNotification(File file) {
        Intent intent = new Intent("org.mozilla.fennec.APPLY_UPDATE");
        intent.setClass((Context)this, UpdateService.class);
        Intent intent2 = new Intent("org.mozilla.fennec.CANCEL_DOWNLOAD");
        intent2.setClass((Context)this, UpdateService.class);
        if (file != null) {
            intent.putExtra("packagePath", file.getAbsolutePath());
        }
        PendingIntent pendingIntent = PendingIntent.getService((Context)this, (int)0, (Intent)intent, (int)0x8000000);
        PendingIntent pendingIntent2 = PendingIntent.getService((Context)this, (int)0, (Intent)intent2, (int)0x10000000);
        this.mBuilder = new NotificationCompat.Builder((Context)this);
        this.mBuilder.setContentTitle((CharSequence)this.getResources().getString(R.string.updater_downloading_title)).setContentText((CharSequence)(this.mApplyImmediately ? "" : this.getResources().getString(R.string.updater_downloading_select))).setSmallIcon(0x1080081).setContentIntent(pendingIntent).setDeleteIntent(pendingIntent2);
        this.mBuilder.setProgress(100, 0, true);
        this.mNotificationManager.notify(1044438461, this.mBuilder.build());
    }

    private void showDownloadFailure() {
        Intent intent = new Intent("org.mozilla.fennec.CHECK_FOR_UPDATE");
        intent.setClass((Context)this, UpdateService.class);
        PendingIntent pendingIntent = PendingIntent.getService((Context)this, (int)0, (Intent)intent, (int)0x8000000);
        NotificationCompat.Builder builder = new NotificationCompat.Builder((Context)this);
        builder.setSmallIcon(R.drawable.ic_status_logo);
        builder.setWhen(System.currentTimeMillis());
        builder.setContentTitle((CharSequence)this.getString(R.string.updater_downloading_title_failed));
        builder.setContentText((CharSequence)this.getString(R.string.updater_downloading_retry));
        builder.setContentIntent(pendingIntent);
        this.mNotificationManager.notify(1044438461, builder.build());
    }

    private boolean deleteUpdatePackage(String string2) {
        if (string2 == null) {
            return false;
        }
        File file = new File(string2);
        if (!file.exists()) {
            return false;
        }
        file.delete();
        Log.i((String)"UpdateService", (String)("deleted update package: " + string2));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File downloadUpdatePackage(UpdateInfo updateInfo, boolean bl) {
        URLConnection uRLConnection;
        URL uRL = null;
        try {
            uRL = updateInfo.uri.toURL();
        }
        catch (MalformedURLException malformedURLException) {
            Log.e((String)"UpdateService", (String)"failed to read URL: ", (Throwable)malformedURLException);
            return null;
        }
        File file = Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DOWNLOADS);
        file.mkdirs();
        String string2 = new File(uRL.getFile()).getName();
        File file2 = new File(file, string2);
        if (!bl && updateInfo.buildID.equals(this.getLastBuildID()) && file2.exists()) {
            if (this.verifyDownloadedPackage(file2)) {
                Log.i((String)"UpdateService", (String)"using existing update package");
                return file2;
            }
            file2.delete();
        }
        if (!updateInfo.buildID.equals(this.getLastBuildID())) {
            this.deleteUpdatePackage(this.getLastFileName());
        }
        Log.i((String)"UpdateService", (String)"downloading update package");
        this.sendCheckUpdateResult(CheckUpdateResult.DOWNLOADING);
        OutputStream outputStream = null;
        InputStream inputStream = null;
        this.mDownloading = true;
        this.mCancelDownload = false;
        this.showDownloadNotification(file2);
        try {
            NetworkInfo networkInfo = this.mConnectivityManager.getActiveNetworkInfo();
            if (networkInfo != null && networkInfo.isConnected() && networkInfo.getType() == 1) {
                this.mWifiLock.acquire();
            }
            uRLConnection = ProxySelector.openConnectionWithProxy((URI)updateInfo.uri);
            int n = uRLConnection.getContentLength();
            outputStream = new BufferedOutputStream(new FileOutputStream(file2));
            inputStream = new BufferedInputStream(uRLConnection.getInputStream());
            byte[] byArray = new byte[8192];
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            while ((n2 = inputStream.read(byArray, 0, 8192)) > 0 && !this.mCancelDownload) {
                outputStream.write(byArray, 0, n2);
                if ((n3 += n2) - n4 <= 0x100000) continue;
                this.mBuilder.setProgress(n, n3, false);
                this.mNotificationManager.notify(1044438461, this.mBuilder.build());
                n4 = n3;
            }
            this.mNotificationManager.cancel(1044438461);
            if (this.mCancelDownload) {
                Log.i((String)"UpdateService", (String)"download canceled by user!");
                file2.delete();
                File file3 = null;
                return file3;
            }
            Log.i((String)"UpdateService", (String)"completed update download!");
            File file4 = file2;
            return file4;
        }
        catch (Exception exception) {
            file2.delete();
            this.showDownloadFailure();
            Log.e((String)"UpdateService", (String)"failed to download update: ", (Throwable)exception);
            uRLConnection = null;
            return uRLConnection;
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException iOException) {}
            this.mDownloading = false;
            if (this.mWifiLock.isHeld()) {
                this.mWifiLock.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean verifyDownloadedPackage(File file) {
        Object object;
        MessageDigest messageDigest = this.createMessageDigest(this.getLastHashFunction());
        if (messageDigest == null) {
            return false;
        }
        InputStream inputStream = null;
        try {
            int n;
            inputStream = new BufferedInputStream(new FileInputStream(file));
            object = new byte[8192];
            while ((n = inputStream.read((byte[])object, 0, 8192)) > 0) {
                messageDigest.update((byte[])object, 0, n);
            }
        }
        catch (IOException iOException) {
            Log.e((String)"UpdateService", (String)"Failed to verify update package: ", (Throwable)iOException);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
        object = Hex.encodeHexString((byte[])messageDigest.digest());
        if (!((String)object).equals(this.getLastHashValue())) {
            Log.e((String)"UpdateService", (String)"Package hash does not match");
            return false;
        }
        return true;
    }

    private void applyUpdate(String string2) {
        if (string2 == null) {
            string2 = this.getLastFileName();
        }
        this.applyUpdate(new File(string2));
    }

    private void applyUpdate(File file) {
        this.mApplyImmediately = false;
        if (!file.exists()) {
            return;
        }
        Log.i((String)"UpdateService", (String)("Verifying package: " + file));
        if (!this.verifyDownloadedPackage(file)) {
            Log.e((String)"UpdateService", (String)"Not installing update, failed verification");
            return;
        }
        Intent intent = new Intent("android.intent.action.VIEW");
        intent.setDataAndType(Uri.fromFile((File)file), "application/vnd.android.package-archive");
        intent.setFlags(0x10000000);
        this.startActivity(intent);
    }

    private void showPermissionNotification() {
        Intent intent = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS", Uri.fromParts((String)"package", (String)this.getPackageName(), null));
        PendingIntent pendingIntent = PendingIntent.getActivity((Context)this, (int)0, (Intent)intent, (int)0);
        NotificationCompat.BigTextStyle bigTextStyle = new NotificationCompat.BigTextStyle().bigText((CharSequence)this.getString(R.string.updater_permission_text));
        Notification notification = new NotificationCompat.Builder((Context)this).setContentTitle((CharSequence)this.getString(R.string.updater_permission_title)).setContentText((CharSequence)this.getString(R.string.updater_permission_text)).setStyle((NotificationCompat.Style)bigTextStyle).setAutoCancel(true).setSmallIcon(R.drawable.ic_status_logo).setColor(ContextCompat.getColor((Context)this, (int)R.color.rejection_red)).setContentIntent(pendingIntent).build();
        NotificationManagerCompat.from((Context)this).notify(R.id.updateServicePermissionNotification, notification);
    }

    private String getLastBuildID() {
        return this.mPrefs.getString(KEY_LAST_BUILDID, null);
    }

    private String getLastHashFunction() {
        return this.mPrefs.getString(KEY_LAST_HASH_FUNCTION, null);
    }

    private String getLastHashValue() {
        return this.mPrefs.getString(KEY_LAST_HASH_VALUE, null);
    }

    private String getLastFileName() {
        return this.mPrefs.getString(KEY_LAST_FILE_NAME, null);
    }

    private Calendar getLastAttemptDate() {
        long l = this.mPrefs.getLong(KEY_LAST_ATTEMPT_DATE, -1L);
        if (l < 0L) {
            return null;
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
        gregorianCalendar.setTimeInMillis(l);
        return gregorianCalendar;
    }

    private void setLastAttemptDate() {
        SharedPreferences.Editor editor = this.mPrefs.edit();
        editor.putLong(KEY_LAST_ATTEMPT_DATE, System.currentTimeMillis());
        editor.commit();
    }

    private AutoDownloadPolicy getAutoDownloadPolicy() {
        return AutoDownloadPolicy.get(this.mPrefs.getInt(KEY_AUTODOWNLOAD_POLICY, AutoDownloadPolicy.WIFI.value));
    }

    private void setAutoDownloadPolicy(AutoDownloadPolicy autoDownloadPolicy) {
        SharedPreferences.Editor editor = this.mPrefs.edit();
        editor.putInt(KEY_AUTODOWNLOAD_POLICY, autoDownloadPolicy.value);
        editor.commit();
    }

    private URI getUpdateURI(boolean bl) {
        return UpdateServiceHelper.expandUpdateURI((Context)this, this.mPrefs.getString(KEY_UPDATE_URL, null), bl);
    }

    private void setUpdateUrl(String string2) {
        SharedPreferences.Editor editor = this.mPrefs.edit();
        editor.putString(KEY_UPDATE_URL, string2);
        editor.commit();
    }

    private void saveUpdateInfo(UpdateInfo updateInfo, File file) {
        SharedPreferences.Editor editor = this.mPrefs.edit();
        editor.putString(KEY_LAST_BUILDID, updateInfo.buildID);
        editor.putString(KEY_LAST_HASH_FUNCTION, updateInfo.hashFunction);
        editor.putString(KEY_LAST_HASH_VALUE, updateInfo.hashValue);
        editor.putString(KEY_LAST_FILE_NAME, file.toString());
        editor.commit();
    }

    private class UpdateInfo {
        public URI uri;
        public String buildID;
        public String hashFunction;
        public String hashValue;
        public int size;

        private UpdateInfo() {
        }

        private boolean isNonEmpty(String string2) {
            return string2 != null && string2.length() > 0;
        }

        public boolean isValid() {
            return this.uri != null && this.isNonEmpty(this.buildID) && this.isNonEmpty(this.hashFunction) && this.isNonEmpty(this.hashValue) && this.size > 0;
        }

        public String toString() {
            return "uri = " + this.uri + ", buildID = " + this.buildID + ", hashFunction = " + this.hashFunction + ", hashValue = " + this.hashValue + ", size = " + this.size;
        }
    }

    private static enum CheckUpdateResult {
        NOT_AVAILABLE,
        AVAILABLE,
        DOWNLOADING,
        DOWNLOADED;

    }

    public static enum AutoDownloadPolicy {
        NONE(-1),
        WIFI(0),
        DISABLED(1),
        ENABLED(2);

        public final int value;
        private static final AutoDownloadPolicy[] sValues;

        private AutoDownloadPolicy(int n2) {
            this.value = n2;
        }

        public static AutoDownloadPolicy get(int n) {
            for (AutoDownloadPolicy autoDownloadPolicy : sValues) {
                if (autoDownloadPolicy.value != n) continue;
                return autoDownloadPolicy;
            }
            return NONE;
        }

        public static AutoDownloadPolicy get(String string2) {
            for (AutoDownloadPolicy autoDownloadPolicy : sValues) {
                if (!string2.equalsIgnoreCase(autoDownloadPolicy.toString())) continue;
                return autoDownloadPolicy;
            }
            return NONE;
        }

        static {
            sValues = AutoDownloadPolicy.values();
        }
    }
}

