/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.widget;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.support.v4.content.ContextCompat;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import org.mozilla.gecko.R;

public class DividerItemDecoration
extends RecyclerView.ItemDecoration {
    private final int mDividerHeight;
    private final Paint mDividerPaint;

    public DividerItemDecoration(Context context) {
        this.mDividerHeight = (int)context.getResources().getDimension(R.dimen.page_row_divider_height);
        this.mDividerPaint = new Paint();
        this.mDividerPaint.setColor(ContextCompat.getColor((Context)context, (int)R.color.toolbar_divider_grey));
        this.mDividerPaint.setStyle(Paint.Style.FILL_AND_STROKE);
    }

    public void getItemOffsets(Rect rect, View view, RecyclerView recyclerView, RecyclerView.State state) {
        rect.set(0, 0, 0, this.mDividerHeight);
    }

    public void onDraw(Canvas canvas, RecyclerView recyclerView, RecyclerView.State state) {
        if (recyclerView.getChildCount() == 0) {
            return;
        }
        for (int i = 0; i < recyclerView.getChildCount(); ++i) {
            View view = recyclerView.getChildAt(i);
            float f = (float)view.getBottom() + view.getTranslationY();
            canvas.drawRect(0.0f, f, (float)recyclerView.getWidth(), f + (float)this.mDividerHeight, this.mDividerPaint);
        }
    }
}

