/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.widget;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.v4.app.DialogFragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.support.v7.app.AlertDialog;
import android.util.Log;
import java.util.List;
import org.mozilla.gecko.ActivityHandlerHelper;
import org.mozilla.gecko.GeckoApplication;
import org.mozilla.gecko.R;
import org.mozilla.gecko.Tab;
import org.mozilla.gecko.Tabs;

public class ExternalIntentDuringPrivateBrowsingPromptFragment
extends DialogFragment {
    private static final String LOGTAG = ExternalIntentDuringPrivateBrowsingPromptFragment.class.getSimpleName();
    private static final String FRAGMENT_TAG = "ExternalIntentPB";
    private static final String KEY_APPLICATION_NAME = "matchingApplicationName";
    private static final String KEY_INTENT = "intent";

    public Dialog onCreateDialog(Bundle bundle) {
        Bundle bundle2 = this.getArguments();
        CharSequence charSequence = bundle2.getCharSequence(KEY_APPLICATION_NAME);
        Intent intent = (Intent)bundle2.getParcelable(KEY_INTENT);
        FragmentActivity fragmentActivity = this.getActivity();
        String string2 = fragmentActivity.getString(R.string.intent_uri_private_browsing_prompt, new Object[]{charSequence});
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this.getActivity());
        builder.setMessage((CharSequence)string2).setTitle((CharSequence)intent.getDataString()).setPositiveButton(R.string.button_yes, new DialogInterface.OnClickListener((Context)fragmentActivity, intent){
            final /* synthetic */ Context val$context;
            final /* synthetic */ Intent val$intent;
            {
                this.val$context = context;
                this.val$intent = intent;
            }

            public void onClick(DialogInterface dialogInterface, int n) {
                this.val$context.startActivity(this.val$intent);
            }
        }).setNegativeButton(R.string.button_no, null);
        return builder.create();
    }

    public void onDestroy() {
        super.onDestroy();
        GeckoApplication.watchReference((Context)this.getActivity(), (Object)this);
    }

    public static boolean showDialogOrAndroidChooser(Context context, FragmentManager fragmentManager, Intent intent) {
        Tab tab = Tabs.getInstance().getSelectedTab();
        if (tab == null || !tab.isPrivate()) {
            return ActivityHandlerHelper.startIntentAndCatch(LOGTAG, context, intent);
        }
        PackageManager packageManager = context.getPackageManager();
        List list = packageManager.queryIntentActivities(intent, 0);
        if (list.size() == 1) {
            ExternalIntentDuringPrivateBrowsingPromptFragment externalIntentDuringPrivateBrowsingPromptFragment = new ExternalIntentDuringPrivateBrowsingPromptFragment();
            Bundle bundle = new Bundle(2);
            bundle.putCharSequence(KEY_APPLICATION_NAME, ((ResolveInfo)list.get(0)).loadLabel(packageManager));
            bundle.putParcelable(KEY_INTENT, (Parcelable)intent);
            externalIntentDuringPrivateBrowsingPromptFragment.setArguments(bundle);
            externalIntentDuringPrivateBrowsingPromptFragment.show(fragmentManager, FRAGMENT_TAG);
            return true;
        }
        if (list.size() > 1) {
            String string2 = context.getResources().getString(R.string.intent_uri_private_browsing_multiple_match_title);
            Intent intent2 = Intent.createChooser((Intent)intent, (CharSequence)string2);
            return ActivityHandlerHelper.startIntentAndCatch(LOGTAG, context, intent2);
        }
        Log.w((String)LOGTAG, (String)"showDialogOrAndroidChooser unexpectedly called with Intent that does not resolve");
        return false;
    }
}

