/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.widget.themed;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.drawable.ColorDrawable;
import android.support.v4.content.ContextCompat;
import android.util.AttributeSet;
import android.widget.RelativeLayout;
import org.mozilla.gecko.GeckoApplication;
import org.mozilla.gecko.R;
import org.mozilla.gecko.lwt.LightweightTheme;

public class ThemedRelativeLayout
extends RelativeLayout
implements LightweightTheme.OnChangeListener {
    private LightweightTheme theme;
    private static final int[] STATE_PRIVATE_MODE = new int[]{R.attr.state_private};
    private static final int[] STATE_LIGHT = new int[]{R.attr.state_light};
    private static final int[] STATE_DARK = new int[]{R.attr.state_dark};
    protected static final int[] PRIVATE_PRESSED_STATE_SET = new int[]{R.attr.state_private, 16842919};
    protected static final int[] PRIVATE_FOCUSED_STATE_SET = new int[]{R.attr.state_private, 16842908};
    protected static final int[] PRIVATE_STATE_SET = new int[]{R.attr.state_private};
    private boolean isPrivate;
    private boolean isLight;
    private boolean isDark;
    private boolean autoUpdateTheme;
    private ColorStateList drawableColors;

    public ThemedRelativeLayout(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.initialize(context, attributeSet, 0);
    }

    public ThemedRelativeLayout(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.initialize(context, attributeSet, n);
    }

    private void initialize(Context context, AttributeSet attributeSet, int n) {
        Context context2 = context.getApplicationContext();
        if (context2 instanceof GeckoApplication) {
            this.theme = ((GeckoApplication)context2).getLightweightTheme();
        }
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.LightweightTheme);
        this.autoUpdateTheme = this.theme != null && typedArray.getBoolean(R.styleable.LightweightTheme_autoUpdateTheme, true);
        typedArray.recycle();
    }

    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.autoUpdateTheme) {
            this.theme.addListener(this);
        }
    }

    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.autoUpdateTheme) {
            this.theme.removeListener(this);
        }
    }

    public int[] onCreateDrawableState(int n) {
        int[] nArray = super.onCreateDrawableState(n + 1);
        if (this.isPrivate) {
            ThemedRelativeLayout.mergeDrawableStates((int[])nArray, (int[])STATE_PRIVATE_MODE);
        } else if (this.isLight) {
            ThemedRelativeLayout.mergeDrawableStates((int[])nArray, (int[])STATE_LIGHT);
        } else if (this.isDark) {
            ThemedRelativeLayout.mergeDrawableStates((int[])nArray, (int[])STATE_DARK);
        }
        return nArray;
    }

    @Override
    public void onLightweightThemeChanged() {
        if (this.autoUpdateTheme && this.theme.isEnabled()) {
            this.setTheme(this.theme.isLightTheme());
        }
    }

    @Override
    public void onLightweightThemeReset() {
        if (this.autoUpdateTheme) {
            this.resetTheme();
        }
    }

    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        super.onLayout(bl, n, n2, n3, n4);
        this.onLightweightThemeChanged();
    }

    public boolean isPrivateMode() {
        return this.isPrivate;
    }

    public void setPrivateMode(boolean bl) {
        if (this.isPrivate != bl) {
            this.isPrivate = bl;
            this.refreshDrawableState();
            this.invalidate();
        }
    }

    public void setTheme(boolean bl) {
        if (bl && this.isLight != bl || !bl && this.isDark == bl) {
            if (bl) {
                this.isLight = true;
                this.isDark = false;
            } else {
                this.isLight = false;
                this.isDark = true;
            }
            this.refreshDrawableState();
            this.invalidate();
        }
    }

    public void resetTheme() {
        if (this.isLight || this.isDark) {
            this.isLight = false;
            this.isDark = false;
            this.refreshDrawableState();
            this.invalidate();
        }
    }

    public void setAutoUpdateTheme(boolean bl) {
        if (this.theme == null) {
            return;
        }
        if (this.autoUpdateTheme != bl) {
            this.autoUpdateTheme = bl;
            if (bl) {
                this.theme.addListener(this);
            } else {
                this.theme.removeListener(this);
            }
        }
    }

    public ColorDrawable getColorDrawable(int n) {
        return new ColorDrawable(ContextCompat.getColor((Context)this.getContext(), (int)n));
    }

    protected LightweightTheme getTheme() {
        return this.theme;
    }
}

