/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.util;

import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.util.Log;
import java.util.concurrent.SynchronousQueue;
import org.mozilla.gecko.AppConstants;
import org.mozilla.gecko.annotation.WrapForJNI;
import org.mozilla.gecko.util.ThreadUtils;

public final class Clipboard {
    static volatile Context mContext;
    private static final String LOGTAG = "GeckoClipboard";
    private static final SynchronousQueue<String> sClipboardQueue;

    private Clipboard() {
    }

    public static void init(Context context) {
        if (mContext != null) {
            Log.w((String)LOGTAG, (String)"Clipboard.init() called twice!");
            return;
        }
        mContext = context.getApplicationContext();
    }

    @WrapForJNI(stubName="GetClipboardTextWrapper")
    public static String getText() {
        if (ThreadUtils.isOnUiThread() || ThreadUtils.isOnBackgroundThread()) {
            return Clipboard.getClipboardTextImpl();
        }
        ThreadUtils.postToBackgroundThread(new Runnable(){

            @Override
            public void run() {
                String string = Clipboard.getClipboardTextImpl();
                try {
                    sClipboardQueue.put(string != null ? string : "");
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        });
        try {
            return sClipboardQueue.take();
        }
        catch (InterruptedException interruptedException) {
            return "";
        }
    }

    @WrapForJNI(stubName="SetClipboardText")
    public static void setText(final CharSequence charSequence) {
        ThreadUtils.postToBackgroundThread(new Runnable(){

            @Override
            public void run() {
                if (AppConstants.Versions.feature11Plus) {
                    ClipboardManager clipboardManager = (ClipboardManager)mContext.getSystemService("clipboard");
                    ClipData clipData = ClipData.newPlainText((CharSequence)"Text", (CharSequence)charSequence);
                    try {
                        clipboardManager.setPrimaryClip(clipData);
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                    return;
                }
                android.text.ClipboardManager clipboardManager = (android.text.ClipboardManager)mContext.getSystemService("clipboard");
                clipboardManager.setText(charSequence);
            }
        });
    }

    @WrapForJNI
    public static boolean hasText() {
        if (AppConstants.Versions.feature11Plus) {
            ClipboardManager clipboardManager = (ClipboardManager)mContext.getSystemService("clipboard");
            return clipboardManager.hasPrimaryClip();
        }
        android.text.ClipboardManager clipboardManager = (android.text.ClipboardManager)mContext.getSystemService("clipboard");
        return clipboardManager.hasText();
    }

    @WrapForJNI
    public static void clearText() {
        Clipboard.setText(null);
    }

    static String getClipboardTextImpl() {
        if (AppConstants.Versions.feature11Plus) {
            ClipData clipData;
            ClipboardManager clipboardManager = (ClipboardManager)mContext.getSystemService("clipboard");
            if (clipboardManager.hasPrimaryClip() && (clipData = clipboardManager.getPrimaryClip()) != null) {
                ClipData.Item item = clipData.getItemAt(0);
                return item.coerceToText(mContext).toString();
            }
        } else {
            android.text.ClipboardManager clipboardManager = (android.text.ClipboardManager)mContext.getSystemService("clipboard");
            if (clipboardManager.hasText()) {
                return clipboardManager.getText().toString();
            }
        }
        return null;
    }

    static {
        sClipboardQueue = new SynchronousQueue();
    }
}

