/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.util;

import android.support.annotation.NonNull;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;

public class DateUtil {
    private DateUtil() {
    }

    public static String getDateInHTTPFormat(@NonNull Date date) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("E, dd MMM yyyy HH:mm:ss z", Locale.US);
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        return simpleDateFormat.format(date);
    }

    public static int getTimezoneOffsetInMinutes(@NonNull TimeZone timeZone) {
        return DateUtil.getTimezoneOffsetInMinutesForGivenDate(Calendar.getInstance(timeZone));
    }

    public static int getTimezoneOffsetInMinutesForGivenDate(@NonNull Calendar calendar) {
        return (int)TimeUnit.MILLISECONDS.toMinutes(calendar.get(15) + calendar.get(16));
    }
}

