/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.util;

import android.content.Intent;
import android.support.annotation.NonNull;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class IntentUtils {
    private static final String ENV_VAR_REGEX = "(.+)=(.*)";

    private IntentUtils() {
    }

    public static HashMap<String, String> getEnvVarMap(@NonNull Intent intent) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Pattern pattern = Pattern.compile(ENV_VAR_REGEX);
        Matcher matcher = null;
        String string = intent.getStringExtra("env0");
        int n = 1;
        while (string != null) {
            if (matcher == null) {
                matcher = pattern.matcher(string);
            } else {
                matcher.reset(string);
            }
            if (matcher.matches()) {
                String string2 = matcher.group(1);
                String string3 = matcher.group(2);
                hashMap.put(string2, string3);
            }
            string = intent.getStringExtra("env" + n);
            ++n;
        }
        return hashMap;
    }
}

