/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.util;

import android.content.Intent;
import android.net.Uri;
import android.os.Environment;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public final class WebActivityMapper {
    private static final String LOGTAG = "Gecko";
    private static final Map<String, WebActivityMapping> activityMap = new HashMap<String, WebActivityMapping>();

    public static Intent getIntentForWebActivity(JSONObject jSONObject) throws JSONException {
        String string;
        String string2 = jSONObject.getString("name").toLowerCase();
        JSONObject jSONObject2 = jSONObject.getJSONObject("data");
        Log.w((String)LOGTAG, (String)("Activity is: " + string2));
        WebActivityMapping webActivityMapping = activityMap.get(string2);
        if (webActivityMapping == null) {
            Log.w((String)LOGTAG, (String)"No mapping found!");
            return null;
        }
        webActivityMapping.setData(jSONObject2);
        Intent intent = new Intent(webActivityMapping.getAction());
        String string3 = webActivityMapping.getMime();
        if (!TextUtils.isEmpty((CharSequence)string3)) {
            intent.setType(string3);
        }
        if (!TextUtils.isEmpty((CharSequence)(string = webActivityMapping.getUri()))) {
            intent.setData(Uri.parse((String)string));
        }
        webActivityMapping.putExtras(intent);
        return intent;
    }

    static {
        activityMap.put("dial", new DialMapping());
        activityMap.put("open", new OpenMapping());
        activityMap.put("pick", new PickMapping());
        activityMap.put("send", new SendMapping());
        activityMap.put("view", new ViewMapping());
        activityMap.put("record", new RecordMapping());
    }

    private static class RecordMapping
    extends WebActivityMapping {
        private RecordMapping() {
        }

        @Override
        public String getAction() {
            String string = this.mData.optString("type", null);
            if ("photos".equals(string)) {
                return "android.media.action.IMAGE_CAPTURE";
            }
            if ("videos".equals(string)) {
                return "android.media.action.VIDEO_CAPTURE";
            }
            return null;
        }

        @Override
        public void putExtras(Intent intent) {
            String string = this.getAction();
            String string2 = string == "android.media.action.IMAGE_CAPTURE" ? Environment.DIRECTORY_PICTURES : Environment.DIRECTORY_MOVIES;
            String string3 = string == "android.media.action.IMAGE_CAPTURE" ? ".jpg" : ".mp4";
            File file = Environment.getExternalStoragePublicDirectory((String)string2);
            try {
                File file2 = File.createTempFile("capture", string3, file);
                intent.putExtra("output", (Parcelable)Uri.fromFile((File)file2));
            }
            catch (Exception exception) {
                Log.w((String)WebActivityMapper.LOGTAG, (String)("Failed to add extra for " + string + " : " + exception));
            }
        }
    }

    private static class ViewMapping
    extends BaseMapping {
        private ViewMapping() {
        }

        @Override
        public String getAction() {
            return "android.intent.action.VIEW";
        }

        @Override
        public String getMime() {
            String string = this.mData.optString("type", null);
            if ("url".equals(string) || "uri".equals(string)) {
                return null;
            }
            return string;
        }
    }

    private static class SendMapping
    extends BaseMapping {
        private SendMapping() {
        }

        @Override
        public String getAction() {
            return "android.intent.action.SEND";
        }

        @Override
        public void putExtras(Intent intent) throws JSONException {
            this.optPutExtra("text", "android.intent.extra.TEXT", intent);
            this.optPutExtra("html_text", "android.intent.extra.HTML_TEXT", intent);
            this.optPutExtra("stream", "android.intent.extra.STREAM", intent);
        }

        private void optPutExtra(String string, String string2, Intent intent) {
            String string3 = this.mData.optString(string);
            if (!TextUtils.isEmpty((CharSequence)string3)) {
                intent.putExtra(string2, string3);
            }
        }
    }

    private static class PickMapping
    extends BaseMapping {
        private PickMapping() {
        }

        @Override
        public String getAction() {
            return "android.intent.action.GET_CONTENT";
        }

        @Override
        public String getMime() throws JSONException {
            String string = this.mData.optString("type", null);
            return !TextUtils.isEmpty((CharSequence)string) ? string : "*/*";
        }
    }

    private static class OpenMapping
    extends BaseMapping {
        private OpenMapping() {
        }

        @Override
        public String getAction() {
            return "android.intent.action.VIEW";
        }
    }

    private static class DialMapping
    extends WebActivityMapping {
        private DialMapping() {
        }

        @Override
        public String getAction() {
            return "android.intent.action.DIAL";
        }

        @Override
        public String getUri() throws JSONException {
            return "tel:" + this.mData.getString("number");
        }
    }

    private static abstract class BaseMapping
    extends WebActivityMapping {
        private BaseMapping() {
        }

        @Override
        public String getMime() throws JSONException {
            return this.mData.optString("type", null);
        }

        @Override
        public String getUri() throws JSONException {
            String string = this.mData.optString("uri", null);
            return string != null ? string : this.mData.optString("url", null);
        }
    }

    private static abstract class WebActivityMapping {
        protected JSONObject mData;

        private WebActivityMapping() {
        }

        public void setData(JSONObject jSONObject) {
            this.mData = jSONObject;
        }

        public abstract String getAction();

        public String getMime() throws JSONException {
            return null;
        }

        public String getUri() throws JSONException {
            return null;
        }

        public void putExtras(Intent intent) throws JSONException {
        }
    }
}

