/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.search;

import android.content.Context;
import android.database.Cursor;
import android.graphics.Rect;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.LoaderManager;
import android.support.v4.content.CursorLoader;
import android.support.v4.content.Loader;
import android.support.v4.widget.SimpleCursorAdapter;
import android.text.TextUtils;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewStub;
import android.widget.AdapterView;
import android.widget.ImageView;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import org.mozilla.gecko.GeckoApplication;
import org.mozilla.gecko.R;
import org.mozilla.gecko.Telemetry;
import org.mozilla.gecko.TelemetryContract;
import org.mozilla.gecko.db.BrowserContract;
import org.mozilla.gecko.widget.SwipeDismissListViewTouchListener;
import org.mozilla.search.AcceptsSearchQuery;

public class PreSearchFragment
extends Fragment {
    private static final String LOG_TAG = "PreSearchFragment";
    private AcceptsSearchQuery searchListener;
    private SimpleCursorAdapter cursorAdapter;
    private ListView listView;
    private View emptyView;
    private static final String[] PROJECTION = new String[]{"query", "_id"};
    private static final int SEARCH_HISTORY_LIMIT = 10;
    private static final Uri SEARCH_HISTORY_URI = BrowserContract.SearchHistory.CONTENT_URI.buildUpon().appendQueryParameter("limit", String.valueOf(10)).build();
    private static final int LOADER_ID_SEARCH_HISTORY = 1;

    public void onAttach(Context context) {
        super.onAttach(context);
        if (!(context instanceof AcceptsSearchQuery)) {
            throw new ClassCastException(context.toString() + " must implement AcceptsSearchQuery.");
        }
        this.searchListener = (AcceptsSearchQuery)context;
    }

    public void onDetach() {
        super.onDetach();
        this.searchListener = null;
    }

    public void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        this.getLoaderManager().initLoader(1, null, (LoaderManager.LoaderCallbacks)new SearchHistoryLoaderCallbacks());
        this.cursorAdapter = new SimpleCursorAdapter((Context)this.getActivity(), R.layout.search_history_row, null, PROJECTION, new int[]{R.id.site_name}, 0);
    }

    public void onDestroy() {
        super.onDestroy();
        this.getLoaderManager().destroyLoader(1);
        this.cursorAdapter.swapCursor(null);
        this.cursorAdapter = null;
        GeckoApplication.watchReference((Context)this.getActivity(), (Object)((Object)this));
    }

    public View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
        View view = layoutInflater.inflate(R.layout.search_fragment_pre_search, viewGroup, false);
        this.listView = (ListView)view.findViewById(R.id.list_view);
        this.listView.setAdapter((ListAdapter)this.cursorAdapter);
        this.listView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> adapterView, View view, int n, long l) {
                String string2 = PreSearchFragment.this.getQueryAtPosition(n);
                if (!TextUtils.isEmpty((CharSequence)string2)) {
                    final Rect rect = new Rect();
                    view.getGlobalVisibleRect(rect);
                    Telemetry.sendUIEvent((TelemetryContract.Event)TelemetryContract.Event.SEARCH, (TelemetryContract.Method)TelemetryContract.Method.SUGGESTION, (String)"history");
                    PreSearchFragment.this.searchListener.onSearch(string2, new AcceptsSearchQuery.SuggestionAnimation(){

                        @Override
                        public Rect getStartBounds() {
                            return rect;
                        }
                    });
                }
            }
        });
        SwipeDismissListViewTouchListener swipeDismissListViewTouchListener = new SwipeDismissListViewTouchListener(this.listView, new SwipeDismissListViewTouchListener.OnDismissCallback(){

            public void onDismiss(ListView listView, final int n) {
                new AsyncTask<Void, Void, Void>(){

                    protected Void doInBackground(Void ... voidArray) {
                        String string2 = PreSearchFragment.this.getQueryAtPosition(n);
                        int n2 = PreSearchFragment.this.getActivity().getContentResolver().delete(BrowserContract.SearchHistory.CONTENT_URI, "query = ?", new String[]{string2});
                        if (n2 < 1) {
                            Log.w((String)PreSearchFragment.LOG_TAG, (String)("Search query not deleted: " + string2));
                        }
                        return null;
                    }
                }.execute((Object[])new Void[0]);
            }
        });
        this.listView.setOnTouchListener((View.OnTouchListener)swipeDismissListViewTouchListener);
        this.listView.setOnScrollListener(swipeDismissListViewTouchListener.makeScrollListener());
        this.listView.setRecyclerListener(swipeDismissListViewTouchListener.makeRecyclerListener());
        return view;
    }

    private String getQueryAtPosition(int n) {
        Cursor cursor = this.cursorAdapter.getCursor();
        if (cursor == null || !cursor.moveToPosition(n)) {
            return null;
        }
        return cursor.getString(cursor.getColumnIndexOrThrow("query"));
    }

    public void onDestroyView() {
        super.onDestroyView();
        this.listView.setAdapter(null);
        this.listView = null;
        this.emptyView = null;
    }

    private void updateUiFromCursor(Cursor cursor) {
        if (cursor != null && cursor.getCount() > 0) {
            return;
        }
        if (this.emptyView == null) {
            ViewStub viewStub = (ViewStub)this.getView().findViewById(R.id.empty_view_stub);
            this.emptyView = viewStub.inflate();
            ((ImageView)this.emptyView.findViewById(R.id.empty_image)).setImageResource(R.drawable.icon_search_empty_firefox);
            ((TextView)this.emptyView.findViewById(R.id.empty_title)).setText(R.string.search_empty_title);
            ((TextView)this.emptyView.findViewById(R.id.empty_message)).setText(R.string.search_empty_message);
            this.listView.setEmptyView(this.emptyView);
        }
    }

    private class SearchHistoryLoaderCallbacks
    implements LoaderManager.LoaderCallbacks<Cursor> {
        private SearchHistoryLoaderCallbacks() {
        }

        public Loader<Cursor> onCreateLoader(int n, Bundle bundle) {
            return new CursorLoader((Context)PreSearchFragment.this.getActivity(), SEARCH_HISTORY_URI, PROJECTION, null, null, "date DESC");
        }

        public void onLoadFinished(Loader<Cursor> loader, Cursor cursor) {
            if (PreSearchFragment.this.cursorAdapter != null) {
                PreSearchFragment.this.cursorAdapter.swapCursor(cursor);
            }
            PreSearchFragment.this.updateUiFromCursor(cursor);
        }

        public void onLoaderReset(Loader<Cursor> loader) {
            if (PreSearchFragment.this.cursorAdapter != null) {
                PreSearchFragment.this.cursorAdapter.swapCursor(null);
            }
        }
    }
}

