/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.util.Log;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.GeckoProfile;
import org.mozilla.gecko.GeckoThread;
import org.mozilla.gecko.db.BrowserContract;
import org.mozilla.gecko.db.BrowserDB;
import org.mozilla.gecko.favicons.Favicons;
import org.mozilla.gecko.home.ImageLoader;
import org.mozilla.gecko.util.ThreadUtils;

class MemoryMonitor
extends BroadcastReceiver {
    private static final String LOGTAG = "GeckoMemoryMonitor";
    private static final String ACTION_MEMORY_DUMP = "org.mozilla.gecko.MEMORY_DUMP";
    private static final String ACTION_FORCE_PRESSURE = "org.mozilla.gecko.FORCE_MEMORY_PRESSURE";
    private static final int MEMORY_PRESSURE_NONE = 0;
    private static final int MEMORY_PRESSURE_CLEANUP = 1;
    private static final int MEMORY_PRESSURE_LOW = 2;
    private static final int MEMORY_PRESSURE_MEDIUM = 3;
    private static final int MEMORY_PRESSURE_HIGH = 4;
    private static final MemoryMonitor sInstance = new MemoryMonitor();
    private final PressureDecrementer mPressureDecrementer = new PressureDecrementer();
    private int mMemoryPressure = 0;
    private volatile boolean mStoragePressure;
    private boolean mInited;

    static MemoryMonitor getInstance() {
        return sInstance;
    }

    private MemoryMonitor() {
    }

    public void init(Context context) {
        if (this.mInited) {
            return;
        }
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.intent.action.DEVICE_STORAGE_LOW");
        intentFilter.addAction("android.intent.action.DEVICE_STORAGE_OK");
        intentFilter.addAction(ACTION_MEMORY_DUMP);
        intentFilter.addAction(ACTION_FORCE_PRESSURE);
        context.getApplicationContext().registerReceiver((BroadcastReceiver)this, intentFilter);
        this.mInited = true;
    }

    public void onLowMemory() {
        Log.d((String)LOGTAG, (String)"onLowMemory() notification received");
        if (this.increaseMemoryPressure(4) && GeckoThread.isStateAtLeast(GeckoThread.State.PROFILE_READY)) {
            GeckoThread.waitOnGecko();
        }
    }

    public void onTrimMemory(int n) {
        Log.d((String)LOGTAG, (String)("onTrimMemory() notification received with level " + n));
        if (n == 80) {
            return;
        }
        switch (n) {
            case 15: 
            case 60: {
                this.increaseMemoryPressure(4);
                break;
            }
            case 5: {
                this.increaseMemoryPressure(3);
                break;
            }
            case 10: {
                this.increaseMemoryPressure(2);
                break;
            }
            case 20: 
            case 40: {
                this.increaseMemoryPressure(1);
                break;
            }
            default: {
                Log.d((String)LOGTAG, (String)("Unhandled onTrimMemory() level " + n));
            }
        }
    }

    public void onReceive(Context context, Intent intent) {
        if ("android.intent.action.DEVICE_STORAGE_LOW".equals(intent.getAction())) {
            Log.d((String)LOGTAG, (String)"Device storage is low");
            this.mStoragePressure = true;
            ThreadUtils.postToBackgroundThread((Runnable)new StorageReducer(context));
        } else if ("android.intent.action.DEVICE_STORAGE_OK".equals(intent.getAction())) {
            Log.d((String)LOGTAG, (String)"Device storage is ok");
            this.mStoragePressure = false;
        } else if (ACTION_MEMORY_DUMP.equals(intent.getAction())) {
            String string2 = intent.getStringExtra("label");
            if (string2 == null) {
                string2 = "default";
            }
            GeckoAppShell.notifyObservers("Memory:Dump", string2);
        } else if (ACTION_FORCE_PRESSURE.equals(intent.getAction())) {
            this.increaseMemoryPressure(4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean increaseMemoryPressure(int n) {
        int n2;
        MemoryMonitor memoryMonitor = this;
        synchronized (memoryMonitor) {
            if (this.mMemoryPressure > n) {
                return false;
            }
            n2 = this.mMemoryPressure;
            this.mMemoryPressure = n;
        }
        Log.d((String)LOGTAG, (String)("increasing memory pressure to " + n));
        this.mPressureDecrementer.start();
        if (n2 == n) {
            return false;
        }
        if (n >= 3) {
            if (GeckoThread.isRunning()) {
                GeckoAppShell.dispatchMemoryPressure();
            }
            Favicons.clearMemCache();
            ImageLoader.clearLruCache();
        }
        return true;
    }

    boolean isUnderStoragePressure() {
        return this.mStoragePressure;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean decreaseMemoryPressure() {
        int n;
        MemoryMonitor memoryMonitor = this;
        synchronized (memoryMonitor) {
            if (this.mMemoryPressure <= 0) {
                return false;
            }
            n = --this.mMemoryPressure;
        }
        Log.d((String)LOGTAG, (String)("Decreased memory pressure to " + n));
        return true;
    }

    private static class StorageReducer
    implements Runnable {
        private final Context mContext;
        private final BrowserDB mDB;

        public StorageReducer(Context context) {
            this.mContext = context;
            GeckoProfile geckoProfile = GeckoProfile.get(this.mContext);
            if (geckoProfile.inGuestMode()) {
                geckoProfile = GeckoProfile.get(this.mContext, "default");
            }
            this.mDB = geckoProfile.getDB();
        }

        @Override
        public void run() {
            if (!GeckoThread.isRunning()) {
                ThreadUtils.getBackgroundHandler().postDelayed((Runnable)this, 10000L);
                return;
            }
            if (!MemoryMonitor.getInstance().isUnderStoragePressure()) {
                return;
            }
            ContentResolver contentResolver = this.mContext.getContentResolver();
            this.mDB.expireHistory(contentResolver, BrowserContract.ExpirePriority.AGGRESSIVE);
            this.mDB.removeThumbnails(contentResolver);
        }
    }

    class PressureDecrementer
    implements Runnable {
        private static final int DECREMENT_DELAY = 300000;
        private boolean mPosted;

        PressureDecrementer() {
        }

        synchronized void start() {
            if (this.mPosted) {
                ThreadUtils.getBackgroundHandler().removeCallbacks((Runnable)this);
            }
            ThreadUtils.getBackgroundHandler().postDelayed((Runnable)this, 300000L);
            this.mPosted = true;
        }

        @Override
        public synchronized void run() {
            if (!MemoryMonitor.this.decreaseMemoryPressure()) {
                this.mPosted = false;
                return;
            }
            ThreadUtils.getBackgroundHandler().postDelayed((Runnable)this, 300000L);
        }
    }
}

