/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.content.Context;
import android.os.Bundle;
import android.os.CancellationSignal;
import android.os.ParcelFileDescriptor;
import android.print.PageRange;
import android.print.PrintAttributes;
import android.print.PrintDocumentAdapter;
import android.print.PrintDocumentInfo;
import android.print.PrintManager;
import android.util.Log;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.json.JSONObject;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.util.GeckoRequest;
import org.mozilla.gecko.util.IOUtils;
import org.mozilla.gecko.util.NativeJSObject;
import org.mozilla.gecko.util.ThreadUtils;

public class PrintHelper {
    private static final String LOGTAG = "GeckoPrintUtils";

    public static void printPDF(final Context context) {
        GeckoAppShell.sendRequestToGecko(new GeckoRequest("Print:PDF", new JSONObject()){

            public void onResponse(NativeJSObject nativeJSObject) {
                String string2 = nativeJSObject.getString("file");
                String string3 = nativeJSObject.getString("title");
                this.finish(context, string2, string3);
            }

            public void onError(NativeJSObject nativeJSObject) {
                Log.d((String)PrintHelper.LOGTAG, (String)"No response from Gecko on request to generate a PDF");
            }

            private void finish(Context context2, final String string2, String string3) {
                PrintManager printManager = (PrintManager)context2.getSystemService("print");
                String string4 = string3;
                PrintDocumentAdapter printDocumentAdapter = new PrintDocumentAdapter(){

                    public void onWrite(PageRange[] pageRangeArray, final ParcelFileDescriptor parcelFileDescriptor, CancellationSignal cancellationSignal, final PrintDocumentAdapter.WriteResultCallback writeResultCallback) {
                        ThreadUtils.postToBackgroundThread((Runnable)new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             * Loose catch block
                             */
                            @Override
                            public void run() {
                                block8: {
                                    FileInputStream fileInputStream = null;
                                    FileOutputStream fileOutputStream = null;
                                    try {
                                        int n;
                                        File file = new File(string2);
                                        fileInputStream = new FileInputStream(file);
                                        fileOutputStream = new FileOutputStream(parcelFileDescriptor.getFileDescriptor());
                                        byte[] byArray = new byte[8192];
                                        while ((n = ((InputStream)fileInputStream).read(byArray)) > 0) {
                                            ((OutputStream)fileOutputStream).write(byArray, 0, n);
                                        }
                                        writeResultCallback.onWriteFinished(new PageRange[]{PageRange.ALL_PAGES});
                                        IOUtils.safeStreamClose((Closeable)fileInputStream);
                                    }
                                    catch (FileNotFoundException fileNotFoundException) {
                                        Log.d((String)PrintHelper.LOGTAG, (String)"Unable to find the temporary PDF file.");
                                        break block8;
                                    }
                                    catch (IOException iOException) {
                                        Log.e((String)PrintHelper.LOGTAG, (String)"IOException while transferring temporary PDF file: ", (Throwable)iOException);
                                        break block8;
                                        {
                                            catch (Throwable throwable) {
                                                throw throwable;
                                            }
                                        }
                                    }
                                    finally {
                                        IOUtils.safeStreamClose(fileInputStream);
                                        IOUtils.safeStreamClose(fileOutputStream);
                                    }
                                    IOUtils.safeStreamClose((Closeable)fileOutputStream);
                                }
                            }
                        });
                    }

                    public void onLayout(PrintAttributes printAttributes, PrintAttributes printAttributes2, CancellationSignal cancellationSignal, PrintDocumentAdapter.LayoutResultCallback layoutResultCallback, Bundle bundle) {
                        if (cancellationSignal.isCanceled()) {
                            layoutResultCallback.onLayoutCancelled();
                            return;
                        }
                        PrintDocumentInfo printDocumentInfo = new PrintDocumentInfo.Builder(string2).setContentType(0).build();
                        layoutResultCallback.onLayoutFinished(printDocumentInfo, true);
                    }

                    public void onFinish() {
                        try {
                            File file = new File(string2);
                            file.delete();
                        }
                        catch (NullPointerException nullPointerException) {
                            // empty catch block
                        }
                    }
                };
                printManager.print(string4, printDocumentAdapter, null);
            }
        });
    }
}

