/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.text.TextUtils;
import org.json.JSONObject;

public class SiteIdentity {
    private final String LOGTAG = "GeckoSiteIdentity";
    private SecurityMode mSecurityMode;
    private boolean mSecure;
    private boolean mLoginInsecure;
    private MixedMode mMixedModeActive;
    private MixedMode mMixedModeDisplay;
    private TrackingMode mTrackingMode;
    private String mHost;
    private String mOwner;
    private String mSupplemental;
    private String mCountry;
    private String mVerifier;
    private String mOrigin;

    public SiteIdentity() {
        this.reset();
    }

    public void resetIdentity() {
        this.mSecurityMode = SecurityMode.UNKNOWN;
        this.mOrigin = null;
        this.mHost = null;
        this.mOwner = null;
        this.mSupplemental = null;
        this.mCountry = null;
        this.mVerifier = null;
        this.mSecure = false;
        this.mLoginInsecure = false;
    }

    public void reset() {
        this.resetIdentity();
        this.mMixedModeActive = MixedMode.UNKNOWN;
        this.mMixedModeDisplay = MixedMode.UNKNOWN;
        this.mTrackingMode = TrackingMode.UNKNOWN;
    }

    void update(JSONObject jSONObject) {
        if (jSONObject == null) {
            this.reset();
            return;
        }
        try {
            JSONObject jSONObject2 = jSONObject.getJSONObject("mode");
            try {
                this.mMixedModeDisplay = MixedMode.fromString(jSONObject2.getString("mixed_display"));
            }
            catch (Exception exception) {
                this.mMixedModeDisplay = MixedMode.UNKNOWN;
            }
            try {
                this.mMixedModeActive = MixedMode.fromString(jSONObject2.getString("mixed_active"));
            }
            catch (Exception exception) {
                this.mMixedModeActive = MixedMode.UNKNOWN;
            }
            try {
                this.mTrackingMode = TrackingMode.fromString(jSONObject2.getString("tracking"));
            }
            catch (Exception exception) {
                this.mTrackingMode = TrackingMode.UNKNOWN;
            }
            try {
                this.mSecurityMode = SecurityMode.fromString(jSONObject2.getString("identity"));
            }
            catch (Exception exception) {
                this.resetIdentity();
                return;
            }
            try {
                this.mOrigin = jSONObject.getString("origin");
                this.mHost = jSONObject.optString("host", null);
                this.mOwner = jSONObject.optString("owner", null);
                this.mSupplemental = jSONObject.optString("supplemental", null);
                this.mCountry = jSONObject.optString("country", null);
                this.mVerifier = jSONObject.optString("verifier", null);
                this.mSecure = jSONObject.optBoolean("secure", false);
            }
            catch (Exception exception) {
                this.resetIdentity();
            }
        }
        catch (Exception exception) {
            this.reset();
        }
    }

    public SecurityMode getSecurityMode() {
        return this.mSecurityMode;
    }

    public String getOrigin() {
        return this.mOrigin;
    }

    public String getHost() {
        return this.mHost;
    }

    public String getOwner() {
        return this.mOwner;
    }

    public boolean hasOwner() {
        return !TextUtils.isEmpty((CharSequence)this.mOwner);
    }

    public String getSupplemental() {
        return this.mSupplemental;
    }

    public String getCountry() {
        return this.mCountry;
    }

    public boolean hasCountry() {
        return !TextUtils.isEmpty((CharSequence)this.mCountry);
    }

    public String getVerifier() {
        return this.mVerifier;
    }

    public boolean isSecure() {
        return this.mSecure;
    }

    public void setLoginInsecure(boolean bl) {
        this.mLoginInsecure = bl;
    }

    public boolean loginInsecure() {
        return this.mLoginInsecure;
    }

    public MixedMode getMixedModeActive() {
        return this.mMixedModeActive;
    }

    public MixedMode getMixedModeDisplay() {
        return this.mMixedModeDisplay;
    }

    public TrackingMode getTrackingMode() {
        return this.mTrackingMode;
    }

    public static enum TrackingMode {
        UNKNOWN("unknown"),
        TRACKING_CONTENT_BLOCKED("tracking_content_blocked"),
        TRACKING_CONTENT_LOADED("tracking_content_loaded");

        private final String mId;

        private TrackingMode(String string3) {
            this.mId = string3;
        }

        public static TrackingMode fromString(String string2) {
            if (string2 == null) {
                throw new IllegalArgumentException("Can't convert null String to TrackingMode");
            }
            for (TrackingMode trackingMode : TrackingMode.values()) {
                if (!TextUtils.equals((CharSequence)trackingMode.mId, (CharSequence)string2.toLowerCase())) continue;
                return trackingMode;
            }
            throw new IllegalArgumentException("Could not convert String id to TrackingMode");
        }

        public String toString() {
            return this.mId;
        }
    }

    public static enum MixedMode {
        UNKNOWN("unknown"),
        MIXED_CONTENT_BLOCKED("blocked"),
        MIXED_CONTENT_LOADED("loaded");

        private final String mId;

        private MixedMode(String string3) {
            this.mId = string3;
        }

        public static MixedMode fromString(String string2) {
            if (string2 == null) {
                throw new IllegalArgumentException("Can't convert null String to MixedMode");
            }
            for (MixedMode mixedMode : MixedMode.values()) {
                if (!TextUtils.equals((CharSequence)mixedMode.mId, (CharSequence)string2.toLowerCase())) continue;
                return mixedMode;
            }
            throw new IllegalArgumentException("Could not convert String id to MixedMode");
        }

        public String toString() {
            return this.mId;
        }
    }

    public static enum SecurityMode {
        UNKNOWN("unknown"),
        IDENTIFIED("identified"),
        VERIFIED("verified"),
        CHROMEUI("chromeUI");

        private final String mId;

        private SecurityMode(String string3) {
            this.mId = string3;
        }

        public static SecurityMode fromString(String string2) {
            if (string2 == null) {
                throw new IllegalArgumentException("Can't convert null String to SiteIdentity");
            }
            for (SecurityMode securityMode : SecurityMode.values()) {
                if (!TextUtils.equals((CharSequence)securityMode.mId, (CharSequence)string2)) continue;
                return securityMode;
            }
            throw new IllegalArgumentException("Could not convert String id to SiteIdentity");
        }

        public String toString() {
            return this.mId;
        }
    }
}

