/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.feeds.subscriptions;

import android.database.Cursor;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.gecko.feeds.FeedFetcher;
import org.mozilla.gecko.feeds.parser.Item;

public class FeedSubscription {
    private static final String JSON_KEY_FEED_TITLE = "feed_title";
    private static final String JSON_KEY_LAST_ITEM_TITLE = "last_item_title";
    private static final String JSON_KEY_LAST_ITEM_URL = "last_item_url";
    private static final String JSON_KEY_LAST_ITEM_TIMESTAMP = "last_item_timestamp";
    private static final String JSON_KEY_ETAG = "etag";
    private static final String JSON_KEY_LAST_MODIFIED = "last_modified";
    private String feedUrl;
    private String feedTitle;
    private String lastItemTitle;
    private String lastItemUrl;
    private long lastItemTimestamp;
    private String etag;
    private String lastModified;

    public static FeedSubscription create(String string2, FeedFetcher.FeedResponse feedResponse) {
        FeedSubscription feedSubscription = new FeedSubscription();
        feedSubscription.feedUrl = string2;
        feedSubscription.update(feedResponse);
        return feedSubscription;
    }

    public static FeedSubscription fromCursor(Cursor cursor) throws JSONException {
        FeedSubscription feedSubscription = new FeedSubscription();
        feedSubscription.feedUrl = cursor.getString(cursor.getColumnIndex("url"));
        String string2 = cursor.getString(cursor.getColumnIndex("value"));
        feedSubscription.fromJSON(new JSONObject(string2));
        return feedSubscription;
    }

    private void fromJSON(JSONObject jSONObject) throws JSONException {
        this.feedTitle = jSONObject.getString(JSON_KEY_FEED_TITLE);
        this.lastItemTitle = jSONObject.getString(JSON_KEY_LAST_ITEM_TITLE);
        this.lastItemUrl = jSONObject.getString(JSON_KEY_LAST_ITEM_URL);
        this.lastItemTimestamp = jSONObject.getLong(JSON_KEY_LAST_ITEM_TIMESTAMP);
        this.etag = jSONObject.optString(JSON_KEY_ETAG);
        this.lastModified = jSONObject.optString(JSON_KEY_LAST_MODIFIED);
    }

    public void update(FeedFetcher.FeedResponse feedResponse) {
        this.feedTitle = feedResponse.feed.getTitle();
        this.lastItemTitle = feedResponse.feed.getLastItem().getTitle();
        this.lastItemUrl = feedResponse.feed.getLastItem().getURL();
        this.lastItemTimestamp = feedResponse.feed.getLastItem().getTimestamp();
        this.etag = feedResponse.etag;
        this.lastModified = feedResponse.lastModified;
    }

    public boolean hasBeenUpdated(FeedFetcher.FeedResponse feedResponse) {
        Item item = feedResponse.feed.getLastItem();
        if (item.getTimestamp() > this.lastItemTimestamp) {
            return true;
        }
        if (item.getTimestamp() == this.lastItemTimestamp && item.getTimestamp() != 0L) {
            return false;
        }
        return !item.getURL().equals(this.lastItemUrl);
    }

    public String getFeedUrl() {
        return this.feedUrl;
    }

    public String getFeedTitle() {
        return this.feedTitle;
    }

    public String getETag() {
        return this.etag;
    }

    public String getLastModified() {
        return this.lastModified;
    }

    public JSONObject toJSON() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put(JSON_KEY_FEED_TITLE, (Object)this.feedTitle);
        jSONObject.put(JSON_KEY_LAST_ITEM_TITLE, (Object)this.lastItemTitle);
        jSONObject.put(JSON_KEY_LAST_ITEM_URL, (Object)this.lastItemUrl);
        jSONObject.put(JSON_KEY_LAST_ITEM_TIMESTAMP, this.lastItemTimestamp);
        jSONObject.put(JSON_KEY_ETAG, (Object)this.etag);
        jSONObject.put(JSON_KEY_LAST_MODIFIED, (Object)this.lastModified);
        return jSONObject;
    }
}

