/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.gcm;

import android.content.Context;
import android.content.SharedPreferences;
import android.support.annotation.NonNull;
import android.util.Log;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.iid.InstanceID;
import java.io.IOException;
import org.mozilla.gecko.GeckoSharedPrefs;
import org.mozilla.gecko.push.Fetched;

public class GcmTokenClient {
    private static final String LOG_TAG = "GeckoPushGCM";
    private static final String KEY_GCM_TOKEN = "gcm_token";
    private static final String KEY_GCM_TOKEN_TIMESTAMP = "gcm_token_timestamp";
    private final Context context;

    public GcmTokenClient(Context context) {
        this.context = context;
    }

    protected void ensurePlayServices(Context context) throws NeedsGooglePlayServicesException {
        GoogleApiAvailability googleApiAvailability = GoogleApiAvailability.getInstance();
        int n = googleApiAvailability.isGooglePlayServicesAvailable(context);
        if (n != 0) {
            Log.w((String)LOG_TAG, (String)("This device does not support GCM! isGooglePlayServicesAvailable returned: " + n));
            Log.w((String)LOG_TAG, (String)("isGooglePlayServicesAvailable message: " + googleApiAvailability.getErrorString(n)));
            throw new NeedsGooglePlayServicesException(n);
        }
    }

    @NonNull
    public Fetched getToken(@NonNull String string2, boolean bl) throws NeedsGooglePlayServicesException, IOException {
        this.ensurePlayServices(this.context);
        SharedPreferences sharedPreferences = GeckoSharedPrefs.forApp(this.context);
        String string3 = sharedPreferences.getString(KEY_GCM_TOKEN, null);
        long l = sharedPreferences.getLong(KEY_GCM_TOKEN_TIMESTAMP, 0L);
        if (string3 != null && l > 0L) {
            if (bl) {
                Log.i((String)LOG_TAG, (String)("Cached GCM token exists: " + string3));
            } else {
                Log.i((String)LOG_TAG, (String)"Cached GCM token exists.");
            }
            return new Fetched(string3, l);
        }
        Log.i((String)LOG_TAG, (String)("Cached GCM token does not exist; requesting new token with sender ID: " + string2));
        InstanceID instanceID = InstanceID.getInstance((Context)this.context);
        string3 = instanceID.getToken(string2, "GCM", null);
        l = System.currentTimeMillis();
        if (bl) {
            Log.i((String)LOG_TAG, (String)("Got fresh GCM token; caching: " + string3));
        } else {
            Log.i((String)LOG_TAG, (String)"Got fresh GCM token; caching.");
        }
        sharedPreferences.edit().putString(KEY_GCM_TOKEN, string3).putLong(KEY_GCM_TOKEN_TIMESTAMP, l).apply();
        return new Fetched(string3, l);
    }

    public void invalidateToken() {
        SharedPreferences sharedPreferences = GeckoSharedPrefs.forApp(this.context);
        sharedPreferences.edit().remove(KEY_GCM_TOKEN).remove(KEY_GCM_TOKEN_TIMESTAMP).apply();
    }

    public class NeedsGooglePlayServicesException
    extends Exception {
        private static final long serialVersionUID = 4132853166L;
        private final int resultCode;

        NeedsGooglePlayServicesException(int n) {
            this.resultCode = n;
        }

        public void showErrorNotification() {
            GoogleApiAvailability googleApiAvailability = GoogleApiAvailability.getInstance();
            googleApiAvailability.showErrorNotification(GcmTokenClient.this.context, this.resultCode);
        }
    }
}

