/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.home;

import android.content.Context;
import android.database.Cursor;
import android.util.AttributeSet;
import android.widget.LinearLayout;
import android.widget.TextView;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.util.Date;
import org.mozilla.gecko.R;

class BookmarkScreenshotRow
extends LinearLayout {
    private TextView titleView;
    private TextView dateView;
    private static final DateFormat dateFormat = DateFormat.getDateInstance(1);
    private static final DateFormat timeFormat = DateFormat.getTimeInstance(3);
    private static final FieldPosition dummyFieldPosition = new FieldPosition(-1);

    public BookmarkScreenshotRow(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
    }

    public void onFinishInflate() {
        super.onFinishInflate();
        this.titleView = (TextView)this.findViewById(R.id.title);
        this.dateView = (TextView)this.findViewById(R.id.date);
    }

    public void updateFromCursor(Cursor cursor) {
        this.titleView.setText((CharSequence)BookmarkScreenshotRow.getTitleFromCursor(cursor));
        this.dateView.setText((CharSequence)BookmarkScreenshotRow.getDateFromCursor(cursor));
    }

    private static String getTitleFromCursor(Cursor cursor) {
        int n = cursor.getColumnIndexOrThrow("url");
        return cursor.getString(n);
    }

    private static String getDateFromCursor(Cursor cursor) {
        long l = cursor.getLong(cursor.getColumnIndexOrThrow("created"));
        Date date = new Date(l);
        StringBuffer stringBuffer = new StringBuffer();
        dateFormat.format(date, stringBuffer, dummyFieldPosition).append(" - ");
        timeFormat.format(date, stringBuffer, dummyFieldPosition);
        return stringBuffer.toString();
    }
}

