/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.home;

import android.content.Context;
import android.database.Cursor;
import android.support.v4.content.ContextCompat;
import android.support.v7.widget.RecyclerView;
import android.util.Log;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import org.mozilla.gecko.R;
import org.mozilla.gecko.db.RemoteClient;
import org.mozilla.gecko.db.RemoteTab;
import org.mozilla.gecko.home.ClientsAdapter;
import org.mozilla.gecko.home.TwoLinePageRow;

public abstract class CombinedHistoryItem
extends RecyclerView.ViewHolder {
    private static final String LOGTAG = "CombinedHistoryItem";

    public CombinedHistoryItem(View view) {
        super(view);
    }

    public static class ClientItem
    extends CombinedHistoryItem {
        final TextView nameView;
        final ImageView deviceTypeView;
        final TextView lastModifiedView;
        final ImageView deviceExpanded;

        public ClientItem(View view) {
            super(view);
            this.nameView = (TextView)view.findViewById(R.id.client);
            this.deviceTypeView = (ImageView)view.findViewById(R.id.device_type);
            this.lastModifiedView = (TextView)view.findViewById(R.id.last_synced);
            this.deviceExpanded = (ImageView)view.findViewById(R.id.device_expanded);
        }

        public void bind(Context context, RemoteClient remoteClient, boolean bl) {
            this.nameView.setText((CharSequence)remoteClient.name);
            long l = System.currentTimeMillis();
            this.lastModifiedView.setText((CharSequence)ClientsAdapter.getLastSyncedString(context, l, remoteClient.lastModified));
            if (remoteClient.isDesktop()) {
                this.deviceTypeView.setImageResource(bl ? R.drawable.sync_desktop_inactive : R.drawable.sync_desktop);
            } else {
                this.deviceTypeView.setImageResource(bl ? R.drawable.sync_mobile_inactive : R.drawable.sync_mobile);
            }
            this.nameView.setTextColor(ContextCompat.getColor((Context)context, (int)(bl ? R.color.tabs_tray_icon_grey : R.color.placeholder_active_grey)));
            if (remoteClient.tabs.size() > 0) {
                this.deviceExpanded.setImageResource(bl ? R.drawable.home_group_collapsed : R.drawable.arrow_down);
            }
        }
    }

    public static class HistoryItem
    extends CombinedHistoryItem {
        public HistoryItem(View view) {
            super(view);
        }

        public void bind(Cursor cursor) {
            TwoLinePageRow twoLinePageRow = (TwoLinePageRow)this.itemView;
            twoLinePageRow.setShowIcons(true);
            twoLinePageRow.updateFromCursor(cursor);
        }

        public void bind(RemoteTab remoteTab) {
            TwoLinePageRow twoLinePageRow = (TwoLinePageRow)this.itemView;
            twoLinePageRow.setShowIcons(true);
            twoLinePageRow.update(remoteTab.title, remoteTab.url);
        }
    }

    public static class SmartFolder
    extends CombinedHistoryItem {
        final Context context;
        final ImageView icon;
        final TextView title;
        final TextView subtext;

        public SmartFolder(View view) {
            super(view);
            this.context = view.getContext();
            this.icon = (ImageView)view.findViewById(R.id.device_type);
            this.title = (TextView)view.findViewById(R.id.title);
            this.subtext = (TextView)view.findViewById(R.id.subtext);
        }

        public void bind(int n, int n2, int n3, int n4, int n5) {
            this.icon.setImageResource(n);
            this.title.setText(n2);
            String string2 = n5 == 1 ? this.context.getString(n3) : this.context.getString(n4, new Object[]{n5});
            this.subtext.setText((CharSequence)string2);
        }
    }

    public static class BasicItem
    extends CombinedHistoryItem {
        public BasicItem(View view) {
            super(view);
        }
    }

    public static enum ItemType {
        CLIENT,
        HIDDEN_DEVICES,
        SECTION_HEADER,
        HISTORY,
        NAVIGATION_BACK,
        CHILD,
        SYNCED_DEVICES;


        public static ItemType viewTypeToItemType(int n) {
            if (n >= ItemType.values().length) {
                Log.e((String)CombinedHistoryItem.LOGTAG, (String)"No corresponding ItemType!");
            }
            return ItemType.values()[n];
        }

        public static int itemTypeToViewType(ItemType itemType) {
            return itemType.ordinal();
        }
    }
}

