/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.media;

import android.content.Context;
import android.content.Intent;
import android.media.AudioManager;
import android.util.Log;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.annotation.RobocopTarget;
import org.mozilla.gecko.annotation.WrapForJNI;
import org.mozilla.gecko.media.MediaControlService;

public class AudioFocusAgent {
    private static final String LOGTAG = "AudioFocusAgent";
    private static Context mContext;
    private AudioManager mAudioManager;
    private AudioManager.OnAudioFocusChangeListener mAfChangeListener;
    public static final String OWN_FOCUS = "own_focus";
    public static final String LOST_FOCUS = "lost_focus";
    public static final String LOST_FOCUS_TRANSIENT = "lost_focus_transient";
    private String mAudioFocusState = "lost_focus";

    @WrapForJNI
    public static void notifyStartedPlaying() {
        if (!AudioFocusAgent.isAttachedToContext()) {
            return;
        }
        Log.d((String)LOGTAG, (String)"NotifyStartedPlaying");
        AudioFocusAgent.getInstance().requestAudioFocusIfNeeded();
    }

    @WrapForJNI
    public static void notifyStoppedPlaying() {
        if (!AudioFocusAgent.isAttachedToContext()) {
            return;
        }
        Log.d((String)LOGTAG, (String)"NotifyStoppedPlaying");
        AudioFocusAgent.getInstance().abandonAudioFocusIfNeeded();
    }

    public synchronized void attachToContext(Context context) {
        if (AudioFocusAgent.isAttachedToContext()) {
            return;
        }
        mContext = context;
        this.mAudioManager = (AudioManager)mContext.getSystemService("audio");
        this.mAfChangeListener = new AudioManager.OnAudioFocusChangeListener(){

            public void onAudioFocusChange(int n) {
                switch (n) {
                    case -1: {
                        Log.d((String)AudioFocusAgent.LOGTAG, (String)"onAudioFocusChange, AUDIOFOCUS_LOSS");
                        AudioFocusAgent.this.notifyObservers("AudioFocusChanged", "lostAudioFocus");
                        AudioFocusAgent.this.notifyMediaControlService("action_pause");
                        AudioFocusAgent.this.mAudioFocusState = AudioFocusAgent.LOST_FOCUS;
                        break;
                    }
                    case -2: {
                        Log.d((String)AudioFocusAgent.LOGTAG, (String)"onAudioFocusChange, AUDIOFOCUS_LOSS_TRANSIENT");
                        AudioFocusAgent.this.notifyObservers("AudioFocusChanged", "lostAudioFocusTransiently");
                        AudioFocusAgent.this.notifyMediaControlService("action_pause");
                        AudioFocusAgent.this.mAudioFocusState = AudioFocusAgent.LOST_FOCUS_TRANSIENT;
                        break;
                    }
                    case 1: {
                        Log.d((String)AudioFocusAgent.LOGTAG, (String)"onAudioFocusChange, AUDIOFOCUS_GAIN");
                        AudioFocusAgent.this.notifyObservers("AudioFocusChanged", "gainAudioFocus");
                        AudioFocusAgent.this.notifyMediaControlService("action_play");
                        AudioFocusAgent.this.mAudioFocusState = AudioFocusAgent.OWN_FOCUS;
                        break;
                    }
                }
            }
        };
    }

    @RobocopTarget
    public static AudioFocusAgent getInstance() {
        return SingletonHolder.INSTANCE;
    }

    private static boolean isAttachedToContext() {
        return mContext != null;
    }

    private void notifyObservers(String string2, String string3) {
        GeckoAppShell.notifyObservers(string2, string3);
    }

    private AudioFocusAgent() {
    }

    private void requestAudioFocusIfNeeded() {
        if (this.mAudioFocusState.equals(OWN_FOCUS)) {
            return;
        }
        int n = this.mAudioManager.requestAudioFocus(this.mAfChangeListener, 3, 1);
        String string2 = n == 1 ? "AudioFocus request granted" : "AudioFoucs request failed";
        Log.d((String)LOGTAG, (String)string2);
        if (n == 1) {
            this.mAudioFocusState = OWN_FOCUS;
            this.notifyMediaControlService("action_start");
        }
    }

    private void abandonAudioFocusIfNeeded() {
        if (!this.mAudioFocusState.equals(OWN_FOCUS)) {
            return;
        }
        Log.d((String)LOGTAG, (String)"Abandon AudioFocus");
        this.mAudioManager.abandonAudioFocus(this.mAfChangeListener);
        this.mAudioFocusState = LOST_FOCUS;
        this.notifyMediaControlService("action_stop");
    }

    private void notifyMediaControlService(String string2) {
        Intent intent = new Intent(mContext, MediaControlService.class);
        intent.setAction(string2);
        mContext.startService(intent);
    }

    private static class SingletonHolder {
        private static final AudioFocusAgent INSTANCE = new AudioFocusAgent();

        private SingletonHolder() {
        }
    }
}

