/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.media;

import android.app.Notification;
import android.app.PendingIntent;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.media.session.MediaController;
import android.media.session.MediaSession;
import android.os.Build;
import android.os.Bundle;
import android.os.IBinder;
import android.support.v4.app.NotificationManagerCompat;
import android.util.Log;
import java.lang.ref.WeakReference;
import org.mozilla.gecko.BrowserApp;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.PrefsHelper;
import org.mozilla.gecko.R;
import org.mozilla.gecko.Tab;
import org.mozilla.gecko.Tabs;
import org.mozilla.gecko.util.ThreadUtils;

public class MediaControlService
extends Service
implements Tabs.OnTabsChangedListener {
    private static final String LOGTAG = "MediaControlService";
    public static final String ACTION_START = "action_start";
    public static final String ACTION_PLAY = "action_play";
    public static final String ACTION_PAUSE = "action_pause";
    public static final String ACTION_STOP = "action_stop";
    public static final String ACTION_REMOVE_CONTROL = "action_remove_control";
    private static final int MEDIA_CONTROL_ID = 1;
    private static final String MEDIA_CONTROL_PREF = "dom.audiochannel.mediaControl";
    private String mActionState = "action_stop";
    private MediaSession mSession;
    private MediaController mController;
    private PrefsHelper.PrefHandler mPrefsObserver;
    private final String[] mPrefs = new String[]{"dom.audiochannel.mediaControl"};
    private boolean mIsInitMediaSession = false;
    private boolean mIsMediaControlPrefOn = true;
    private static WeakReference<Tab> mTabReference = null;
    private int coverSize;

    public void onCreate() {
        mTabReference = new WeakReference<Object>(null);
        this.getGeckoPreference();
        this.initMediaSession();
        this.coverSize = (int)this.getResources().getDimension(R.dimen.notification_media_cover);
        Tabs.registerOnTabsChangedListener(this);
    }

    public void onDestroy() {
        this.notifyControlInterfaceChanged(ACTION_REMOVE_CONTROL);
        PrefsHelper.removeObserver(this.mPrefsObserver);
        Tabs.unregisterOnTabsChangedListener(this);
    }

    public int onStartCommand(Intent intent, int n, int n2) {
        this.handleIntent(intent);
        return super.onStartCommand(intent, n, n2);
    }

    public IBinder onBind(Intent intent) {
        return null;
    }

    public boolean onUnbind(Intent intent) {
        this.mSession.release();
        return super.onUnbind(intent);
    }

    public void onTaskRemoved(Intent intent) {
        this.stopSelf();
    }

    @Override
    public void onTabChanged(Tab tab, Tabs.TabEvents tabEvents, String string2) {
        if (!this.mIsInitMediaSession) {
            return;
        }
        if (tab == mTabReference.get()) {
            return;
        }
        if (tabEvents == Tabs.TabEvents.AUDIO_PLAYING_CHANGE && tab.isAudioPlaying()) {
            mTabReference = new WeakReference<Tab>(tab);
            this.notifyControlInterfaceChanged(ACTION_PAUSE);
        }
    }

    private boolean isAndroidVersionLollopopOrHigher() {
        return Build.VERSION.SDK_INT >= 21;
    }

    private void handleIntent(Intent intent) {
        if (intent == null || intent.getAction() == null || !this.mIsInitMediaSession) {
            return;
        }
        Log.d((String)LOGTAG, (String)("HandleIntent, action = " + intent.getAction() + ", actionState = " + this.mActionState));
        switch (intent.getAction()) {
            case "action_start": {
                this.mController.getTransportControls().sendCustomAction(ACTION_START, null);
                break;
            }
            case "action_play": {
                this.mController.getTransportControls().play();
                break;
            }
            case "action_pause": {
                this.mController.getTransportControls().pause();
                break;
            }
            case "action_stop": {
                if (!this.mActionState.equals(ACTION_PLAY)) {
                    return;
                }
                this.mController.getTransportControls().stop();
                break;
            }
            case "action_remove_control": {
                this.mController.getTransportControls().stop();
            }
        }
    }

    private void getGeckoPreference() {
        this.mPrefsObserver = new PrefsHelper.PrefHandlerBase(){

            @Override
            public void prefValue(String string2, boolean bl) {
                if (string2.equals(MediaControlService.MEDIA_CONTROL_PREF)) {
                    MediaControlService.this.mIsMediaControlPrefOn = bl;
                    if (MediaControlService.this.mActionState.equals(MediaControlService.ACTION_PLAY)) {
                        MediaControlService.this.notifyControlInterfaceChanged(MediaControlService.this.mIsMediaControlPrefOn ? MediaControlService.ACTION_PAUSE : MediaControlService.ACTION_REMOVE_CONTROL);
                    }
                    if (MediaControlService.this.mActionState.equals(MediaControlService.ACTION_PAUSE) && !MediaControlService.this.mIsMediaControlPrefOn) {
                        Intent intent = new Intent(MediaControlService.this.getApplicationContext(), MediaControlService.class);
                        intent.setAction(MediaControlService.ACTION_REMOVE_CONTROL);
                        MediaControlService.this.handleIntent(intent);
                    }
                }
            }
        };
        PrefsHelper.addObserver(this.mPrefs, this.mPrefsObserver);
    }

    private void initMediaSession() {
        if (!this.isAndroidVersionLollopopOrHigher() || this.mIsInitMediaSession) {
            return;
        }
        this.mSession = new MediaSession(this.getApplicationContext(), "fennec media session");
        this.mController = new MediaController(this.getApplicationContext(), this.mSession.getSessionToken());
        this.mSession.setCallback(new MediaSession.Callback(){

            public void onCustomAction(String string2, Bundle bundle) {
                if (string2.equals(MediaControlService.ACTION_START)) {
                    Log.d((String)MediaControlService.LOGTAG, (String)"Controller, onStart");
                    MediaControlService.this.notifyControlInterfaceChanged(MediaControlService.ACTION_PAUSE);
                    MediaControlService.this.mActionState = MediaControlService.ACTION_PLAY;
                }
            }

            public void onPlay() {
                Log.d((String)MediaControlService.LOGTAG, (String)"Controller, onPlay");
                super.onPlay();
                MediaControlService.this.notifyControlInterfaceChanged(MediaControlService.ACTION_PAUSE);
                MediaControlService.this.notifyObservers("MediaControl", "resumeMedia");
                MediaControlService.this.mActionState = MediaControlService.ACTION_PLAY;
            }

            public void onPause() {
                Log.d((String)MediaControlService.LOGTAG, (String)"Controller, onPause");
                super.onPause();
                MediaControlService.this.notifyControlInterfaceChanged(MediaControlService.ACTION_PLAY);
                MediaControlService.this.notifyObservers("MediaControl", "mediaControlPaused");
                MediaControlService.this.mActionState = MediaControlService.ACTION_PAUSE;
            }

            public void onStop() {
                Log.d((String)MediaControlService.LOGTAG, (String)"Controller, onStop");
                super.onStop();
                MediaControlService.this.notifyControlInterfaceChanged(MediaControlService.ACTION_STOP);
                MediaControlService.this.notifyObservers("MediaControl", "mediaControlStopped");
                MediaControlService.this.mActionState = MediaControlService.ACTION_STOP;
                MediaControlService.this.stopSelf();
            }
        });
        this.mIsInitMediaSession = true;
    }

    private void notifyObservers(String string2, String string3) {
        GeckoAppShell.notifyObservers(string2, string3);
    }

    private boolean isNeedToRemoveControlInterface(String string2) {
        return string2.equals(ACTION_STOP) || string2.equals(ACTION_REMOVE_CONTROL);
    }

    private void notifyControlInterfaceChanged(final String string2) {
        Log.d((String)LOGTAG, (String)("notifyControlInterfaceChanged, action = " + string2));
        if (this.isNeedToRemoveControlInterface(string2)) {
            NotificationManagerCompat.from((Context)this).cancel(1);
            return;
        }
        if (!this.mIsMediaControlPrefOn) {
            return;
        }
        final Tab tab = (Tab)mTabReference.get();
        if (tab == null) {
            return;
        }
        ThreadUtils.postToBackgroundThread((Runnable)new Runnable(){

            @Override
            public void run() {
                MediaControlService.this.updateNotification(tab, string2);
            }
        });
    }

    private void updateNotification(Tab tab, String string2) {
        ThreadUtils.assertNotOnUiThread();
        Notification.MediaStyle mediaStyle = new Notification.MediaStyle();
        mediaStyle.setShowActionsInCompactView(new int[]{0});
        Notification notification = new Notification.Builder((Context)this).setSmallIcon(R.drawable.flat_icon).setLargeIcon(this.generateCoverArt(tab)).setContentTitle((CharSequence)tab.getTitle()).setContentText((CharSequence)tab.getURL()).setContentIntent(this.createContentIntent()).setDeleteIntent(this.createDeleteIntent()).setStyle((Notification.Style)mediaStyle).addAction(this.createNotificationAction(string2)).setOngoing(string2.equals(ACTION_PAUSE)).setShowWhen(false).setWhen(0L).build();
        NotificationManagerCompat.from((Context)this).notify(1, notification);
    }

    private Notification.Action createNotificationAction(String string2) {
        boolean bl = string2.equals(ACTION_PLAY);
        int n = bl ? R.drawable.ic_media_play : R.drawable.ic_media_pause;
        String string3 = this.getString(bl ? R.string.media_pause : R.string.media_pause);
        Intent intent = new Intent(this.getApplicationContext(), MediaControlService.class);
        intent.setAction(string2);
        PendingIntent pendingIntent = PendingIntent.getService((Context)this.getApplicationContext(), (int)1, (Intent)intent, (int)0);
        return new Notification.Action.Builder(n, (CharSequence)string3, pendingIntent).build();
    }

    private PendingIntent createContentIntent() {
        Intent intent = new Intent(this.getApplicationContext(), BrowserApp.class);
        return PendingIntent.getActivity((Context)this.getApplicationContext(), (int)0, (Intent)intent, (int)0);
    }

    private PendingIntent createDeleteIntent() {
        Intent intent = new Intent(this.getApplicationContext(), MediaControlService.class);
        intent.setAction(ACTION_REMOVE_CONTROL);
        return PendingIntent.getService((Context)this.getApplicationContext(), (int)1, (Intent)intent, (int)0);
    }

    private Bitmap generateCoverArt(Tab tab) {
        Bitmap bitmap = tab.getFavicon();
        if (bitmap == null || bitmap.getWidth() < 72 || bitmap.getHeight() < 72) {
            return BitmapFactory.decodeResource((Resources)this.getResources(), (int)R.drawable.notification_media);
        }
        int n = Math.max(bitmap.getWidth(), this.coverSize / 2);
        int n2 = Math.max(bitmap.getHeight(), this.coverSize / 2);
        Bitmap bitmap2 = Bitmap.createBitmap((int)this.coverSize, (int)this.coverSize, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap2);
        canvas.drawColor(-8947849);
        int n3 = Math.max(0, bitmap2.getWidth() / 2 - n / 2);
        int n4 = Math.min(this.coverSize, n3 + n);
        int n5 = Math.max(0, bitmap2.getHeight() / 2 - n2 / 2);
        int n6 = Math.min(this.coverSize, n5 + n2);
        Paint paint = new Paint();
        paint.setAntiAlias(true);
        canvas.drawBitmap(bitmap, new Rect(0, 0, bitmap.getWidth(), bitmap.getHeight()), new Rect(n3, n5, n4, n6), paint);
        return bitmap2;
    }
}

