/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.telemetry;

import android.app.IntentService;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.util.Log;
import ch.boye.httpclientandroidlib.HttpResponse;
import ch.boye.httpclientandroidlib.client.ClientProtocolException;
import ch.boye.httpclientandroidlib.client.methods.HttpRequestBase;
import ch.boye.httpclientandroidlib.impl.client.DefaultHttpClient;
import java.io.IOException;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.mozilla.gecko.GeckoProfile;
import org.mozilla.gecko.GeckoSharedPrefs;
import org.mozilla.gecko.preferences.GeckoPreferences;
import org.mozilla.gecko.sync.ExtendedJSONObject;
import org.mozilla.gecko.sync.net.BaseResource;
import org.mozilla.gecko.sync.net.BaseResourceDelegate;
import org.mozilla.gecko.sync.net.Resource;
import org.mozilla.gecko.telemetry.TelemetryPing;
import org.mozilla.gecko.telemetry.stores.TelemetryPingStore;
import org.mozilla.gecko.util.DateUtil;
import org.mozilla.gecko.util.NetworkUtils;
import org.mozilla.gecko.util.StringUtils;

public class TelemetryUploadService
extends IntentService {
    private static final String LOGTAG = StringUtils.safeSubstring((String)("Gecko" + TelemetryUploadService.class.getSimpleName()), (int)0, (int)23);
    private static final String WORKER_THREAD_NAME = LOGTAG + "Worker";
    public static final String ACTION_UPLOAD = "upload";
    public static final String EXTRA_STORE = "store";
    private static volatile boolean isDisabled = false;

    public static void setDisabled(boolean bl) {
        isDisabled = bl;
        if (bl) {
            Log.d((String)LOGTAG, (String)"Telemetry upload disabled (env var?");
        }
    }

    public TelemetryUploadService() {
        super(WORKER_THREAD_NAME);
        this.setIntentRedelivery(false);
    }

    public void onHandleIntent(Intent intent) {
        Log.d((String)LOGTAG, (String)"Service started");
        if (!TelemetryUploadService.isReadyToUpload((Context)this, intent)) {
            return;
        }
        TelemetryPingStore telemetryPingStore = (TelemetryPingStore)intent.getParcelableExtra(EXTRA_STORE);
        boolean bl = TelemetryUploadService.uploadPendingPingsFromStore((Context)this, telemetryPingStore);
        telemetryPingStore.maybePrunePings();
        Log.d((String)LOGTAG, (String)"Service finished: upload and prune attempts completed");
        if (!bl) {
            Log.d((String)LOGTAG, (String)"Clearing Intent queue due to connection failures");
            this.stopSelf();
        }
    }

    private static boolean uploadPendingPingsFromStore(Context context, TelemetryPingStore telemetryPingStore) {
        boolean bl;
        List<TelemetryPing> list = telemetryPingStore.getAllPings();
        if (list.isEmpty()) {
            return true;
        }
        String string2 = TelemetryUploadService.getServerSchemeHostPort(context);
        HashSet<String> hashSet = new HashSet<String>(list.size());
        PingResultDelegate pingResultDelegate = new PingResultDelegate(hashSet);
        for (TelemetryPing telemetryPing : list) {
            pingResultDelegate.setDocID(telemetryPing.getDocID());
            String string3 = string2 + "/" + telemetryPing.getURLPath();
            TelemetryUploadService.uploadPayload(string3, telemetryPing.getPayload(), pingResultDelegate);
            if (!pingResultDelegate.hadConnectionError()) continue;
            break;
        }
        boolean bl2 = bl = !pingResultDelegate.hadConnectionError();
        if (bl) {
            Log.d((String)LOGTAG, (String)"Telemetry upload success!");
        }
        telemetryPingStore.onUploadAttemptComplete(hashSet);
        return bl;
    }

    private static String getServerSchemeHostPort(Context context) {
        SharedPreferences sharedPreferences = GeckoSharedPrefs.forApp(context);
        return sharedPreferences.getString("telemetry-serverUrl", "https://incoming.telemetry.mozilla.org");
    }

    private static void uploadPayload(String string2, ExtendedJSONObject extendedJSONObject, ResultDelegate resultDelegate) {
        BaseResource baseResource;
        try {
            baseResource = new BaseResource(string2);
        }
        catch (URISyntaxException uRISyntaxException) {
            Log.w((String)LOGTAG, (String)"URISyntaxException for server URL when creating BaseResource: returning.");
            return;
        }
        resultDelegate.setResource((Resource)baseResource);
        baseResource.delegate = resultDelegate;
        baseResource.setShouldCompressUploadedEntity(true);
        baseResource.setShouldChunkUploadsHint(false);
        baseResource.postBlocking(extendedJSONObject);
    }

    private static boolean isReadyToUpload(Context context, Intent intent) {
        if (!TelemetryUploadService.isUploadEnabledByAppConfig(context)) {
            Log.w((String)LOGTAG, (String)"Upload is not available by configuration; returning");
            return false;
        }
        if (!NetworkUtils.isConnected((Context)context)) {
            Log.w((String)LOGTAG, (String)"Network is not connected; returning");
            return false;
        }
        if (!TelemetryUploadService.isIntentValid(intent)) {
            Log.w((String)LOGTAG, (String)"Received invalid Intent; returning");
            return false;
        }
        if (!ACTION_UPLOAD.equals(intent.getAction())) {
            Log.w((String)LOGTAG, (String)("Unknown action: " + intent.getAction() + ". Returning"));
            return false;
        }
        return true;
    }

    public static boolean isUploadEnabledByAppConfig(Context context) {
        if (isDisabled) {
            Log.d((String)LOGTAG, (String)"Telemetry upload feature is disabled by intent (in testing?)");
            return false;
        }
        if (!GeckoPreferences.getBooleanPref(context, GeckoPreferences.PREFS_HEALTHREPORT_UPLOAD_ENABLED, true)) {
            Log.d((String)LOGTAG, (String)"Telemetry upload opt-out");
            return false;
        }
        return true;
    }

    public static boolean isUploadEnabledByProfileConfig(Context context, GeckoProfile geckoProfile) {
        if (geckoProfile.inGuestMode()) {
            Log.d((String)LOGTAG, (String)"Profile is in guest mode");
            return false;
        }
        return TelemetryUploadService.isUploadEnabledByAppConfig(context);
    }

    private static boolean isIntentValid(Intent intent) {
        if (intent == null) {
            Log.d((String)LOGTAG, (String)"Received null intent");
            return false;
        }
        if (intent.getParcelableExtra(EXTRA_STORE) == null) {
            Log.d((String)LOGTAG, (String)"Received invalid store in Intent");
            return false;
        }
        return true;
    }

    private static abstract class ResultDelegate
    extends BaseResourceDelegate {
        public ResultDelegate() {
            super(null);
        }

        protected void setResource(Resource resource) {
            this.resource = resource;
        }
    }

    private static class PingResultDelegate
    extends ResultDelegate {
        private static final int SOCKET_TIMEOUT_MILLIS = (int)TimeUnit.SECONDS.toMillis(30L);
        private static final int CONNECTION_TIMEOUT_MILLIS = (int)TimeUnit.SECONDS.toMillis(30L);
        private String docID = null;
        private final Set<String> successfulUploadIDs;
        private boolean hadConnectionError = false;

        public PingResultDelegate(Set<String> set) {
            this.successfulUploadIDs = set;
        }

        public int socketTimeout() {
            return SOCKET_TIMEOUT_MILLIS;
        }

        public int connectionTimeout() {
            return CONNECTION_TIMEOUT_MILLIS;
        }

        private String getDocID() {
            if (this.docID == null) {
                throw new IllegalStateException("Expected ping ID to have been updated before retrieval");
            }
            return this.docID;
        }

        public void setDocID(String string2) {
            this.docID = string2;
        }

        public String getUserAgent() {
            return "Firefox-Android-Telemetry/50.0a1 (Firefox)";
        }

        public void handleHttpResponse(HttpResponse httpResponse) {
            int n = httpResponse.getStatusLine().getStatusCode();
            switch (n) {
                case 200: 
                case 201: {
                    this.successfulUploadIDs.add(this.getDocID());
                    break;
                }
                default: {
                    Log.w((String)LOGTAG, (String)("Telemetry upload failure. HTTP status: " + n));
                    this.hadConnectionError = true;
                }
            }
        }

        public void handleHttpProtocolException(ClientProtocolException clientProtocolException) {
            Log.w((String)LOGTAG, (String)"HttpProtocolException when trying to upload telemetry");
            this.hadConnectionError = true;
        }

        public void handleHttpIOException(IOException iOException) {
            Log.w((String)LOGTAG, (String)"HttpIOException when trying to upload telemetry");
            this.hadConnectionError = true;
        }

        public void handleTransportException(GeneralSecurityException generalSecurityException) {
            Log.w((String)LOGTAG, (String)"Transport exception when trying to upload telemetry");
            this.hadConnectionError = true;
        }

        private boolean hadConnectionError() {
            return this.hadConnectionError;
        }

        public void addHeaders(HttpRequestBase httpRequestBase, DefaultHttpClient defaultHttpClient) {
            super.addHeaders(httpRequestBase, defaultHttpClient);
            httpRequestBase.addHeader("Date", DateUtil.getDateInHTTPFormat((Date)Calendar.getInstance().getTime()));
        }
    }
}

