/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.telemetry.measurements;

import android.content.SharedPreferences;
import android.support.annotation.NonNull;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.mozilla.gecko.sync.ExtendedJSONObject;

public class SearchCountMeasurements {
    static final String PREF_SEARCH_KEYSET = "measurements-search-count-keyset";
    private static final String PREF_SEARCH_PREFIX = "measurements-search-count-engine-";

    private SearchCountMeasurements() {
    }

    public static synchronized void incrementSearch(@NonNull SharedPreferences sharedPreferences, @NonNull String string2, @NonNull String string3) {
        String string4 = string2 + "." + string3;
        String string5 = SearchCountMeasurements.getEngineSearchCountKey(string4);
        int n = sharedPreferences.getInt(string5, 0);
        sharedPreferences.edit().putInt(string5, n + 1).apply();
        SearchCountMeasurements.unionKeyToSearchKeyset(sharedPreferences, string4);
    }

    private static void unionKeyToSearchKeyset(@NonNull SharedPreferences sharedPreferences, @NonNull String string2) {
        Set set = sharedPreferences.getStringSet(PREF_SEARCH_KEYSET, Collections.emptySet());
        if (set.contains(string2)) {
            return;
        }
        HashSet<String> hashSet = new HashSet<String>(set);
        hashSet.add(string2);
        sharedPreferences.edit().putStringSet(PREF_SEARCH_KEYSET, hashSet).apply();
    }

    public static synchronized ExtendedJSONObject getAndZeroSearch(@NonNull SharedPreferences sharedPreferences) {
        ExtendedJSONObject extendedJSONObject = new ExtendedJSONObject();
        SharedPreferences.Editor editor = sharedPreferences.edit();
        Set set = sharedPreferences.getStringSet(PREF_SEARCH_KEYSET, Collections.emptySet());
        for (String string2 : set) {
            String string3 = SearchCountMeasurements.getEngineSearchCountKey(string2);
            extendedJSONObject.put(string2, sharedPreferences.getInt(string3, 0));
            editor.remove(string3);
        }
        editor.remove(PREF_SEARCH_KEYSET).apply();
        return extendedJSONObject;
    }

    static String getEngineSearchCountKey(String string2) {
        return PREF_SEARCH_PREFIX + string2;
    }
}

