/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.widget;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Path;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.widget.LinearLayout;
import org.mozilla.gecko.AppConstants;
import org.mozilla.gecko.R;

public class RoundedCornerLayout
extends LinearLayout {
    private static final String LOGTAG = "Gecko" + RoundedCornerLayout.class.getSimpleName();
    private float cornerRadius;
    private Path path;
    boolean cannotClipPath;

    public RoundedCornerLayout(Context context) {
        super(context);
        this.init(context);
    }

    public RoundedCornerLayout(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.init(context);
    }

    public RoundedCornerLayout(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.init(context);
    }

    private void init(Context context) {
        this.cannotClipPath = AppConstants.Versions.feature11Plus && !AppConstants.Versions.feature19Plus;
        DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
        this.cornerRadius = TypedValue.applyDimension((int)0, (float)this.getResources().getDimensionPixelSize(R.dimen.doorhanger_rounded_corner_radius), (DisplayMetrics)displayMetrics);
        this.setWillNotDraw(false);
    }

    protected void onSizeChanged(int n, int n2, int n3, int n4) {
        super.onSizeChanged(n, n2, n3, n4);
        if (this.cannotClipPath) {
            return;
        }
        RectF rectF = new RectF(0.0f, 0.0f, (float)n, (float)n2);
        this.path = new Path();
        this.path.addRoundRect(rectF, this.cornerRadius, this.cornerRadius, Path.Direction.CW);
        this.path.close();
    }

    public void draw(Canvas canvas) {
        if (this.cannotClipPath) {
            super.draw(canvas);
            return;
        }
        canvas.save();
        canvas.clipPath(this.path);
        super.draw(canvas);
        canvas.restore();
    }
}

