/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.sync;

import android.content.SharedPreferences;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.mozilla.gecko.background.common.PrefsBranch;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.sync.CollectionKeys;
import org.mozilla.gecko.sync.ExtendedJSONObject;
import org.mozilla.gecko.sync.InfoCollections;
import org.mozilla.gecko.sync.MetaGlobal;
import org.mozilla.gecko.sync.PersistedMetaGlobal;
import org.mozilla.gecko.sync.crypto.KeyBundle;
import org.mozilla.gecko.sync.crypto.PersistedCrypto5Keys;
import org.mozilla.gecko.sync.net.AuthHeaderProvider;
import org.mozilla.gecko.sync.stage.GlobalSyncStage;

public class SyncConfiguration {
    private static final String LOG_TAG = "SyncConfiguration";
    public URI clusterURL;
    public KeyBundle syncKeyBundle;
    public CollectionKeys collectionKeys;
    public InfoCollections infoCollections;
    public MetaGlobal metaGlobal;
    public String syncID;
    protected final String username;
    public Set<String> enabledEngineNames;
    public Set<String> declinedEngineNames = new HashSet<String>();
    public Collection<String> stagesToSync;
    public Map<String, Boolean> userSelectedEngines;
    public long userSelectedEnginesTimestamp;
    public SharedPreferences prefs;
    protected final AuthHeaderProvider authHeaderProvider;
    public static final String PREF_PREFS_VERSION = "prefs.version";
    public static final long CURRENT_PREFS_VERSION = 1L;
    public static final String CLIENTS_COLLECTION_TIMESTAMP = "serverClientsTimestamp";
    public static final String CLIENT_RECORD_TIMESTAMP = "serverClientRecordTimestamp";
    public static final String MIGRATION_SENTINEL_CHECK_TIMESTAMP = "migrationSentinelCheckTimestamp";
    public static final String PREF_CLUSTER_URL = "clusterURL";
    public static final String PREF_SYNC_ID = "syncID";
    public static final String PREF_ENABLED_ENGINE_NAMES = "enabledEngineNames";
    public static final String PREF_DECLINED_ENGINE_NAMES = "declinedEngineNames";
    public static final String PREF_USER_SELECTED_ENGINES_TO_SYNC = "userSelectedEngines";
    public static final String PREF_USER_SELECTED_ENGINES_TO_SYNC_TIMESTAMP = "userSelectedEnginesTimestamp";
    public static final String PREF_CLUSTER_URL_IS_STALE = "clusterurlisstale";
    public static final String PREF_ACCOUNT_GUID = "account.guid";
    public static final String PREF_CLIENT_NAME = "account.clientName";
    public static final String PREF_NUM_CLIENTS = "account.numClients";
    public static final String PREF_CLIENT_DATA_TIMESTAMP = "account.clientDataTimestamp";
    private static final String API_VERSION = "1.5";

    public SyncConfiguration(String string, AuthHeaderProvider authHeaderProvider, SharedPreferences sharedPreferences) {
        this.username = string;
        this.authHeaderProvider = authHeaderProvider;
        this.prefs = sharedPreferences;
        this.loadFromPrefs(sharedPreferences);
    }

    public SyncConfiguration(String string, AuthHeaderProvider authHeaderProvider, SharedPreferences sharedPreferences, KeyBundle keyBundle) {
        this(string, authHeaderProvider, sharedPreferences);
        this.syncKeyBundle = keyBundle;
    }

    public String getAPIVersion() {
        return API_VERSION;
    }

    public SharedPreferences getPrefs() {
        return this.prefs;
    }

    public static Set<String> validEngineNames() {
        HashSet<String> hashSet = new HashSet<String>();
        for (GlobalSyncStage.Stage stage : GlobalSyncStage.Stage.getNamedStages()) {
            hashSet.add(stage.getRepositoryName());
        }
        return hashSet;
    }

    public PrefsBranch getBranch(String string) {
        return new PrefsBranch(this.getPrefs(), string);
    }

    protected static Set<String> getEngineNamesFromPref(SharedPreferences sharedPreferences, String string) {
        String string2 = sharedPreferences.getString(string, null);
        if (string2 == null) {
            return null;
        }
        try {
            ExtendedJSONObject extendedJSONObject = new ExtendedJSONObject(string2);
            return new HashSet<String>(extendedJSONObject.keySet());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Set<String> getEnabledEngineNames(SharedPreferences sharedPreferences) {
        return SyncConfiguration.getEngineNamesFromPref(sharedPreferences, PREF_ENABLED_ENGINE_NAMES);
    }

    public static Set<String> getDeclinedEngineNames(SharedPreferences sharedPreferences) {
        Set<String> set = SyncConfiguration.getEngineNamesFromPref(sharedPreferences, PREF_DECLINED_ENGINE_NAMES);
        if (set == null) {
            return new HashSet<String>();
        }
        return set;
    }

    public static Map<String, Boolean> getUserSelectedEngines(SharedPreferences sharedPreferences) {
        String string = sharedPreferences.getString(PREF_USER_SELECTED_ENGINES_TO_SYNC, null);
        if (string == null) {
            return null;
        }
        try {
            ExtendedJSONObject extendedJSONObject = new ExtendedJSONObject(string);
            HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
            for (Map.Entry<String, Object> entry : extendedJSONObject.entrySet()) {
                String string2 = entry.getKey();
                Boolean bl = (Boolean)entry.getValue();
                hashMap.put(string2, bl);
                if (!"history".equals(string2)) continue;
                hashMap.put("forms", bl);
            }
            if (!hashMap.containsKey("history")) {
                hashMap.remove("forms");
            }
            return hashMap;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static void storeSelectedEnginesToPrefs(SharedPreferences sharedPreferences, Map<String, Boolean> map) {
        String string;
        ExtendedJSONObject extendedJSONObject = new ExtendedJSONObject();
        HashSet<String> hashSet = new HashSet<String>();
        for (Map.Entry<String, Boolean> entry : map.entrySet()) {
            Boolean bl = entry.getValue();
            string = entry.getKey();
            extendedJSONObject.put(string, bl);
            if (bl.booleanValue()) continue;
            hashSet.add(string);
        }
        if (map.containsKey("history") && !map.get("history").booleanValue()) {
            hashSet.add("forms");
        }
        String string2 = extendedJSONObject.toJSONString();
        long l = System.currentTimeMillis();
        string = sharedPreferences.edit();
        string.putString(PREF_USER_SELECTED_ENGINES_TO_SYNC, string2);
        string.putString(PREF_DECLINED_ENGINE_NAMES, SyncConfiguration.setToJSONObjectString(hashSet));
        string.putLong(PREF_USER_SELECTED_ENGINES_TO_SYNC_TIMESTAMP, l);
        Logger.error(LOG_TAG, "Storing user-selected engines at [" + l + "].");
        string.commit();
    }

    public void loadFromPrefs(SharedPreferences sharedPreferences) {
        if (sharedPreferences.contains(PREF_CLUSTER_URL)) {
            String string = sharedPreferences.getString(PREF_CLUSTER_URL, null);
            try {
                this.clusterURL = new URI(string);
                Logger.trace(LOG_TAG, "Set clusterURL from bundle: " + string);
            }
            catch (URISyntaxException uRISyntaxException) {
                Logger.warn(LOG_TAG, "Ignoring bundle clusterURL (" + string + "): invalid URI.", uRISyntaxException);
            }
        }
        if (sharedPreferences.contains(PREF_SYNC_ID)) {
            this.syncID = sharedPreferences.getString(PREF_SYNC_ID, null);
            Logger.trace(LOG_TAG, "Set syncID from bundle: " + this.syncID);
        }
        this.enabledEngineNames = SyncConfiguration.getEnabledEngineNames(sharedPreferences);
        this.declinedEngineNames = SyncConfiguration.getDeclinedEngineNames(sharedPreferences);
        this.userSelectedEngines = SyncConfiguration.getUserSelectedEngines(sharedPreferences);
        this.userSelectedEnginesTimestamp = sharedPreferences.getLong(PREF_USER_SELECTED_ENGINES_TO_SYNC_TIMESTAMP, 0L);
    }

    public void persistToPrefs() {
        this.persistToPrefs(this.getPrefs());
    }

    private static String setToJSONObjectString(Set<String> set) {
        ExtendedJSONObject extendedJSONObject = new ExtendedJSONObject();
        for (String string : set) {
            extendedJSONObject.put(string, 0);
        }
        return extendedJSONObject.toJSONString();
    }

    public void persistToPrefs(SharedPreferences sharedPreferences) {
        SharedPreferences.Editor editor = sharedPreferences.edit();
        if (this.clusterURL == null) {
            editor.remove(PREF_CLUSTER_URL);
        } else {
            editor.putString(PREF_CLUSTER_URL, this.clusterURL.toASCIIString());
        }
        if (this.syncID != null) {
            editor.putString(PREF_SYNC_ID, this.syncID);
        }
        if (this.enabledEngineNames == null) {
            editor.remove(PREF_ENABLED_ENGINE_NAMES);
        } else {
            editor.putString(PREF_ENABLED_ENGINE_NAMES, SyncConfiguration.setToJSONObjectString(this.enabledEngineNames));
        }
        if (this.declinedEngineNames == null || this.declinedEngineNames.isEmpty()) {
            editor.remove(PREF_DECLINED_ENGINE_NAMES);
        } else {
            editor.putString(PREF_DECLINED_ENGINE_NAMES, SyncConfiguration.setToJSONObjectString(this.declinedEngineNames));
        }
        if (this.userSelectedEngines == null) {
            editor.remove(PREF_USER_SELECTED_ENGINES_TO_SYNC);
            editor.remove(PREF_USER_SELECTED_ENGINES_TO_SYNC_TIMESTAMP);
        }
        editor.commit();
    }

    public AuthHeaderProvider getAuthHeaderProvider() {
        return this.authHeaderProvider;
    }

    public CollectionKeys getCollectionKeys() {
        return this.collectionKeys;
    }

    public void setCollectionKeys(CollectionKeys collectionKeys) {
        this.collectionKeys = collectionKeys;
    }

    public String storageURL() {
        return this.clusterURL + "/storage";
    }

    protected String infoBaseURL() {
        return this.clusterURL + "/info/";
    }

    public String infoCollectionsURL() {
        return this.infoBaseURL() + "collections";
    }

    public String infoCollectionCountsURL() {
        return this.infoBaseURL() + "collection_counts";
    }

    public String metaURL() {
        return this.storageURL() + "/meta/global";
    }

    public URI collectionURI(String string) throws URISyntaxException {
        return new URI(this.storageURL() + "/" + string);
    }

    public URI collectionURI(String string, boolean bl) throws URISyntaxException {
        CharSequence charSequence;
        boolean bl2 = bl;
        String string2 = "";
        if (bl2) {
            charSequence = new StringBuilder("?");
            if (bl) {
                charSequence.append("full=1");
            }
            string2 = charSequence.toString();
        }
        charSequence = this.storageURL() + "/" + string + string2;
        return new URI((String)charSequence);
    }

    public URI wboURI(String string, String string2) throws URISyntaxException {
        return new URI(this.storageURL() + "/" + string + "/" + string2);
    }

    public URI keysURI() throws URISyntaxException {
        return this.wboURI("crypto", "keys");
    }

    public URI getClusterURL() {
        return this.clusterURL;
    }

    public String getClusterURLString() {
        if (this.clusterURL == null) {
            return null;
        }
        return this.clusterURL.toASCIIString();
    }

    public void setClusterURL(URI uRI) {
        this.clusterURL = uRI;
    }

    public SharedPreferences.Editor getEditor() {
        return this.getPrefs().edit();
    }

    public void persistServerClientRecordTimestamp(long l) {
        this.getEditor().putLong(CLIENT_RECORD_TIMESTAMP, l).commit();
    }

    public long getPersistedServerClientRecordTimestamp() {
        return this.getPrefs().getLong(CLIENT_RECORD_TIMESTAMP, 0L);
    }

    public void persistServerClientsTimestamp(long l) {
        this.getEditor().putLong(CLIENTS_COLLECTION_TIMESTAMP, l).commit();
    }

    public long getPersistedServerClientsTimestamp() {
        return this.getPrefs().getLong(CLIENTS_COLLECTION_TIMESTAMP, 0L);
    }

    public void persistLastMigrationSentinelCheckTimestamp(long l) {
        this.getEditor().putLong(MIGRATION_SENTINEL_CHECK_TIMESTAMP, l).commit();
    }

    public long getLastMigrationSentinelCheckTimestamp() {
        return this.getPrefs().getLong(MIGRATION_SENTINEL_CHECK_TIMESTAMP, 0L);
    }

    public void purgeCryptoKeys() {
        if (this.collectionKeys != null) {
            this.collectionKeys.clear();
        }
        this.persistedCryptoKeys().purge();
    }

    public void purgeMetaGlobal() {
        this.metaGlobal = null;
        this.persistedMetaGlobal().purge();
    }

    public PersistedCrypto5Keys persistedCryptoKeys() {
        return new PersistedCrypto5Keys(this.getPrefs(), this.syncKeyBundle);
    }

    public PersistedMetaGlobal persistedMetaGlobal() {
        return new PersistedMetaGlobal(this.getPrefs());
    }
}

