/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.sync.repositories.android;

import android.content.ContentProviderClient;
import android.content.ContentValues;
import android.database.Cursor;
import android.net.Uri;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.mozilla.gecko.sync.repositories.android.BrowserContractHelpers;

public class VisitsHelper {
    public static final boolean DEFAULT_IS_LOCAL_VALUE = false;
    public static final String SYNC_TYPE_KEY = "type";
    public static final String SYNC_DATE_KEY = "date";

    public static ContentValues[] getVisitsContentValues(@NonNull String string2, @NonNull JSONArray jSONArray) {
        ContentValues[] contentValuesArray = new ContentValues[jSONArray.size()];
        int n = jSONArray.size();
        if (n == 0) {
            return contentValuesArray;
        }
        for (int i = 0; i < n; ++i) {
            contentValuesArray[i] = VisitsHelper.getVisitContentValues(string2, (JSONObject)jSONArray.get(i), false);
        }
        return contentValuesArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JSONArray getRecentHistoryVisitsForGUID(@NonNull ContentProviderClient contentProviderClient, @NonNull String string2, int n) throws RemoteException {
        JSONArray jSONArray = new JSONArray();
        Cursor cursor = contentProviderClient.query(VisitsHelper.visitsUriWithLimit(n), new String[]{"visit_type", SYNC_DATE_KEY}, "history_guid = ?", new String[]{string2}, null);
        if (cursor == null) {
            return jSONArray;
        }
        try {
            if (!cursor.moveToFirst()) {
                JSONArray jSONArray2 = jSONArray;
                return jSONArray2;
            }
            int n2 = cursor.getColumnIndexOrThrow(SYNC_DATE_KEY);
            int n3 = cursor.getColumnIndexOrThrow("visit_type");
            while (!cursor.isAfterLast()) {
                VisitsHelper.insertTupleIntoVisitsUnchecked(jSONArray, cursor.getInt(n3), cursor.getLong(n2));
                cursor.moveToNext();
            }
        }
        finally {
            cursor.close();
        }
        return jSONArray;
    }

    public static ContentValues getVisitContentValues(@NonNull String string2, @NonNull JSONObject jSONObject, boolean bl) {
        if (!jSONObject.containsKey((Object)SYNC_DATE_KEY) || !jSONObject.containsKey((Object)SYNC_TYPE_KEY)) {
            throw new IllegalArgumentException("Visit missing required keys");
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("history_guid", string2);
        contentValues.put("is_local", Integer.valueOf(bl ? 1 : 0));
        contentValues.put("visit_type", (Long)jSONObject.get((Object)SYNC_TYPE_KEY));
        contentValues.put(SYNC_DATE_KEY, (Long)jSONObject.get((Object)SYNC_DATE_KEY));
        return contentValues;
    }

    private static void insertTupleIntoVisitsUnchecked(JSONArray jSONArray, Integer n, Long l) {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put((Object)SYNC_TYPE_KEY, (Object)n);
        jSONObject.put((Object)SYNC_DATE_KEY, (Object)l);
        jSONArray.add((Object)jSONObject);
    }

    private static Uri visitsUriWithLimit(int n) {
        return BrowserContractHelpers.VISITS_CONTENT_URI.buildUpon().appendQueryParameter("limit", Integer.toString(n)).build();
    }
}

