/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.util;

import android.util.Log;
import java.util.concurrent.atomic.AtomicInteger;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.gecko.annotation.RobocopTarget;
import org.mozilla.gecko.util.NativeJSObject;

public abstract class GeckoRequest {
    private static final String LOGTAG = "GeckoRequest";
    private static final AtomicInteger currentId = new AtomicInteger(0);
    private final int id = currentId.getAndIncrement();
    private final String name;
    private final String data;

    @RobocopTarget
    public GeckoRequest(String string, Object object) {
        this.name = string;
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("id", this.id);
            jSONObject.put("data", object);
        }
        catch (JSONException jSONException) {
            Log.e((String)LOGTAG, (String)"JSON error", (Throwable)jSONException);
        }
        this.data = jSONObject.toString();
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getData() {
        return this.data;
    }

    @RobocopTarget
    public abstract void onResponse(NativeJSObject var1);

    @RobocopTarget
    public void onError(NativeJSObject nativeJSObject) {
        String string = nativeJSObject.optString("message", "<no message>");
        String string2 = nativeJSObject.optString("stack", "<no stack>");
        throw new RuntimeException("Unhandled error for GeckoRequest " + this.name + ": " + string + "\nJS stack:\n" + string2);
    }
}

