/*
 * Decompiled with CFR 0.152.
 */
package ch.boye.httpclientandroidlib.impl.entity;

import ch.boye.httpclientandroidlib.Header;
import ch.boye.httpclientandroidlib.HeaderElement;
import ch.boye.httpclientandroidlib.HttpException;
import ch.boye.httpclientandroidlib.HttpMessage;
import ch.boye.httpclientandroidlib.ParseException;
import ch.boye.httpclientandroidlib.ProtocolException;
import ch.boye.httpclientandroidlib.annotation.Immutable;
import ch.boye.httpclientandroidlib.entity.ContentLengthStrategy;
import ch.boye.httpclientandroidlib.util.Args;

@Immutable
public class LaxContentLengthStrategy
implements ContentLengthStrategy {
    public static final LaxContentLengthStrategy INSTANCE = new LaxContentLengthStrategy();
    private final int implicitLen;

    public LaxContentLengthStrategy(int n) {
        this.implicitLen = n;
    }

    public LaxContentLengthStrategy() {
        this(-1);
    }

    @Override
    public long determineLength(HttpMessage httpMessage) throws HttpException {
        Args.notNull(httpMessage, "HTTP message");
        Header header = httpMessage.getFirstHeader("Transfer-Encoding");
        if (header != null) {
            HeaderElement[] headerElementArray;
            try {
                headerElementArray = header.getElements();
            }
            catch (ParseException parseException) {
                throw new ProtocolException("Invalid Transfer-Encoding header value: " + header, parseException);
            }
            int n = headerElementArray.length;
            if ("identity".equalsIgnoreCase(header.getValue())) {
                return -1L;
            }
            if (n > 0 && "chunked".equalsIgnoreCase(headerElementArray[n - 1].getName())) {
                return -2L;
            }
            return -1L;
        }
        Header header2 = httpMessage.getFirstHeader("Content-Length");
        if (header2 != null) {
            long l = -1L;
            Header[] headerArray = httpMessage.getHeaders("Content-Length");
            for (int i = headerArray.length - 1; i >= 0; --i) {
                Header header3 = headerArray[i];
                try {
                    l = Long.parseLong(header3.getValue());
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                    continue;
                }
            }
            if (l >= 0L) {
                return l;
            }
            return -1L;
        }
        return this.implicitLen;
    }
}

