/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.ActivityManager;
import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.PixelFormat;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.SurfaceTexture;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.hardware.Camera;
import android.hardware.Sensor;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.location.Criteria;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.os.Bundle;
import android.os.Environment;
import android.os.Looper;
import android.os.Process;
import android.os.Vibrator;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.Log;
import android.view.ContextThemeWrapper;
import android.view.Display;
import android.view.Surface;
import android.view.SurfaceView;
import android.view.TextureView;
import android.view.View;
import android.view.WindowManager;
import android.webkit.MimeTypeMap;
import android.widget.AbsoluteLayout;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URLConnection;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import org.mozilla.gecko.AlarmReceiver;
import org.mozilla.gecko.AndroidGamepadManager;
import org.mozilla.gecko.AppConstants;
import org.mozilla.gecko.ContextGetter;
import org.mozilla.gecko.CrashHandler;
import org.mozilla.gecko.EventDispatcher;
import org.mozilla.gecko.FormAssistPopup;
import org.mozilla.gecko.GeckoBatteryManager;
import org.mozilla.gecko.GeckoEvent;
import org.mozilla.gecko.GeckoNetworkManager;
import org.mozilla.gecko.GeckoProfile;
import org.mozilla.gecko.GeckoScreenOrientation;
import org.mozilla.gecko.GeckoThread;
import org.mozilla.gecko.GeckoView;
import org.mozilla.gecko.NotificationClient;
import org.mozilla.gecko.SmsManager;
import org.mozilla.gecko.SurfaceBits;
import org.mozilla.gecko.annotation.JNITarget;
import org.mozilla.gecko.annotation.RobocopTarget;
import org.mozilla.gecko.annotation.WrapForJNI;
import org.mozilla.gecko.gfx.BitmapUtils;
import org.mozilla.gecko.gfx.LayerView;
import org.mozilla.gecko.gfx.PanZoomController;
import org.mozilla.gecko.permissions.Permissions;
import org.mozilla.gecko.util.EventCallback;
import org.mozilla.gecko.util.GeckoRequest;
import org.mozilla.gecko.util.HardwareCodecCapabilityUtils;
import org.mozilla.gecko.util.HardwareUtils;
import org.mozilla.gecko.util.NativeEventListener;
import org.mozilla.gecko.util.NativeJSContainer;
import org.mozilla.gecko.util.NativeJSObject;
import org.mozilla.gecko.util.ProxySelector;
import org.mozilla.gecko.util.ThreadUtils;

public class GeckoAppShell {
    private static final String LOGTAG = "GeckoAppShell";
    private static final CrashHandler CRASH_HANDLER = new CrashHandler(){

        @Override
        protected String getAppPackageName() {
            return "org.mozilla.fennec";
        }

        @Override
        protected Context getAppContext() {
            return sContextGetter != null ? GeckoAppShell.getApplicationContext() : null;
        }

        @Override
        protected Bundle getCrashExtras(Thread thread, Throwable throwable) {
            Bundle bundle = super.getCrashExtras(thread, throwable);
            bundle.putString("ProductName", "Fennec");
            bundle.putString("ProductID", "{aa3c5121-dab2-40e2-81ca-7ea25febc110}");
            bundle.putString("Version", "50.0a1");
            bundle.putString("BuildID", "20160610030239");
            bundle.putString("Vendor", "Mozilla");
            bundle.putString("ReleaseChannel", "nightly");
            return bundle;
        }

        @Override
        public void uncaughtException(Thread thread, Throwable throwable) {
            if (GeckoThread.isStateAtLeast(GeckoThread.State.EXITING)) {
                return;
            }
            super.uncaughtException(thread, throwable);
        }

        @Override
        public boolean reportException(Thread thread, Throwable throwable) {
            try {
                if (throwable instanceof OutOfMemoryError) {
                    SharedPreferences sharedPreferences = GeckoAppShell.getSharedPreferences();
                    SharedPreferences.Editor editor = sharedPreferences.edit();
                    editor.putBoolean("OOMException", true);
                    editor.commit();
                }
                GeckoAppShell.reportJavaCrash(1.getExceptionStackTrace(throwable));
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
            return super.reportException(thread, throwable);
        }
    };
    private static final Map<String, String> ALERT_COOKIES = new ConcurrentHashMap<String, String>();
    private static volatile boolean locationHighAccuracyEnabled;
    static NotificationClient notificationClient;
    private static final int HIGH_MEMORY_DEVICE_THRESHOLD_MB = 768;
    private static int sDensityDpi;
    private static int sScreenDepth;
    private static boolean sVibrationMaybePlaying;
    private static long sVibrationEndTime;
    private static Sensor gAccelerometerSensor;
    private static Sensor gLinearAccelerometerSensor;
    private static Sensor gGyroscopeSensor;
    private static Sensor gOrientationSensor;
    private static Sensor gProximitySensor;
    private static Sensor gLightSensor;
    private static Sensor gRotationVectorSensor;
    private static Sensor gGameRotationVectorSensor;
    private static final String GECKOREQUEST_RESPONSE_KEY = "response";
    private static final String GECKOREQUEST_ERROR_KEY = "error";
    public static final int WPL_STATE_START = 1;
    public static final int WPL_STATE_STOP = 16;
    public static final int WPL_STATE_IS_DOCUMENT = 131072;
    public static final int WPL_STATE_IS_NETWORK = 262144;
    public static final int LINK_TYPE_UNKNOWN = 0;
    public static final int LINK_TYPE_ETHERNET = 1;
    public static final int LINK_TYPE_USB = 2;
    public static final int LINK_TYPE_WIFI = 3;
    public static final int LINK_TYPE_WIMAX = 4;
    public static final int LINK_TYPE_2G = 5;
    public static final int LINK_TYPE_3G = 6;
    public static final int LINK_TYPE_4G = 7;
    private static LayerView sLayerView;
    private static Rect sScreenSize;
    private static final Runnable sCallbackRunnable;
    public static final String PLUGIN_ACTION = "android.webkit.PLUGIN";
    public static final String PLUGIN_PERMISSION = "android.webkit.permission.PLUGIN";
    private static final String PLUGIN_SYSTEM_LIB = "/system/lib/plugins/";
    private static final String PLUGIN_TYPE = "type";
    private static final String TYPE_NATIVE = "native";
    public static final ArrayList<PackageInfo> mPackageInfoCache;
    private static Context sApplicationContext;
    private static ContextGetter sContextGetter;
    private static GeckoInterface sGeckoInterface;
    public static Camera sCamera;
    static final int kPreferredFPS = 25;
    static byte[] sCameraBuffer;
    private static boolean sImeWasEnabledOnLastResize;

    private GeckoAppShell() {
    }

    public static CrashHandler ensureCrashHandling() {
        return CRASH_HANDLER;
    }

    public static native void registerJavaUiThread();

    public static void callObserver(String string2, String string3, String string4) {
        GeckoAppShell.sendEventToGecko(GeckoEvent.createCallObserverEvent(string2, string3, string4));
    }

    public static void removeObserver(String string2) {
        GeckoAppShell.sendEventToGecko(GeckoEvent.createRemoveObserverEvent(string2));
    }

    public static native void onSurfaceTextureFrameAvailable(Object var0, int var1);

    public static native void dispatchMemoryPressure();

    private static native void reportJavaCrash(String var0);

    public static void notifyUriVisited(String string2) {
        GeckoAppShell.sendEventToGecko(GeckoEvent.createVisitedEvent(string2));
    }

    public static native void notifyBatteryChange(double var0, boolean var2, double var3);

    public static native void invalidateAndScheduleComposite();

    public static native float computeRenderIntegrity();

    public static native SurfaceBits getSurfaceBits(Surface var0);

    public static native void addPresentationSurface(Surface var0);

    public static native void removePresentationSurface(Surface var0);

    public static native void onFullScreenPluginHidden(View var0);

    public static void setLayerView(LayerView layerView) {
        if (sLayerView == layerView) {
            return;
        }
        sLayerView = layerView;
    }

    @RobocopTarget
    public static LayerView getLayerView() {
        return sLayerView;
    }

    @RobocopTarget
    public static void sendEventToGecko(GeckoEvent geckoEvent) {
        if (geckoEvent == null) {
            throw new IllegalArgumentException("e cannot be null.");
        }
        if (GeckoThread.isRunning()) {
            GeckoAppShell.notifyGeckoOfEvent(geckoEvent);
            geckoEvent.recycle();
            return;
        }
        GeckoThread.addPendingEvent(geckoEvent);
    }

    @RobocopTarget
    public static void sendRequestToGecko(final GeckoRequest geckoRequest) {
        String string2 = "Gecko:Request" + geckoRequest.getId();
        EventDispatcher.getInstance().registerGeckoThreadListener(new NativeEventListener(){

            public void handleMessage(String string2, NativeJSObject nativeJSObject, EventCallback eventCallback) {
                EventDispatcher.getInstance().unregisterGeckoThreadListener(this, string2);
                if (!nativeJSObject.has(GeckoAppShell.GECKOREQUEST_RESPONSE_KEY)) {
                    geckoRequest.onError(nativeJSObject.getObject(GeckoAppShell.GECKOREQUEST_ERROR_KEY));
                    return;
                }
                geckoRequest.onResponse(nativeJSObject.getObject(GeckoAppShell.GECKOREQUEST_RESPONSE_KEY));
            }
        }, string2);
        GeckoAppShell.notifyObservers(geckoRequest.getName(), geckoRequest.getData());
    }

    public static native void notifyGeckoOfEvent(GeckoEvent var0);

    @WrapForJNI
    public static native void syncNotifyObservers(String var0, String var1);

    @WrapForJNI(stubName="NotifyObservers")
    private static native void nativeNotifyObservers(String var0, String var1);

    @RobocopTarget
    public static void notifyObservers(String string2, String string3) {
        GeckoAppShell.notifyObservers(string2, string3, GeckoThread.State.RUNNING);
    }

    public static void notifyObservers(String string2, String string3, GeckoThread.State state) {
        if (GeckoThread.isStateAtLeast(state)) {
            GeckoAppShell.nativeNotifyObservers(string2, string3);
        } else {
            GeckoThread.queueNativeCallUntil(state, GeckoAppShell.class, "nativeNotifyObservers", String.class, string2, String.class, string3);
        }
    }

    @WrapForJNI(allowMultithread=true, noThrow=true)
    public static String handleUncaughtException(Throwable throwable) {
        Throwable throwable2 = CrashHandler.getRootException(throwable);
        StackTraceElement[] stackTraceElementArray = throwable2.getStackTrace();
        if (stackTraceElementArray.length >= 1 && stackTraceElementArray[0].isNativeMethod()) {
            CrashHandler.logException(Thread.currentThread(), throwable2);
            return CrashHandler.getExceptionStackTrace(throwable2);
        }
        CRASH_HANDLER.uncaughtException(null, throwable);
        return null;
    }

    private static native long runUiThreadCallback();

    @WrapForJNI(allowMultithread=true)
    private static void requestUiThreadCallback(long l) {
        ThreadUtils.getUiHandler().postDelayed(sCallbackRunnable, l);
    }

    private static float getLocationAccuracy(Location location) {
        float f = location.getAccuracy();
        return location.hasAccuracy() && f > 0.0f ? f : 1001.0f;
    }

    @SuppressLint(value={"MissingPermission"})
    private static Location getLastKnownLocation(LocationManager locationManager) {
        Location location = null;
        List list = locationManager.getAllProviders();
        for (String string2 : list) {
            Location location2 = locationManager.getLastKnownLocation(string2);
            if (location2 == null) continue;
            if (location == null) {
                location = location2;
                continue;
            }
            long l = location2.getTime() - location.getTime();
            if (l <= 0L && (l != 0L || !(GeckoAppShell.getLocationAccuracy(location2) < GeckoAppShell.getLocationAccuracy(location)))) continue;
            location = location2;
        }
        return location;
    }

    @WrapForJNI
    @SuppressLint(value={"MissingPermission"})
    public static void enableLocation(final boolean bl) {
        Permissions.from((Context)((Activity)GeckoAppShell.getContext())).withPermissions("android.permission.ACCESS_FINE_LOCATION").onUIThread().doNotPromptIf(!bl).run(new Runnable(){

            @Override
            public void run() {
                LocationManager locationManager = GeckoAppShell.getLocationManager(GeckoAppShell.getApplicationContext());
                if (locationManager == null) {
                    return;
                }
                if (bl) {
                    Location location = GeckoAppShell.getLastKnownLocation(locationManager);
                    if (location != null) {
                        GeckoAppShell.getGeckoInterface().getLocationListener().onLocationChanged(location);
                    }
                    Criteria criteria = new Criteria();
                    criteria.setSpeedRequired(false);
                    criteria.setBearingRequired(false);
                    criteria.setAltitudeRequired(false);
                    if (locationHighAccuracyEnabled) {
                        criteria.setAccuracy(1);
                        criteria.setCostAllowed(true);
                        criteria.setPowerRequirement(3);
                    } else {
                        criteria.setAccuracy(2);
                        criteria.setCostAllowed(false);
                        criteria.setPowerRequirement(1);
                    }
                    String string2 = locationManager.getBestProvider(criteria, true);
                    if (string2 == null) {
                        return;
                    }
                    Looper looper = Looper.getMainLooper();
                    locationManager.requestLocationUpdates(string2, 100L, 0.5f, GeckoAppShell.getGeckoInterface().getLocationListener(), looper);
                } else {
                    locationManager.removeUpdates(GeckoAppShell.getGeckoInterface().getLocationListener());
                }
            }
        });
    }

    private static LocationManager getLocationManager(Context context) {
        try {
            return (LocationManager)context.getSystemService("location");
        }
        catch (NoSuchFieldError noSuchFieldError) {
            Log.e((String)LOGTAG, (String)"LOCATION_SERVICE not found?!", (Throwable)noSuchFieldError);
            return null;
        }
    }

    @WrapForJNI
    public static void enableLocationHighAccuracy(boolean bl) {
        locationHighAccuracyEnabled = bl;
    }

    @WrapForJNI
    public static boolean setAlarm(int n, int n2) {
        AlarmManager alarmManager = (AlarmManager)GeckoAppShell.getApplicationContext().getSystemService("alarm");
        Intent intent = new Intent(GeckoAppShell.getApplicationContext(), AlarmReceiver.class);
        PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)GeckoAppShell.getApplicationContext(), (int)0, (Intent)intent, (int)0x8000000);
        long l = (long)n * 1000L + (long)n2 / 1000000L;
        alarmManager.setExact(0, l, pendingIntent);
        return true;
    }

    @WrapForJNI
    public static void disableAlarm() {
        AlarmManager alarmManager = (AlarmManager)GeckoAppShell.getApplicationContext().getSystemService("alarm");
        Intent intent = new Intent(GeckoAppShell.getApplicationContext(), AlarmReceiver.class);
        PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)GeckoAppShell.getApplicationContext(), (int)0, (Intent)intent, (int)0x8000000);
        alarmManager.cancel(pendingIntent);
    }

    @WrapForJNI
    public static void enableSensor(int n) {
        GeckoInterface geckoInterface = GeckoAppShell.getGeckoInterface();
        if (geckoInterface == null) {
            return;
        }
        SensorManager sensorManager = (SensorManager)GeckoAppShell.getApplicationContext().getSystemService("sensor");
        switch (n) {
            case 7: {
                if (gGameRotationVectorSensor == null) {
                    gGameRotationVectorSensor = sensorManager.getDefaultSensor(15);
                }
                if (gGameRotationVectorSensor != null) {
                    sensorManager.registerListener(geckoInterface.getSensorEventListener(), gGameRotationVectorSensor, 0);
                }
                if (gGameRotationVectorSensor != null) break;
            }
            case 6: {
                if (gRotationVectorSensor == null) {
                    gRotationVectorSensor = sensorManager.getDefaultSensor(11);
                }
                if (gRotationVectorSensor != null) {
                    sensorManager.registerListener(geckoInterface.getSensorEventListener(), gRotationVectorSensor, 0);
                }
                if (gRotationVectorSensor != null) break;
            }
            case 0: {
                if (gOrientationSensor == null) {
                    gOrientationSensor = sensorManager.getDefaultSensor(3);
                }
                if (gOrientationSensor == null) break;
                sensorManager.registerListener(geckoInterface.getSensorEventListener(), gOrientationSensor, 0);
                break;
            }
            case 1: {
                if (gAccelerometerSensor == null) {
                    gAccelerometerSensor = sensorManager.getDefaultSensor(1);
                }
                if (gAccelerometerSensor == null) break;
                sensorManager.registerListener(geckoInterface.getSensorEventListener(), gAccelerometerSensor, 0);
                break;
            }
            case 2: {
                if (gProximitySensor == null) {
                    gProximitySensor = sensorManager.getDefaultSensor(8);
                }
                if (gProximitySensor == null) break;
                sensorManager.registerListener(geckoInterface.getSensorEventListener(), gProximitySensor, 3);
                break;
            }
            case 5: {
                if (gLightSensor == null) {
                    gLightSensor = sensorManager.getDefaultSensor(5);
                }
                if (gLightSensor == null) break;
                sensorManager.registerListener(geckoInterface.getSensorEventListener(), gLightSensor, 3);
                break;
            }
            case 3: {
                if (gLinearAccelerometerSensor == null) {
                    gLinearAccelerometerSensor = sensorManager.getDefaultSensor(10);
                }
                if (gLinearAccelerometerSensor == null) break;
                sensorManager.registerListener(geckoInterface.getSensorEventListener(), gLinearAccelerometerSensor, 0);
                break;
            }
            case 4: {
                if (gGyroscopeSensor == null) {
                    gGyroscopeSensor = sensorManager.getDefaultSensor(4);
                }
                if (gGyroscopeSensor == null) break;
                sensorManager.registerListener(geckoInterface.getSensorEventListener(), gGyroscopeSensor, 0);
                break;
            }
            default: {
                Log.w((String)LOGTAG, (String)("Error! Can't enable unknown SENSOR type " + n));
            }
        }
    }

    @WrapForJNI
    public static void disableSensor(int n) {
        GeckoInterface geckoInterface = GeckoAppShell.getGeckoInterface();
        if (geckoInterface == null) {
            return;
        }
        SensorManager sensorManager = (SensorManager)GeckoAppShell.getApplicationContext().getSystemService("sensor");
        switch (n) {
            case 7: {
                if (gGameRotationVectorSensor != null) {
                    sensorManager.unregisterListener(geckoInterface.getSensorEventListener(), gGameRotationVectorSensor);
                    break;
                }
            }
            case 6: {
                if (gRotationVectorSensor != null) {
                    sensorManager.unregisterListener(geckoInterface.getSensorEventListener(), gRotationVectorSensor);
                    break;
                }
            }
            case 0: {
                if (gOrientationSensor == null) break;
                sensorManager.unregisterListener(geckoInterface.getSensorEventListener(), gOrientationSensor);
                break;
            }
            case 1: {
                if (gAccelerometerSensor == null) break;
                sensorManager.unregisterListener(geckoInterface.getSensorEventListener(), gAccelerometerSensor);
                break;
            }
            case 2: {
                if (gProximitySensor == null) break;
                sensorManager.unregisterListener(geckoInterface.getSensorEventListener(), gProximitySensor);
                break;
            }
            case 5: {
                if (gLightSensor == null) break;
                sensorManager.unregisterListener(geckoInterface.getSensorEventListener(), gLightSensor);
                break;
            }
            case 3: {
                if (gLinearAccelerometerSensor == null) break;
                sensorManager.unregisterListener(geckoInterface.getSensorEventListener(), gLinearAccelerometerSensor);
                break;
            }
            case 4: {
                if (gGyroscopeSensor == null) break;
                sensorManager.unregisterListener(geckoInterface.getSensorEventListener(), gGyroscopeSensor);
                break;
            }
            default: {
                Log.w((String)LOGTAG, (String)("Error! Can't disable unknown SENSOR type " + n));
            }
        }
    }

    @WrapForJNI
    public static void startMonitoringGamepad() {
        ThreadUtils.postToUiThread((Runnable)new Runnable(){

            @Override
            public void run() {
                AndroidGamepadManager.startup();
            }
        });
    }

    @WrapForJNI
    public static void stopMonitoringGamepad() {
        ThreadUtils.postToUiThread((Runnable)new Runnable(){

            @Override
            public void run() {
                AndroidGamepadManager.shutdown();
            }
        });
    }

    @WrapForJNI
    public static void gamepadAdded(final int n, final int n2) {
        ThreadUtils.postToUiThread((Runnable)new Runnable(){

            @Override
            public void run() {
                AndroidGamepadManager.gamepadAdded(n, n2);
            }
        });
    }

    @WrapForJNI
    public static void moveTaskToBack() {
        if (GeckoAppShell.getGeckoInterface() != null) {
            GeckoAppShell.getGeckoInterface().getActivity().moveTaskToBack(true);
        }
    }

    @WrapForJNI
    static void scheduleRestart() {
        GeckoAppShell.getGeckoInterface().doRestart();
    }

    @WrapForJNI
    public static void createShortcut(String string2, String string3) {
        GeckoInterface geckoInterface = GeckoAppShell.getGeckoInterface();
        if (geckoInterface == null) {
            return;
        }
        geckoInterface.createShortcut(string2, string3);
    }

    @JNITarget
    public static int getPreferredIconSize() {
        if (AppConstants.Versions.feature11Plus) {
            ActivityManager activityManager = (ActivityManager)GeckoAppShell.getApplicationContext().getSystemService("activity");
            return activityManager.getLauncherLargeIconSize();
        }
        switch (GeckoAppShell.getDpi()) {
            case 160: {
                return 48;
            }
            case 320: {
                return 96;
            }
        }
        return 72;
    }

    @WrapForJNI(stubName="GetHandlersForMimeTypeWrapper")
    static String[] getHandlersForMimeType(String string2, String string3) {
        GeckoInterface geckoInterface = GeckoAppShell.getGeckoInterface();
        if (geckoInterface == null) {
            return new String[0];
        }
        return geckoInterface.getHandlersForMimeType(string2, string3);
    }

    @WrapForJNI(stubName="GetHandlersForURLWrapper")
    static String[] getHandlersForURL(String string2, String string3) {
        GeckoInterface geckoInterface = GeckoAppShell.getGeckoInterface();
        if (geckoInterface == null) {
            return new String[0];
        }
        return geckoInterface.getHandlersForURL(string2, string3);
    }

    @WrapForJNI(stubName="GetHWEncoderCapability")
    static boolean getHWEncoderCapability() {
        return HardwareCodecCapabilityUtils.getHWEncoderCapability();
    }

    @WrapForJNI(stubName="GetHWDecoderCapability")
    static boolean getHWDecoderCapability() {
        return HardwareCodecCapabilityUtils.getHWDecoderCapability();
    }

    static List<ResolveInfo> queryIntentActivities(Intent intent) {
        PackageManager packageManager = GeckoAppShell.getApplicationContext().getPackageManager();
        ArrayList<ResolveInfo> arrayList = new ArrayList<ResolveInfo>();
        for (ResolveInfo resolveInfo : packageManager.queryIntentActivities(intent, 0)) {
            if (!resolveInfo.activityInfo.exported) continue;
            arrayList.add(resolveInfo);
        }
        return arrayList;
    }

    @WrapForJNI(stubName="GetExtensionFromMimeTypeWrapper")
    static String getExtensionFromMimeType(String string2) {
        return MimeTypeMap.getSingleton().getExtensionFromMimeType(string2);
    }

    @WrapForJNI(stubName="GetMimeTypeFromExtensionsWrapper")
    static String getMimeTypeFromExtensions(String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ".,; ");
        String string3 = null;
        String string4 = null;
        while (stringTokenizer.hasMoreElements()) {
            String string5;
            String string6 = stringTokenizer.nextToken();
            String string7 = GeckoAppShell.getMimeTypeFromExtension(string6);
            if (string7 == null) continue;
            int n = string7.indexOf(47);
            String string8 = string7.substring(0, n);
            if (!string8.equalsIgnoreCase(string3)) {
                String string9 = string3 = string3 == null ? string8 : "*";
            }
            if ((string5 = string7.substring(n + 1)).equalsIgnoreCase(string4)) continue;
            string4 = string4 == null ? string5 : "*";
        }
        if (string3 == null) {
            string3 = "*";
        }
        if (string4 == null) {
            string4 = "*";
        }
        return string3 + "/" + string4;
    }

    static boolean isUriSafeForScheme(Uri uri) {
        String string2;
        String string3 = uri.getScheme();
        return !"tel".equals(string3) && !"sms".equals(string3) || !(string2 = uri.getSchemeSpecificPart()).contains("#") && !string2.contains("*") && uri.getFragment() == null;
    }

    @WrapForJNI
    public static boolean openUriExternal(String string2, String string3, String string4, String string5, String string6, String string7) {
        GeckoInterface geckoInterface = GeckoAppShell.getGeckoInterface();
        if (geckoInterface == null) {
            return false;
        }
        return geckoInterface.openUriExternal(string2, string3, string4, string5, string6, string7);
    }

    public static void setNotificationClient(NotificationClient notificationClient) {
        if (GeckoAppShell.notificationClient == null) {
            GeckoAppShell.notificationClient = notificationClient;
        } else {
            Log.d((String)LOGTAG, (String)"Notification client already set");
        }
    }

    @WrapForJNI(stubName="ShowAlertNotificationWrapper")
    public static void showAlertNotification(String string2, String string3, String string4, String string5, String string6, String string7) {
        Intent intent = new Intent("org.mozilla.gecko.ACTION_ALERT_CALLBACK");
        intent.setClassName("org.mozilla.fennec", "org.mozilla.gecko.BrowserApp");
        intent.setFlags(0x10000000);
        int n = string6.hashCode();
        Uri.Builder builder = new Uri.Builder();
        Uri uri = builder.scheme("alert").path(Integer.toString(n)).appendQueryParameter("name", string6).appendQueryParameter("cookie", string5).build();
        intent.setData(uri);
        PendingIntent pendingIntent = PendingIntent.getActivity((Context)GeckoAppShell.getApplicationContext(), (int)0, (Intent)intent, (int)0x8000000);
        ALERT_COOKIES.put(string6, string5);
        GeckoAppShell.callObserver(string6, "alertshow", string5);
        notificationClient.add(n, string2, string7, string3, string4, pendingIntent);
    }

    @WrapForJNI
    public static void alertsProgressListener_OnProgress(String string2, long l, long l2, String string3) {
        int n = string2.hashCode();
        notificationClient.update(n, l, l2, string3);
    }

    @WrapForJNI
    public static void closeNotification(String string2) {
        String string3 = ALERT_COOKIES.get(string2);
        if (string3 != null) {
            GeckoAppShell.callObserver(string2, "alertfinished", string3);
            ALERT_COOKIES.remove(string2);
        }
        GeckoAppShell.removeObserver(string2);
        int n = string2.hashCode();
        notificationClient.remove(n);
    }

    public static void handleNotification(String string2, String string3, String string4) {
        int n = string3.hashCode();
        if ("org.mozilla.gecko.ACTION_ALERT_CALLBACK".equals(string2)) {
            GeckoAppShell.callObserver(string3, "alertclickcallback", string4);
            if (notificationClient.isOngoing(n)) {
                return;
            }
        }
        GeckoAppShell.closeNotification(string3);
    }

    @WrapForJNI(stubName="GetDpiWrapper")
    public static int getDpi() {
        if (sDensityDpi == 0) {
            sDensityDpi = GeckoAppShell.getApplicationContext().getResources().getDisplayMetrics().densityDpi;
        }
        return sDensityDpi;
    }

    @WrapForJNI
    public static float getDensity() {
        return GeckoAppShell.getApplicationContext().getResources().getDisplayMetrics().density;
    }

    private static boolean isHighMemoryDevice() {
        return HardwareUtils.getMemSize() > 768;
    }

    @WrapForJNI(stubName="GetScreenDepthWrapper")
    public static synchronized int getScreenDepth() {
        if (sScreenDepth == 0) {
            sScreenDepth = 16;
            PixelFormat pixelFormat = new PixelFormat();
            WindowManager windowManager = (WindowManager)GeckoAppShell.getApplicationContext().getSystemService("window");
            PixelFormat.getPixelFormatInfo((int)windowManager.getDefaultDisplay().getPixelFormat(), (PixelFormat)pixelFormat);
            if (pixelFormat.bitsPerPixel >= 24 && GeckoAppShell.isHighMemoryDevice()) {
                sScreenDepth = 24;
            }
        }
        return sScreenDepth;
    }

    @WrapForJNI
    public static synchronized void setScreenDepthOverride(int n) {
        if (sScreenDepth != 0) {
            Log.e((String)LOGTAG, (String)"Tried to override screen depth after it's already been set");
            return;
        }
        sScreenDepth = n;
    }

    @WrapForJNI
    public static void setFullScreen(boolean bl) {
        if (GeckoAppShell.getGeckoInterface() != null) {
            GeckoAppShell.getGeckoInterface().setFullScreen(bl);
        }
    }

    @WrapForJNI
    public static void performHapticFeedback(boolean bl) {
        if (!sVibrationMaybePlaying || System.nanoTime() >= sVibrationEndTime) {
            LayerView layerView = GeckoAppShell.getLayerView();
            layerView.performHapticFeedback(bl ? 0 : 1);
        }
    }

    private static Vibrator vibrator() {
        return (Vibrator)GeckoAppShell.getApplicationContext().getSystemService("vibrator");
    }

    private static long[] convertIntToLongArray(int[] nArray) {
        long[] lArray = new long[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            lArray[i] = nArray[i];
        }
        return lArray;
    }

    public static void vibrateOnHapticFeedbackEnabled(int[] nArray) {
        if (Settings.System.getInt((ContentResolver)GeckoAppShell.getApplicationContext().getContentResolver(), (String)"haptic_feedback_enabled", (int)0) > 0) {
            GeckoAppShell.vibrate(GeckoAppShell.convertIntToLongArray(nArray), -1);
        }
    }

    @WrapForJNI(stubName="Vibrate1")
    public static void vibrate(long l) {
        sVibrationEndTime = System.nanoTime() + l * 1000000L;
        sVibrationMaybePlaying = true;
        GeckoAppShell.vibrator().vibrate(l);
    }

    @WrapForJNI(stubName="VibrateA")
    public static void vibrate(long[] lArray, int n) {
        long l = 0L;
        int n2 = lArray.length - (lArray.length % 2 == 0 ? 1 : 0);
        for (int i = 0; i < n2; ++i) {
            l += lArray[i];
        }
        sVibrationEndTime = System.nanoTime() + l * 1000000L;
        sVibrationMaybePlaying = true;
        GeckoAppShell.vibrator().vibrate(lArray, n);
    }

    @WrapForJNI
    public static void cancelVibrate() {
        sVibrationMaybePlaying = false;
        sVibrationEndTime = 0L;
        GeckoAppShell.vibrator().cancel();
    }

    @WrapForJNI
    public static void setKeepScreenOn(boolean bl) {
        ThreadUtils.postToUiThread((Runnable)new Runnable(){

            @Override
            public void run() {
            }
        });
    }

    @WrapForJNI
    public static void notifyDefaultPrevented(final boolean bl) {
        ThreadUtils.postToUiThread((Runnable)new Runnable(){

            @Override
            public void run() {
                PanZoomController panZoomController;
                LayerView layerView = GeckoAppShell.getLayerView();
                PanZoomController panZoomController2 = panZoomController = layerView == null ? null : layerView.getPanZoomController();
                if (panZoomController != null) {
                    panZoomController.notifyDefaultActionPrevented(bl);
                }
            }
        });
    }

    @WrapForJNI
    public static boolean isNetworkLinkUp() {
        ConnectivityManager connectivityManager = (ConnectivityManager)GeckoAppShell.getApplicationContext().getSystemService("connectivity");
        try {
            NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
            if (networkInfo == null || !networkInfo.isConnected()) {
                return false;
            }
        }
        catch (SecurityException securityException) {
            return false;
        }
        return true;
    }

    @WrapForJNI
    public static boolean isNetworkLinkKnown() {
        ConnectivityManager connectivityManager = (ConnectivityManager)GeckoAppShell.getApplicationContext().getSystemService("connectivity");
        try {
            if (connectivityManager.getActiveNetworkInfo() == null) {
                return false;
            }
        }
        catch (SecurityException securityException) {
            return false;
        }
        return true;
    }

    @WrapForJNI
    public static int networkLinkType() {
        ConnectivityManager connectivityManager = (ConnectivityManager)GeckoAppShell.getApplicationContext().getSystemService("connectivity");
        NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
        if (networkInfo == null) {
            return 0;
        }
        switch (networkInfo.getType()) {
            case 9: {
                return 1;
            }
            case 1: {
                return 3;
            }
            case 6: {
                return 4;
            }
            case 0: {
                break;
            }
            default: {
                Log.w((String)LOGTAG, (String)"Ignoring the current network type.");
                return 0;
            }
        }
        TelephonyManager telephonyManager = (TelephonyManager)GeckoAppShell.getApplicationContext().getSystemService("phone");
        if (telephonyManager == null) {
            Log.e((String)LOGTAG, (String)"Telephony service does not exist");
            return 0;
        }
        switch (telephonyManager.getNetworkType()) {
            case 1: 
            case 4: 
            case 11: {
                return 5;
            }
            case 2: 
            case 7: {
                return 5;
            }
            case 3: 
            case 5: {
                return 6;
            }
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: {
                return 6;
            }
            case 15: {
                return 6;
            }
            case 13: {
                return 7;
            }
        }
        Log.w((String)LOGTAG, (String)"Connected to an unknown mobile network!");
        return 0;
    }

    @WrapForJNI(stubName="GetSystemColoursWrapper")
    public static int[] getSystemColors() {
        int[] nArray = new int[]{16842904, 16842806, 16842809, 16842808, 16842810, 0x1010212, 16843283, 0x1010099, 0x1010030, 0x1010031, 0x1010060, 0x1010061};
        int[] nArray2 = new int[nArray.length];
        ContextThemeWrapper contextThemeWrapper = new ContextThemeWrapper(GeckoAppShell.getApplicationContext(), 16973886);
        TypedArray typedArray = contextThemeWrapper.getTheme().obtainStyledAttributes(nArray);
        if (typedArray != null) {
            for (int i = 0; i < typedArray.getIndexCount(); ++i) {
                int n;
                int n2 = typedArray.getIndex(i);
                nArray2[n2] = n = typedArray.getColor(n2, 0);
            }
            typedArray.recycle();
        }
        return nArray2;
    }

    @WrapForJNI
    public static void killAnyZombies() {
        GeckoProcessesVisitor geckoProcessesVisitor = new GeckoProcessesVisitor(){

            @Override
            public boolean callback(int n) {
                if (n != Process.myPid()) {
                    Process.killProcess((int)n);
                }
                return true;
            }
        };
        GeckoAppShell.EnumerateGeckoProcesses(geckoProcessesVisitor);
    }

    private static void EnumerateGeckoProcesses(GeckoProcessesVisitor geckoProcessesVisitor) {
        int n = -1;
        int n2 = -1;
        try {
            int n3;
            boolean bl;
            int n4;
            String[] stringArray;
            String string2;
            java.lang.Process process = Runtime.getRuntime().exec("ps");
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()), 2048);
            String string3 = bufferedReader.readLine();
            StringTokenizer stringTokenizer = new StringTokenizer(string3);
            int n5 = 0;
            while (stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken();
                if (string2.equalsIgnoreCase("PID")) {
                    n = n5;
                } else if (string2.equalsIgnoreCase("USER")) {
                    n2 = n5;
                }
                ++n5;
            }
            string2 = null;
            while ((string2 = bufferedReader.readLine()) != null && ((stringArray = string2.split("\\s+")).length <= n || stringArray.length <= n2 || (n4 = Process.getUidForName((String)stringArray[n2])) != Process.myUid() || stringArray[stringArray.length - 1].equalsIgnoreCase("ps") || (bl = geckoProcessesVisitor.callback(n3 = Integer.parseInt(stringArray[n]))))) {
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            Log.w((String)LOGTAG, (String)"Failed to enumerate Gecko processes.", (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getAppNameByPID(int n) {
        BufferedReader bufferedReader = null;
        String string2 = "/proc/" + n + "/cmdline";
        try {
            File file = new File(string2);
            if (!file.exists()) {
                String string3 = "";
                return string3;
            }
            bufferedReader = new BufferedReader(new FileReader(file));
            String string4 = bufferedReader.readLine().trim();
            return string4;
        }
        catch (Exception exception) {
            String string5 = "";
            return string5;
        }
        finally {
            if (null != bufferedReader) {
                try {
                    bufferedReader.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static void listOfOpenFiles() {
        int n = -1;
        int n2 = -1;
        try {
            Object object;
            String string2 = GeckoProfile.get(GeckoAppShell.getApplicationContext()).getDir().toString();
            Log.d((String)LOGTAG, (String)("[OPENFILE] Filter: " + string2));
            java.lang.Process process = Runtime.getRuntime().exec("lsof");
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()), 2048);
            String string3 = bufferedReader.readLine();
            StringTokenizer stringTokenizer = new StringTokenizer(string3);
            int n3 = 0;
            while (stringTokenizer.hasMoreTokens()) {
                object = stringTokenizer.nextToken();
                if (((String)object).equalsIgnoreCase("PID")) {
                    n = n3;
                } else if (((String)object).equalsIgnoreCase("NAME")) {
                    n2 = n3;
                }
                ++n3;
            }
            object = new TreeMap();
            String string4 = null;
            while ((string4 = bufferedReader.readLine()) != null) {
                String[] stringArray = string4.split("\\s+");
                if (stringArray.length <= n || stringArray.length <= n2) continue;
                Integer n4 = Integer.valueOf(stringArray[n]);
                String string5 = (String)object.get(n4);
                if (string5 == null) {
                    string5 = GeckoAppShell.getAppNameByPID(n4);
                    object.put(n4, string5);
                }
                String string6 = stringArray[n2];
                if (TextUtils.isEmpty((CharSequence)string5) || TextUtils.isEmpty((CharSequence)string6) || !string6.startsWith(string2)) continue;
                Log.d((String)LOGTAG, (String)("[OPENFILE] " + string5 + "(" + stringArray[n] + ") : " + string6));
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @WrapForJNI(stubName="GetIconForExtensionWrapper")
    public static byte[] getIconForExtension(String string2, int n) {
        try {
            Bitmap bitmap;
            PackageManager packageManager;
            Drawable drawable2;
            if (n <= 0) {
                n = 16;
            }
            if (string2 != null && string2.length() > 1 && string2.charAt(0) == '.') {
                string2 = string2.substring(1);
            }
            if ((drawable2 = GeckoAppShell.getDrawableForExtension(packageManager = GeckoAppShell.getApplicationContext().getPackageManager(), string2)) == null) {
                drawable2 = packageManager.getDefaultActivityIcon();
            }
            if ((bitmap = ((BitmapDrawable)drawable2).getBitmap()).getWidth() != n || bitmap.getHeight() != n) {
                bitmap = Bitmap.createScaledBitmap((Bitmap)bitmap, (int)n, (int)n, (boolean)true);
            }
            ByteBuffer byteBuffer = ByteBuffer.allocate(n * n * 4);
            bitmap.copyPixelsToBuffer((Buffer)byteBuffer);
            return byteBuffer.array();
        }
        catch (Exception exception) {
            Log.w((String)LOGTAG, (String)"getIconForExtension failed.", (Throwable)exception);
            return null;
        }
    }

    public static String getMimeTypeFromExtension(String string2) {
        MimeTypeMap mimeTypeMap = MimeTypeMap.getSingleton();
        return mimeTypeMap.getMimeTypeFromExtension(string2);
    }

    private static Drawable getDrawableForExtension(PackageManager packageManager, String string2) {
        Intent intent = new Intent("android.intent.action.VIEW");
        String string3 = GeckoAppShell.getMimeTypeFromExtension(string2);
        if (string3 == null || string3.length() <= 0) {
            return null;
        }
        intent.setType(string3);
        List list = packageManager.queryIntentActivities(intent, 0);
        if (list.size() == 0) {
            return null;
        }
        ResolveInfo resolveInfo = (ResolveInfo)list.get(0);
        if (resolveInfo == null) {
            return null;
        }
        ActivityInfo activityInfo = resolveInfo.activityInfo;
        return activityInfo.loadIcon(packageManager);
    }

    @WrapForJNI
    public static boolean getShowPasswordSetting() {
        try {
            int n = Settings.System.getInt((ContentResolver)GeckoAppShell.getApplicationContext().getContentResolver(), (String)"show_password", (int)1);
            return n > 0;
        }
        catch (Exception exception) {
            return true;
        }
    }

    @WrapForJNI(stubName="AddPluginViewWrapper")
    public static void addPluginView(View view, float f, float f2, float f3, float f4, boolean bl) {
        if (GeckoAppShell.getGeckoInterface() != null) {
            GeckoAppShell.getGeckoInterface().addPluginView(view, new RectF(f, f2, f + f3, f2 + f4), bl);
        }
    }

    @WrapForJNI
    public static void removePluginView(View view, boolean bl) {
        if (GeckoAppShell.getGeckoInterface() != null) {
            GeckoAppShell.getGeckoInterface().removePluginView(view, bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static String[] getPluginDirectories() {
        Object object;
        Object object2;
        Serializable serializable;
        block28: {
            boolean bl;
            if (new File("/system/lib/hw/power.dragon.so").exists()) {
                Log.w((String)LOGTAG, (String)"Blocking plugins because of Pixel C device (bug 1255122)");
                return null;
            }
            boolean bl2 = bl = new File("/system/lib/hw/gralloc.tegra.so").exists() || new File("/system/lib/hw/gralloc.tegra3.so").exists() || new File("/sys/class/nvidia-gpu").exists();
            if (bl) {
                if (AppConstants.Versions.feature19Plus) {
                    Log.w((String)LOGTAG, (String)"Blocking plugins because of Tegra (bug 957694)");
                    return null;
                }
                serializable = new File("/proc/version");
                try {
                    if (!((File)serializable).canRead()) break block28;
                    object2 = new BufferedReader(new FileReader((File)serializable));
                    try {
                        object = ((BufferedReader)object2).readLine();
                        if (((String)object).indexOf("CM9") != -1 || ((String)object).indexOf("cyanogen") != -1 || ((String)object).indexOf("Nova") != -1) {
                            Log.w((String)LOGTAG, (String)"Blocking plugins because of Tegra 2 + unofficial ICS bug (bug 736421)");
                            String[] stringArray = null;
                            return stringArray;
                        }
                    }
                    finally {
                        ((BufferedReader)object2).close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        serializable = new ArrayList();
        object2 = GeckoAppShell.getApplicationContext().getPackageManager();
        object = object2.queryIntentServices(new Intent(PLUGIN_ACTION), 132);
        ArrayList<PackageInfo> arrayList = mPackageInfoCache;
        synchronized (arrayList) {
            mPackageInfoCache.clear();
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                String string2;
                PackageInfo packageInfo;
                block29: {
                    String[] stringArray;
                    ResolveInfo resolveInfo = (ResolveInfo)iterator.next();
                    ServiceInfo serviceInfo = resolveInfo.serviceInfo;
                    if (serviceInfo == null) {
                        Log.w((String)LOGTAG, (String)"Ignoring bad plugin.");
                        continue;
                    }
                    if (serviceInfo.packageName.equals("com.htc.flashliteplugin")) {
                        Log.w((String)LOGTAG, (String)"Skipping HTC's flash lite plugin");
                        continue;
                    }
                    try {
                        packageInfo = object2.getPackageInfo(serviceInfo.packageName, 4160);
                    }
                    catch (Exception exception) {
                        Log.w((String)LOGTAG, (String)("Can't find plugin: " + serviceInfo.packageName));
                        continue;
                    }
                    if (packageInfo == null) {
                        Log.w((String)LOGTAG, (String)("Not loading plugin: " + serviceInfo.packageName + ". Could not load package information."));
                        continue;
                    }
                    string2 = packageInfo.applicationInfo.dataDir + "/lib";
                    int n = packageInfo.applicationInfo.flags;
                    if ((n & 0x81) == 1) {
                        string2 = PLUGIN_SYSTEM_LIB + packageInfo.packageName;
                    }
                    if ((stringArray = packageInfo.requestedPermissions) == null) {
                        Log.w((String)LOGTAG, (String)("Not loading plugin: " + serviceInfo.packageName + ". Does not have required permission."));
                        continue;
                    }
                    boolean bl = false;
                    for (String string3 : stringArray) {
                        if (!PLUGIN_PERMISSION.equals(string3)) continue;
                        bl = true;
                        break;
                    }
                    if (!bl) {
                        Log.w((String)LOGTAG, (String)("Not loading plugin: " + serviceInfo.packageName + ". Does not have required permission (2)."));
                        continue;
                    }
                    String[] stringArray2 = packageInfo.signatures;
                    if (stringArray2 == null) {
                        Log.w((String)LOGTAG, (String)("Not loading plugin: " + serviceInfo.packageName + ". Not signed."));
                        continue;
                    }
                    if (serviceInfo.metaData == null) {
                        Log.e((String)LOGTAG, (String)("The plugin '" + serviceInfo.name + "' has no defined type."));
                        continue;
                    }
                    String string4 = serviceInfo.metaData.getString(PLUGIN_TYPE);
                    if (!TYPE_NATIVE.equals(string4)) {
                        Log.e((String)LOGTAG, (String)("Unrecognized plugin type: " + string4));
                        continue;
                    }
                    try {
                        Class<?> clazz = GeckoAppShell.getPluginClass(serviceInfo.packageName, serviceInfo.name);
                        boolean bl3 = true;
                        if (!bl3) {
                            Log.e((String)LOGTAG, (String)("The plugin's class' " + serviceInfo.name + "' does not extend the appropriate class."));
                        }
                        break block29;
                    }
                    catch (PackageManager.NameNotFoundException nameNotFoundException) {
                        Log.e((String)LOGTAG, (String)("Can't find plugin: " + serviceInfo.packageName));
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        Log.e((String)LOGTAG, (String)("Can't find plugin's class: " + serviceInfo.name));
                    }
                    continue;
                }
                mPackageInfoCache.add(packageInfo);
                ((ArrayList)serializable).add(string2);
            }
            return ((ArrayList)serializable).toArray(new String[((ArrayList)serializable).size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String getPluginPackage(String string2) {
        if (string2 == null || string2.length() == 0) {
            return null;
        }
        ArrayList<PackageInfo> arrayList = mPackageInfoCache;
        synchronized (arrayList) {
            for (PackageInfo packageInfo : mPackageInfoCache) {
                if (!string2.contains(packageInfo.packageName)) continue;
                return packageInfo.packageName;
            }
        }
        return null;
    }

    static Class<?> getPluginClass(String string2, String string3) throws PackageManager.NameNotFoundException, ClassNotFoundException {
        Context context = GeckoAppShell.getApplicationContext().createPackageContext(string2, 3);
        ClassLoader classLoader = context.getClassLoader();
        return classLoader.loadClass(string3);
    }

    @WrapForJNI(allowMultithread=true)
    public static Class<?> loadPluginClass(String string2, String string3) {
        if (GeckoAppShell.getGeckoInterface() == null) {
            return null;
        }
        try {
            String string4 = GeckoAppShell.getPluginPackage(string3);
            Context context = GeckoAppShell.getApplicationContext().createPackageContext(string4, 3);
            return context.getClassLoader().loadClass(string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Log.w((String)LOGTAG, (String)("Couldn't find plugin class " + string2), (Throwable)classNotFoundException);
            return null;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            Log.w((String)LOGTAG, (String)"Couldn't find package.", (Throwable)nameNotFoundException);
            return null;
        }
    }

    @Deprecated
    @WrapForJNI(allowMultithread=true)
    public static Context getContext() {
        return sContextGetter.getContext();
    }

    public static void setContextGetter(ContextGetter contextGetter) {
        sContextGetter = contextGetter;
    }

    @WrapForJNI(allowMultithread=true)
    public static Context getApplicationContext() {
        return sApplicationContext;
    }

    public static void setApplicationContext(Context context) {
        sApplicationContext = context;
    }

    public static SharedPreferences getSharedPreferences() {
        if (sContextGetter == null) {
            throw new IllegalStateException("No ContextGetter; cannot fetch prefs.");
        }
        return sContextGetter.getSharedPreferences();
    }

    public static GeckoInterface getGeckoInterface() {
        return sGeckoInterface;
    }

    public static void setGeckoInterface(GeckoInterface geckoInterface) {
        sGeckoInterface = geckoInterface;
    }

    static native void cameraCallbackBridge(byte[] var0);

    @WrapForJNI(stubName="InitCameraWrapper")
    static int[] initCamera(String string2, int n, int n2, int n3) {
        ThreadUtils.postToUiThread((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    if (GeckoAppShell.getGeckoInterface() != null) {
                        GeckoAppShell.getGeckoInterface().enableCameraView();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        int[] nArray = new int[4];
        nArray[0] = 0;
        if (Camera.getNumberOfCameras() == 0) {
            return nArray;
        }
        try {
            Camera.Size size;
            int n4;
            Iterator iterator;
            sCamera = Camera.open((int)n);
            Camera.Parameters parameters = sCamera.getParameters();
            parameters.setPreviewFormat(17);
            int n5 = 1000;
            try {
                iterator = parameters.getSupportedPreviewFrameRates().iterator();
                while (iterator.hasNext()) {
                    n4 = (Integer)iterator.next();
                    if (Math.abs(n4 - 25) >= n5) continue;
                    n5 = Math.abs(n4 - 25);
                    parameters.setPreviewFrameRate(n4);
                }
            }
            catch (Exception exception) {
                parameters.setPreviewFrameRate(25);
            }
            iterator = parameters.getSupportedPreviewSizes().iterator();
            n4 = 10000000;
            int n6 = 0;
            while (iterator.hasNext()) {
                size = (Camera.Size)iterator.next();
                if (Math.abs(size.width * size.height - n2 * n3) >= n4) continue;
                n4 = Math.abs(size.width * size.height - n2 * n3);
                parameters.setPreviewSize(size.width, size.height);
                n6 = size.width * size.height;
            }
            try {
                if (GeckoAppShell.getGeckoInterface() != null) {
                    size = GeckoAppShell.getGeckoInterface().getCameraView();
                    if (size instanceof SurfaceView) {
                        sCamera.setPreviewDisplay(((SurfaceView)size).getHolder());
                    } else if (size instanceof TextureView) {
                        sCamera.setPreviewTexture(((TextureView)size).getSurfaceTexture());
                    }
                }
            }
            catch (IOException | RuntimeException exception) {
                Log.w((String)LOGTAG, (String)"Error setPreviewXXX:", (Throwable)exception);
            }
            sCamera.setParameters(parameters);
            sCameraBuffer = new byte[n6 * 12 / 8];
            sCamera.addCallbackBuffer(sCameraBuffer);
            sCamera.setPreviewCallbackWithBuffer(new Camera.PreviewCallback(){

                public void onPreviewFrame(byte[] byArray, Camera camera) {
                    GeckoAppShell.cameraCallbackBridge(byArray);
                    if (sCamera != null) {
                        sCamera.addCallbackBuffer(sCameraBuffer);
                    }
                }
            });
            sCamera.startPreview();
            parameters = sCamera.getParameters();
            nArray[0] = 1;
            nArray[1] = parameters.getPreviewSize().width;
            nArray[2] = parameters.getPreviewSize().height;
            nArray[3] = parameters.getPreviewFrameRate();
        }
        catch (RuntimeException runtimeException) {
            Log.w((String)LOGTAG, (String)"initCamera RuntimeException.", (Throwable)runtimeException);
            nArray[3] = 0;
            nArray[2] = 0;
            nArray[1] = 0;
            nArray[0] = 0;
        }
        return nArray;
    }

    @WrapForJNI
    static synchronized void closeCamera() {
        ThreadUtils.postToUiThread((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    if (GeckoAppShell.getGeckoInterface() != null) {
                        GeckoAppShell.getGeckoInterface().disableCameraView();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        if (sCamera != null) {
            sCamera.stopPreview();
            sCamera.release();
            sCamera = null;
            sCameraBuffer = null;
        }
    }

    @WrapForJNI
    public static void enableBatteryNotifications() {
        GeckoBatteryManager.enableNotifications();
    }

    @WrapForJNI(stubName="HandleGeckoMessageWrapper")
    public static void handleGeckoMessage(NativeJSContainer nativeJSContainer) {
        EventDispatcher.getInstance().dispatchEvent(nativeJSContainer);
        nativeJSContainer.disposeNative();
    }

    @WrapForJNI
    public static void disableBatteryNotifications() {
        GeckoBatteryManager.disableNotifications();
    }

    @WrapForJNI(stubName="GetCurrentBatteryInformationWrapper")
    public static double[] getCurrentBatteryInformation() {
        return GeckoBatteryManager.getCurrentInformation();
    }

    @WrapForJNI(stubName="CheckURIVisited")
    static void checkUriVisited(String string2) {
        GeckoInterface geckoInterface = GeckoAppShell.getGeckoInterface();
        if (geckoInterface == null) {
            return;
        }
        geckoInterface.checkUriVisited(string2);
    }

    @WrapForJNI(stubName="MarkURIVisited")
    static void markUriVisited(String string2) {
        GeckoInterface geckoInterface = GeckoAppShell.getGeckoInterface();
        if (geckoInterface == null) {
            return;
        }
        geckoInterface.markUriVisited(string2);
    }

    @WrapForJNI(stubName="SetURITitle")
    static void setUriTitle(String string2, String string3) {
        GeckoInterface geckoInterface = GeckoAppShell.getGeckoInterface();
        if (geckoInterface == null) {
            return;
        }
        geckoInterface.setUriTitle(string2, string3);
    }

    @WrapForJNI
    static void hideProgressDialog() {
    }

    public static void sendMessage(String string2, String string3, int n, boolean bl) {
        if (!SmsManager.isEnabled()) {
            return;
        }
        SmsManager.getInstance().send(string2, string3, n, bl);
    }

    @WrapForJNI(stubName="SendMessageWrapper")
    public static void sendMessage(String string2, String string3, int n) {
        GeckoAppShell.sendMessage(string2, string3, n, true);
    }

    @WrapForJNI(stubName="GetMessageWrapper")
    public static void getMessage(int n, int n2) {
        if (!SmsManager.isEnabled()) {
            return;
        }
        SmsManager.getInstance().getMessage(n, n2);
    }

    @WrapForJNI(stubName="DeleteMessageWrapper")
    public static void deleteMessage(int n, int n2) {
        if (!SmsManager.isEnabled()) {
            return;
        }
        SmsManager.getInstance().deleteMessage(n, n2);
    }

    @WrapForJNI
    public static void markMessageRead(int n, boolean bl, boolean bl2, int n2) {
        if (!SmsManager.isEnabled()) {
            return;
        }
        SmsManager.getInstance().markMessageRead(n, bl, bl2, n2);
    }

    @WrapForJNI(stubName="CreateMessageCursorWrapper")
    public static void createMessageCursor(long l, long l2, String[] stringArray, int n, String string2, boolean bl, boolean bl2, boolean bl3, long l3, boolean bl4, int n2) {
        if (!SmsManager.isEnabled()) {
            return;
        }
        SmsManager.getInstance().createMessageCursor(l, l2, stringArray, n, string2, bl, bl2, bl3, l3, bl4, n2);
    }

    @WrapForJNI(stubName="GetNextMessageWrapper")
    public static void getNextMessage(int n) {
        if (!SmsManager.isEnabled()) {
            return;
        }
        SmsManager.getInstance().getNextMessage(n);
    }

    @WrapForJNI(stubName="CreateThreadCursorWrapper")
    public static void createThreadCursor(int n) {
        Log.i((String)LOGTAG, (String)"CreateThreadCursorWrapper!");
        if (!SmsManager.isEnabled()) {
            return;
        }
        SmsManager.getInstance().createThreadCursor(n);
    }

    @WrapForJNI(stubName="GetNextThreadWrapper")
    public static void getNextThread(int n) {
        if (!SmsManager.isEnabled()) {
            return;
        }
        SmsManager.getInstance().getNextThread(n);
    }

    @WrapForJNI
    @RobocopTarget
    public static boolean isTablet() {
        return HardwareUtils.isTablet();
    }

    public static void viewSizeChanged() {
        GeckoView geckoView = (GeckoView)GeckoAppShell.getLayerView();
        if (geckoView == null) {
            return;
        }
        boolean bl = geckoView.isIMEEnabled();
        if (bl && !sImeWasEnabledOnLastResize) {
            GeckoAppShell.notifyObservers("ScrollTo:FocusedInput", "");
        }
        sImeWasEnabledOnLastResize = bl;
    }

    @WrapForJNI(stubName="GetCurrentNetworkInformationWrapper")
    public static double[] getCurrentNetworkInformation() {
        return GeckoNetworkManager.getInstance().getCurrentInformation();
    }

    @WrapForJNI
    public static void enableNetworkNotifications() {
        ThreadUtils.postToUiThread((Runnable)new Runnable(){

            @Override
            public void run() {
                GeckoNetworkManager.getInstance().enableNotifications();
            }
        });
    }

    @WrapForJNI
    public static void disableNetworkNotifications() {
        ThreadUtils.postToUiThread((Runnable)new Runnable(){

            @Override
            public void run() {
                GeckoNetworkManager.getInstance().disableNotifications();
            }
        });
    }

    @WrapForJNI(stubName="GetScreenOrientationWrapper")
    public static short getScreenOrientation() {
        return GeckoScreenOrientation.getInstance().getScreenOrientation().value;
    }

    @WrapForJNI
    public static int getScreenAngle() {
        return GeckoScreenOrientation.getInstance().getAngle();
    }

    @WrapForJNI
    public static void enableScreenOrientationNotifications() {
        GeckoScreenOrientation.getInstance().enableNotifications();
    }

    @WrapForJNI
    public static void disableScreenOrientationNotifications() {
        GeckoScreenOrientation.getInstance().disableNotifications();
    }

    @WrapForJNI
    public static void lockScreenOrientation(int n) {
        GeckoScreenOrientation.getInstance().lock(n);
    }

    @WrapForJNI
    public static void unlockScreenOrientation() {
        GeckoScreenOrientation.getInstance().unlock();
    }

    @WrapForJNI
    public static void notifyWakeLockChanged(String string2, String string3) {
        if (GeckoAppShell.getGeckoInterface() != null) {
            GeckoAppShell.getGeckoInterface().notifyWakeLockChanged(string2, string3);
        }
    }

    @WrapForJNI(allowMultithread=true)
    public static void registerSurfaceTextureFrameListener(Object object, final int n) {
        ((SurfaceTexture)object).setOnFrameAvailableListener(new SurfaceTexture.OnFrameAvailableListener(){

            public void onFrameAvailable(SurfaceTexture surfaceTexture) {
                GeckoAppShell.onSurfaceTextureFrameAvailable(surfaceTexture, n);
            }
        });
    }

    @WrapForJNI(allowMultithread=true)
    public static void unregisterSurfaceTextureFrameListener(Object object) {
        ((SurfaceTexture)object).setOnFrameAvailableListener(null);
    }

    @WrapForJNI
    public static boolean unlockProfile() {
        GeckoAppShell.killAnyZombies();
        if (GeckoAppShell.getGeckoInterface() != null) {
            GeckoProfile geckoProfile = GeckoAppShell.getGeckoInterface().getProfile();
            File file = geckoProfile.getFile(".parentlock");
            return file.exists() && file.delete();
        }
        return false;
    }

    @WrapForJNI(stubName="GetProxyForURIWrapper")
    public static String getProxyForURI(String string2, String string3, String string4, int n) {
        ProxySelector proxySelector = new ProxySelector();
        Proxy proxy = proxySelector.select(string3, string4);
        if (Proxy.NO_PROXY.equals(proxy)) {
            return "DIRECT";
        }
        switch (proxy.type()) {
            case HTTP: {
                return "PROXY " + proxy.address().toString();
            }
            case SOCKS: {
                return "SOCKS " + proxy.address().toString();
            }
        }
        return "DIRECT";
    }

    @WrapForJNI(allowMultithread=true)
    static InputStream createInputStream(URLConnection uRLConnection) throws IOException {
        return uRLConnection.getInputStream();
    }

    @WrapForJNI(allowMultithread=true, narrowChars=true)
    static URLConnection getConnection(String string2) {
        try {
            String string3 = string2.startsWith("android://") ? string2.substring(10) : string2.substring(8);
            try {
                if (string3.startsWith("icon/")) {
                    String[] stringArray = string3.split("/");
                    if (stringArray.length != 2) {
                        return null;
                    }
                    String string4 = stringArray[1];
                    PackageManager packageManager = GeckoAppShell.getApplicationContext().getPackageManager();
                    Drawable drawable2 = packageManager.getApplicationIcon(string4);
                    Bitmap bitmap = BitmapUtils.getBitmapFromDrawable(drawable2);
                    return new BitmapConnection(bitmap);
                }
            }
            catch (Exception exception) {
                Log.e((String)LOGTAG, (String)GECKOREQUEST_ERROR_KEY, (Throwable)exception);
            }
            int n = string3.indexOf(58);
            if (n == -1 || n > string3.indexOf(47)) {
                string3 = string3.replaceFirst("/", ":/");
            }
        }
        catch (Exception exception) {
            return null;
        }
        return null;
    }

    @WrapForJNI(allowMultithread=true, narrowChars=true)
    static String connectionGetMimeType(URLConnection uRLConnection) {
        return uRLConnection.getContentType();
    }

    @WrapForJNI
    static String getExternalPublicDirectory(String string2) {
        String string3;
        String string4 = Environment.getExternalStorageState();
        if (!"mounted".equals(string4) && !"mounted_ro".equals(string4)) {
            return null;
        }
        if ("sdcard".equals(string2)) {
            return Environment.getExternalStorageDirectory().getAbsolutePath();
        }
        if ("downloads".equals(string2)) {
            string3 = Environment.DIRECTORY_DOWNLOADS;
        } else if ("pictures".equals(string2)) {
            string3 = Environment.DIRECTORY_PICTURES;
        } else if ("videos".equals(string2)) {
            string3 = Environment.DIRECTORY_MOVIES;
        } else if ("music".equals(string2)) {
            string3 = Environment.DIRECTORY_MUSIC;
        } else {
            if ("apps".equals(string2)) {
                File file = GeckoAppShell.getApplicationContext().getFilesDir();
                return new File(file, "mozilla").getAbsolutePath();
            }
            return null;
        }
        return Environment.getExternalStoragePublicDirectory((String)string3).getAbsolutePath();
    }

    @WrapForJNI
    static int getMaxTouchPoints() {
        PackageManager packageManager = GeckoAppShell.getApplicationContext().getPackageManager();
        if (packageManager.hasSystemFeature("android.hardware.touchscreen.multitouch.jazzhand")) {
            return 5;
        }
        if (packageManager.hasSystemFeature("android.hardware.touchscreen.multitouch.distinct")) {
            return 2;
        }
        if (packageManager.hasSystemFeature("android.hardware.touchscreen.multitouch")) {
            return 2;
        }
        if (packageManager.hasSystemFeature("android.hardware.touchscreen")) {
            return 1;
        }
        return 0;
    }

    public static synchronized void resetScreenSize() {
        sScreenSize = null;
    }

    @WrapForJNI
    public static synchronized Rect getScreenSize() {
        if (sScreenSize == null) {
            WindowManager windowManager = (WindowManager)GeckoAppShell.getApplicationContext().getSystemService("window");
            Display display = windowManager.getDefaultDisplay();
            sScreenSize = new Rect(0, 0, display.getWidth(), display.getHeight());
        }
        return sScreenSize;
    }

    static {
        sCallbackRunnable = new Runnable(){

            @Override
            public void run() {
                ThreadUtils.assertOnUiThread();
                long l = GeckoAppShell.runUiThreadCallback();
                if (l >= 0L) {
                    ThreadUtils.getUiHandler().postDelayed((Runnable)this, l);
                }
            }
        };
        mPackageInfoCache = new ArrayList();
        sImeWasEnabledOnLastResize = false;
    }

    private static class BitmapConnection
    extends URLConnection {
        private Bitmap bitmap;

        BitmapConnection(Bitmap bitmap) throws MalformedURLException, IOException {
            super(null);
            this.bitmap = bitmap;
        }

        @Override
        public void connect() {
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return new BitmapInputStream();
        }

        @Override
        public String getContentType() {
            return "image/png";
        }

        private final class BitmapInputStream
        extends PipedInputStream {
            private boolean mHaveConnected = false;

            private BitmapInputStream() {
            }

            @Override
            public synchronized int read(byte[] byArray, int n, int n2) throws IOException {
                if (this.mHaveConnected) {
                    return super.read(byArray, n, n2);
                }
                final PipedOutputStream pipedOutputStream = new PipedOutputStream();
                this.connect(pipedOutputStream);
                ThreadUtils.postToBackgroundThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        try {
                            BitmapConnection.this.bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)pipedOutputStream);
                            pipedOutputStream.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                });
                this.mHaveConnected = true;
                return super.read(byArray, n, n2);
            }
        }
    }

    public static interface GeckoInterface {
        public GeckoProfile getProfile();

        public Activity getActivity();

        public String getDefaultUAString();

        public LocationListener getLocationListener();

        public SensorEventListener getSensorEventListener();

        public void doRestart();

        public void setFullScreen(boolean var1);

        public void addPluginView(View var1, RectF var2, boolean var3);

        public void removePluginView(View var1, boolean var2);

        public void enableCameraView();

        public void disableCameraView();

        public void addAppStateListener(AppStateListener var1);

        public void removeAppStateListener(AppStateListener var1);

        public View getCameraView();

        public void notifyWakeLockChanged(String var1, String var2);

        public FormAssistPopup getFormAssistPopup();

        public boolean areTabsShown();

        public AbsoluteLayout getPluginContainer();

        public void notifyCheckUpdateResult(String var1);

        public void invalidateOptionsMenu();

        public void createShortcut(String var1, String var2);

        public void checkUriVisited(String var1);

        public void markUriVisited(String var1);

        public void setUriTitle(String var1, String var2);

        public void setAccessibilityEnabled(boolean var1);

        public boolean openUriExternal(String var1, String var2, String var3, String var4, String var5, String var6);

        public String[] getHandlersForMimeType(String var1, String var2);

        public String[] getHandlersForURL(String var1, String var2);
    }

    public static interface AppStateListener {
        public void onPause();

        public void onResume();

        public void onOrientationChanged();
    }

    static interface GeckoProcessesVisitor {
        public boolean callback(int var1);
    }
}

