/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.favicons;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import org.mozilla.gecko.R;
import org.mozilla.gecko.favicons.OnFaviconLoadedListener;
import org.mozilla.gecko.util.ThreadUtils;

public class FaviconGenerator {
    private static final int[] COLORS = new int[]{-3982286, -894944, -28138, -13568, -11027147, -16663123, -16148744, -16624757, -14731154, -8769670, -1427362};
    private static final String[] COMMON_PREFIXES = new String[]{"www.", "m.", "mobile."};
    private static final int TEXT_SIZE_DP = 12;

    public static void generate(final Context context, final String string2, final OnFaviconLoadedListener onFaviconLoadedListener) {
        ThreadUtils.postToBackgroundThread((Runnable)new Runnable(){

            @Override
            public void run() {
                final Bitmap bitmap = FaviconGenerator.generate(context, string2);
                ThreadUtils.postToUiThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        onFaviconLoadedListener.onFaviconLoaded(string2, null, bitmap);
                    }
                });
            }
        });
    }

    public static Bitmap generate(Context context, String string2) {
        Resources resources = context.getResources();
        int n = resources.getDimensionPixelSize(R.dimen.favicon_bg);
        int n2 = resources.getDimensionPixelOffset(R.dimen.favicon_corner_radius);
        Bitmap bitmap = Bitmap.createBitmap((int)n, (int)n, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        Paint paint = new Paint();
        paint.setColor(FaviconGenerator.pickColor(string2));
        canvas.drawRoundRect(new RectF(0.0f, 0.0f, (float)n, (float)n), (float)n2, (float)n2, paint);
        paint.setColor(-1);
        String string3 = FaviconGenerator.getRepresentativeCharacter(string2);
        float f = TypedValue.applyDimension((int)1, (float)12.0f, (DisplayMetrics)context.getResources().getDisplayMetrics());
        paint.setTextAlign(Paint.Align.CENTER);
        paint.setTextSize(f);
        paint.setAntiAlias(true);
        canvas.drawText(string3, (float)(canvas.getWidth() / 2), (float)((int)((float)(canvas.getHeight() / 2) - (paint.descent() + paint.ascent()) / 2.0f)), paint);
        return bitmap;
    }

    protected static String getRepresentativeCharacter(String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return "?";
        }
        String string3 = FaviconGenerator.getRepresentativeSnippet(string2);
        for (int i = 0; i < string3.length(); ++i) {
            char c = string3.charAt(i);
            if (!Character.isLetterOrDigit(c)) continue;
            return String.valueOf(Character.toUpperCase(c));
        }
        return "?";
    }

    protected static int pickColor(String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return COLORS[0];
        }
        String string3 = FaviconGenerator.getRepresentativeSnippet(string2);
        int n = Math.abs(string3.hashCode() % COLORS.length);
        return COLORS[n];
    }

    private static String getRepresentativeSnippet(@NonNull String string2) {
        Uri uri = Uri.parse((String)string2);
        String string3 = uri.getHost();
        if (TextUtils.isEmpty((CharSequence)string3)) {
            string3 = uri.getPath();
        }
        if (TextUtils.isEmpty((CharSequence)string3)) {
            return "?";
        }
        for (String string4 : COMMON_PREFIXES) {
            if (!string3.startsWith(string4)) continue;
            string3 = string3.substring(string4.length());
        }
        return string3;
    }
}

