/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.favicons;

import android.content.ContentResolver;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.text.TextUtils;
import android.util.Log;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.GeckoProfile;
import org.mozilla.gecko.db.BrowserDB;
import org.mozilla.gecko.favicons.Favicons;
import org.mozilla.gecko.favicons.OnFaviconLoadedListener;
import org.mozilla.gecko.favicons.decoders.FaviconDecoder;
import org.mozilla.gecko.favicons.decoders.LoadFaviconResult;
import org.mozilla.gecko.util.GeckoJarReader;
import org.mozilla.gecko.util.IOUtils;
import org.mozilla.gecko.util.ProxySelector;
import org.mozilla.gecko.util.ThreadUtils;

public class LoadFaviconTask {
    private static final String LOGTAG = "LoadFaviconTask";
    private static final HashMap<String, LoadFaviconTask> loadsInFlight = new HashMap();
    public static final int FLAG_PERSIST = 1;
    public static final int FLAG_BYPASS_CACHE_WHEN_DOWNLOADING_ICONS = 2;
    private static final int MAX_REDIRECTS_TO_FOLLOW = 5;
    public static final int DEFAULT_FAVICON_BUFFER_SIZE = 25000;
    private static final AtomicInteger nextFaviconLoadId = new AtomicInteger(0);
    private final Context context;
    private final int id = nextFaviconLoadId.incrementAndGet();
    private final String pageUrl;
    private String faviconURL;
    private final OnFaviconLoadedListener listener;
    private final int flags;
    private final BrowserDB db;
    private final boolean onlyFromLocal;
    volatile boolean mCancelled;
    protected int targetWidthAndHeight;
    private LinkedList<LoadFaviconTask> chainees;
    private boolean isChaining;

    public LoadFaviconTask(Context context, String string2, String string3, int n, OnFaviconLoadedListener onFaviconLoadedListener, int n2, boolean bl) {
        this.context = context;
        this.db = GeckoProfile.get(context).getDB();
        this.pageUrl = string2;
        this.faviconURL = string3;
        this.listener = onFaviconLoadedListener;
        this.flags = n;
        this.targetWidthAndHeight = n2;
        this.onlyFromLocal = bl;
    }

    private LoadFaviconResult loadFaviconFromDb(BrowserDB browserDB) {
        ContentResolver contentResolver = this.context.getContentResolver();
        return browserDB.getFaviconForUrl(contentResolver, this.faviconURL);
    }

    private void saveFaviconToDb(BrowserDB browserDB, byte[] byArray) {
        if (byArray == null) {
            return;
        }
        if ((this.flags & 1) == 0) {
            return;
        }
        ContentResolver contentResolver = this.context.getContentResolver();
        browserDB.updateFaviconForUrl(contentResolver, this.pageUrl, byArray, this.faviconURL);
    }

    private Response tryDownload(URI uRI) throws URISyntaxException, IOException {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(uRI.toString());
        return this.tryDownloadRecurse(uRI, hashSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Response tryDownloadRecurse(URI uRI, HashSet<String> hashSet) throws URISyntaxException, IOException {
        if (hashSet.size() == 5) {
            return null;
        }
        HttpURLConnection httpURLConnection = (HttpURLConnection)ProxySelector.openConnectionWithProxy((URI)uRI);
        httpURLConnection.setRequestProperty("User-Agent", GeckoAppShell.getGeckoInterface().getDefaultUAString());
        httpURLConnection.connect();
        int n = httpURLConnection.getResponseCode();
        if (n >= 300 && n < 400) {
            String string2 = httpURLConnection.getHeaderField("Location");
            try {
                if (string2 == null || string2.equals(uRI.toString())) {
                    Response response = null;
                    return response;
                }
                if (hashSet.contains(string2)) {
                    Response response = null;
                    return response;
                }
                hashSet.add(string2);
            }
            finally {
                httpURLConnection.disconnect();
            }
            return this.tryDownloadRecurse(new URI(string2), hashSet);
        }
        if (n >= 400) {
            httpURLConnection.disconnect();
            return null;
        }
        return new Response(httpURLConnection.getInputStream(), httpURLConnection.getHeaderFieldInt("Content-Length", -1));
    }

    private Bitmap fetchJARFavicon(String string2) {
        if (string2 == null) {
            return null;
        }
        if (string2.startsWith("jar:jar:")) {
            Log.d((String)LOGTAG, (String)"Fetching favicon from JAR.");
            try {
                return GeckoJarReader.getBitmap((Context)this.context, (Resources)this.context.getResources(), (String)string2);
            }
            catch (Exception exception) {
                Log.w((String)LOGTAG, (String)"Error fetching favicon from JAR.", (Throwable)exception);
                return null;
            }
        }
        return null;
    }

    private LoadFaviconResult downloadFavicon(URI uRI) {
        if (uRI == null) {
            return null;
        }
        String string2 = uRI.getScheme();
        if (!"http".equals(string2) && !"https".equals(string2)) {
            return null;
        }
        LoadFaviconResult loadFaviconResult = null;
        try {
            loadFaviconResult = this.downloadAndDecodeImage(uRI);
        }
        catch (Exception exception) {
            Log.e((String)LOGTAG, (String)"Error reading favicon", (Throwable)exception);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            Log.e((String)LOGTAG, (String)"Insufficient memory to process favicon");
        }
        return loadFaviconResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LoadFaviconResult downloadAndDecodeImage(URI uRI) throws IOException, URISyntaxException {
        Response response = this.tryDownload(uRI);
        if (response == null) {
            return null;
        }
        try {
            LoadFaviconResult loadFaviconResult = this.decodeImageFromResponse(response);
            return loadFaviconResult;
        }
        finally {
            IOUtils.safeStreamClose((Closeable)response.stream);
        }
    }

    private LoadFaviconResult decodeImageFromResponse(Response response) throws IOException {
        int n = response.contentLength > 0 ? response.contentLength + 1 : 25000;
        IOUtils.ConsumedInputStream consumedInputStream = IOUtils.readFully((InputStream)response.stream, (int)n);
        if (consumedInputStream == null) {
            return null;
        }
        return FaviconDecoder.decodeFavicon(consumedInputStream.getData(), 0, consumedInputStream.consumedLength);
    }

    public final void execute() {
        try {
            Favicons.longRunningExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    final Bitmap bitmap = LoadFaviconTask.this.doInBackground(LoadFaviconTask.this.db);
                    ThreadUtils.getUiHandler().post(new Runnable(){

                        @Override
                        public void run() {
                            if (LoadFaviconTask.this.mCancelled) {
                                LoadFaviconTask.this.onCancelled();
                            } else {
                                LoadFaviconTask.this.onPostExecute(bitmap);
                            }
                        }
                    });
                }
            });
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            this.onCancelled();
        }
    }

    public final boolean cancel() {
        this.mCancelled = true;
        return true;
    }

    public final boolean isCancelled() {
        return this.mCancelled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Bitmap doInBackground(BrowserDB browserDB) {
        Object object;
        ContentResolver contentResolver;
        Object object2;
        if (this.isCancelled()) {
            return null;
        }
        boolean bl = TextUtils.isEmpty((CharSequence)this.faviconURL);
        if (!bl && (object2 = FaviconDecoder.decodeDataURI(this.faviconURL)) != null) {
            return this.pushToCacheAndGetResult((LoadFaviconResult)object2);
        }
        boolean bl2 = false;
        if (bl) {
            contentResolver = this.context.getContentResolver();
            object2 = Favicons.getFaviconURLForPageURLFromCache(this.pageUrl);
            if (object2 == null && (object2 = Favicons.getFaviconURLForPageURL(browserDB, contentResolver, this.pageUrl)) != null) {
                Favicons.putFaviconURLForPageURLInCache(this.pageUrl, (String)object2);
            }
            if (object2 != null) {
                this.faviconURL = object2;
            } else {
                this.faviconURL = Favicons.guessDefaultFaviconURL(this.pageUrl);
                if (TextUtils.isEmpty((CharSequence)this.faviconURL)) {
                    return null;
                }
                bl2 = true;
            }
        }
        if (Favicons.isFailedFavicon(this.faviconURL)) {
            return null;
        }
        if (this.isCancelled()) {
            return null;
        }
        Object object3 = loadsInFlight;
        synchronized (object3) {
            object = loadsInFlight.get(this.faviconURL);
            if (object != null && !((LoadFaviconTask)object).isCancelled()) {
                ((LoadFaviconTask)object).chainTasks(this);
                this.isChaining = true;
                return null;
            }
            loadsInFlight.put(this.faviconURL, this);
        }
        if (this.isCancelled()) {
            return null;
        }
        object3 = null;
        if ((this.flags & 2) == 0 && (object3 = this.loadFaviconFromDb(browserDB)) != null) {
            return this.pushToCacheAndGetResult((LoadFaviconResult)object3);
        }
        if (this.onlyFromLocal || this.isCancelled()) {
            return null;
        }
        contentResolver = this.fetchJARFavicon(this.faviconURL);
        if (LoadFaviconTask.imageIsValid((Bitmap)contentResolver)) {
            Favicons.putFaviconInMemCache(this.faviconURL, (Bitmap)contentResolver);
            return contentResolver;
        }
        try {
            object3 = this.downloadFavicon(new URI(this.faviconURL));
        }
        catch (URISyntaxException uRISyntaxException) {
            Log.e((String)LOGTAG, (String)"The provided favicon URL is not valid");
            return null;
        }
        catch (Exception exception) {
            Log.e((String)LOGTAG, (String)"Couldn't download favicon.", (Throwable)exception);
        }
        if (object3 != null) {
            if ((this.flags & 2) == 0) {
                this.saveFaviconToDb(browserDB, ((LoadFaviconResult)object3).getBytesForDatabaseStorage());
                return this.pushToCacheAndGetResult((LoadFaviconResult)object3);
            }
            object = new HashMap();
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            while (((LoadFaviconResult)object3).getBitmaps().hasNext()) {
                Bitmap bitmap = ((LoadFaviconResult)object3).getBitmaps().next();
                if (bitmap == null) continue;
                object.put(bitmap.getWidth(), bitmap);
                arrayList.add(bitmap.getWidth());
            }
            int n = Favicons.selectBestSizeFromList(arrayList, this.targetWidthAndHeight);
            if (n == -1) {
                return null;
            }
            return (Bitmap)object.get(n);
        }
        if (bl2) {
            Favicons.putFaviconInFailedCache(this.faviconURL);
            return null;
        }
        if (this.isCancelled()) {
            return null;
        }
        object = Favicons.guessDefaultFaviconURL(this.pageUrl);
        if (object == null) {
            Favicons.putFaviconInFailedCache(this.faviconURL);
            return null;
        }
        contentResolver = this.fetchJARFavicon((String)object);
        if (LoadFaviconTask.imageIsValid((Bitmap)contentResolver)) {
            Favicons.putFaviconInMemCache(this.faviconURL, (Bitmap)contentResolver);
            return contentResolver;
        }
        try {
            object3 = this.downloadFavicon(new URI((String)object));
        }
        catch (Exception exception) {
            return null;
        }
        if (object3 != null) {
            this.saveFaviconToDb(browserDB, ((LoadFaviconResult)object3).getBytesForDatabaseStorage());
            return this.pushToCacheAndGetResult((LoadFaviconResult)object3);
        }
        return null;
    }

    private Bitmap pushToCacheAndGetResult(LoadFaviconResult loadFaviconResult) {
        Favicons.putFaviconsInMemCache(this.faviconURL, loadFaviconResult.getBitmaps());
        return Favicons.getSizedFaviconFromCache(this.faviconURL, this.targetWidthAndHeight);
    }

    private static boolean imageIsValid(Bitmap bitmap) {
        return bitmap != null && bitmap.getWidth() > 0 && bitmap.getHeight() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onPostExecute(Bitmap bitmap) {
        if (this.isChaining) {
            return;
        }
        this.processResult(bitmap);
        HashMap<String, LoadFaviconTask> hashMap = loadsInFlight;
        synchronized (hashMap) {
            loadsInFlight.remove(this.faviconURL);
        }
        if (this.chainees != null) {
            for (LoadFaviconTask loadFaviconTask : this.chainees) {
                loadFaviconTask.processResult(bitmap);
            }
        }
    }

    private void processResult(Bitmap bitmap) {
        Favicons.removeLoadTask(this.id);
        Bitmap bitmap2 = this.targetWidthAndHeight != -1 && bitmap != null && bitmap.getWidth() != this.targetWidthAndHeight ? ((this.flags & 2) != 0 ? Bitmap.createScaledBitmap((Bitmap)bitmap, (int)this.targetWidthAndHeight, (int)this.targetWidthAndHeight, (boolean)true) : Favicons.getSizedFaviconFromCache(this.faviconURL, this.targetWidthAndHeight)) : bitmap;
        Favicons.dispatchResult(this.pageUrl, this.faviconURL, bitmap2, this.listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onCancelled() {
        Favicons.removeLoadTask(this.id);
        HashMap<String, LoadFaviconTask> hashMap = loadsInFlight;
        synchronized (hashMap) {
            LoadFaviconTask loadFaviconTask = loadsInFlight.get(this.faviconURL);
            if (loadFaviconTask == this) {
                loadsInFlight.remove(this.faviconURL);
                return;
            }
            if (loadFaviconTask == null) {
                return;
            }
            if (loadFaviconTask.chainees != null) {
                loadFaviconTask.chainees.remove(this);
            }
        }
    }

    private void chainTasks(LoadFaviconTask loadFaviconTask) {
        if (this.chainees == null) {
            this.chainees = new LinkedList();
        }
        this.chainees.add(loadFaviconTask);
    }

    int getId() {
        return this.id;
    }

    private static class Response {
        public final int contentLength;
        public final InputStream stream;

        private Response(InputStream inputStream, int n) {
            this.stream = inputStream;
            this.contentLength = n;
        }
    }
}

