/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.home;

import android.content.Context;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.View;
import java.util.EnumSet;
import org.mozilla.gecko.Telemetry;
import org.mozilla.gecko.TelemetryContract;
import org.mozilla.gecko.db.RemoteClient;
import org.mozilla.gecko.home.ClientsAdapter;
import org.mozilla.gecko.home.CombinedHistoryItem;
import org.mozilla.gecko.home.CombinedHistoryPanel;
import org.mozilla.gecko.home.HomeContextMenuInfo;
import org.mozilla.gecko.home.HomePager;
import org.mozilla.gecko.home.RecentTabsAdapter;
import org.mozilla.gecko.home.TwoLinePageRow;
import org.mozilla.gecko.widget.RecyclerViewClickSupport;

public class CombinedHistoryRecyclerView
extends RecyclerView
implements RecyclerViewClickSupport.OnItemClickListener,
RecyclerViewClickSupport.OnItemLongClickListener {
    public static String LOGTAG = "CombinedHistoryRecycView";
    protected HomePager.OnUrlOpenListener mOnUrlOpenListener;
    protected CombinedHistoryPanel.OnPanelLevelChangeListener mOnPanelLevelChangeListener;
    protected CombinedHistoryPanel.DialogBuilder<RemoteClient> mDialogBuilder;
    protected HomeContextMenuInfo mContextMenuInfo;

    public CombinedHistoryRecyclerView(Context context) {
        super(context);
        this.init(context);
    }

    public CombinedHistoryRecyclerView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.init(context);
    }

    public CombinedHistoryRecyclerView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.init(context);
    }

    private void init(Context context) {
        LinearLayoutManager linearLayoutManager = new LinearLayoutManager(context);
        linearLayoutManager.setOrientation(1);
        this.setLayoutManager((RecyclerView.LayoutManager)linearLayoutManager);
        RecyclerViewClickSupport.addTo(this).setOnItemClickListener(this).setOnItemLongClickListener(this);
        this.setOnKeyListener(new View.OnKeyListener(){

            public boolean onKey(View view, int n, KeyEvent keyEvent) {
                int n2 = keyEvent.getAction();
                if (n2 == 1 && n == 4) {
                    return CombinedHistoryRecyclerView.this.mOnPanelLevelChangeListener.changeLevel(CombinedHistoryPanel.OnPanelLevelChangeListener.PanelLevel.PARENT);
                }
                return false;
            }
        });
    }

    public void setOnHistoryClickedListener(HomePager.OnUrlOpenListener onUrlOpenListener) {
        this.mOnUrlOpenListener = onUrlOpenListener;
    }

    public void setOnPanelLevelChangeListener(CombinedHistoryPanel.OnPanelLevelChangeListener onPanelLevelChangeListener) {
        this.mOnPanelLevelChangeListener = onPanelLevelChangeListener;
    }

    public void setHiddenClientsDialogBuilder(CombinedHistoryPanel.DialogBuilder<RemoteClient> dialogBuilder) {
        this.mDialogBuilder = dialogBuilder;
    }

    @Override
    public void onItemClicked(RecyclerView recyclerView, int n, View view) {
        int n2 = this.getAdapter().getItemViewType(n);
        CombinedHistoryItem.ItemType itemType = CombinedHistoryItem.ItemType.viewTypeToItemType(n2);
        switch (itemType) {
            case RECENT_TABS: {
                this.mOnPanelLevelChangeListener.changeLevel(CombinedHistoryPanel.OnPanelLevelChangeListener.PanelLevel.CHILD_RECENT_TABS);
                break;
            }
            case SYNCED_DEVICES: {
                this.mOnPanelLevelChangeListener.changeLevel(CombinedHistoryPanel.OnPanelLevelChangeListener.PanelLevel.CHILD_SYNC);
                break;
            }
            case CLIENT: {
                ((ClientsAdapter)this.getAdapter()).toggleClient(n);
                break;
            }
            case HIDDEN_DEVICES: {
                if (this.mDialogBuilder == null) break;
                this.mDialogBuilder.createAndShowDialog(((ClientsAdapter)this.getAdapter()).getHiddenClients());
                break;
            }
            case NAVIGATION_BACK: {
                this.mOnPanelLevelChangeListener.changeLevel(CombinedHistoryPanel.OnPanelLevelChangeListener.PanelLevel.PARENT);
                break;
            }
            case CHILD: 
            case HISTORY: {
                if (this.mOnUrlOpenListener == null) break;
                TwoLinePageRow twoLinePageRow = (TwoLinePageRow)view;
                Telemetry.sendUIEvent(TelemetryContract.Event.LOAD_URL, TelemetryContract.Method.LIST_ITEM, "history");
                this.mOnUrlOpenListener.onUrlOpen(twoLinePageRow.getUrl(), EnumSet.of(HomePager.OnUrlOpenListener.Flags.ALLOW_SWITCH_TO_TAB));
                break;
            }
            case CLOSED_TAB: {
                String string2 = ((RecentTabsAdapter)this.getAdapter()).restoreTabFromPosition(n);
                Telemetry.sendUIEvent(TelemetryContract.Event.LOAD_URL, TelemetryContract.Method.LIST_ITEM, string2);
            }
        }
    }

    @Override
    public boolean onItemLongClicked(RecyclerView recyclerView, int n, View view) {
        this.mContextMenuInfo = ((AdapterContextMenuBuilder)this.getAdapter()).makeContextMenuInfoFromPosition(view, n);
        return this.showContextMenuForChild((View)this);
    }

    public HomeContextMenuInfo getContextMenuInfo() {
        return this.mContextMenuInfo;
    }

    protected static interface AdapterContextMenuBuilder {
        public HomeContextMenuInfo makeContextMenuInfoFromPosition(View var1, int var2);
    }
}

