/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.home;

import android.content.Context;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentStatePagerAdapter;
import android.view.ViewGroup;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mozilla.gecko.home.HomeConfig;
import org.mozilla.gecko.home.HomeFragment;

public class HomeAdapter
extends FragmentStatePagerAdapter {
    private final Context mContext;
    private final ArrayList<PanelInfo> mPanelInfos;
    private final Map<String, HomeFragment> mPanels;
    private final Map<String, Bundle> mRestoreBundles;
    private boolean mCanLoadHint;
    private OnAddPanelListener mAddPanelListener;
    private HomeFragment.PanelStateChangeListener mPanelStateChangeListener = null;

    public void setPanelStateChangeListener(HomeFragment.PanelStateChangeListener panelStateChangeListener) {
        this.mPanelStateChangeListener = panelStateChangeListener;
        for (Fragment fragment : this.mPanels.values()) {
            ((HomeFragment)fragment).setPanelStateChangeListener(panelStateChangeListener);
        }
    }

    public HomeAdapter(Context context, FragmentManager fragmentManager) {
        super(fragmentManager);
        this.mContext = context;
        this.mCanLoadHint = false;
        this.mPanelInfos = new ArrayList();
        this.mPanels = new HashMap<String, HomeFragment>();
        this.mRestoreBundles = new HashMap<String, Bundle>();
    }

    public int getCount() {
        return this.mPanelInfos.size();
    }

    public Fragment getItem(int n) {
        PanelInfo panelInfo = this.mPanelInfos.get(n);
        return Fragment.instantiate((Context)this.mContext, (String)panelInfo.getClassName(), (Bundle)panelInfo.getArgs());
    }

    public CharSequence getPageTitle(int n) {
        if (this.mPanelInfos.size() > 0) {
            PanelInfo panelInfo = this.mPanelInfos.get(n);
            return panelInfo.getTitle().toUpperCase();
        }
        return null;
    }

    public Object instantiateItem(ViewGroup viewGroup, int n) {
        HomeFragment homeFragment = (HomeFragment)((Object)super.instantiateItem(viewGroup, n));
        homeFragment.setPanelStateChangeListener(this.mPanelStateChangeListener);
        String string2 = this.mPanelInfos.get(n).getId();
        this.mPanels.put(string2, homeFragment);
        if (this.mRestoreBundles.containsKey(string2)) {
            homeFragment.restoreData(this.mRestoreBundles.get(string2));
            this.mRestoreBundles.remove(string2);
        }
        return homeFragment;
    }

    public void setRestoreData(int n, Bundle bundle) {
        String string2 = this.mPanelInfos.get(n).getId();
        HomeFragment homeFragment = this.mPanels.get(string2);
        if (homeFragment != null) {
            homeFragment.restoreData(bundle);
        } else {
            this.mRestoreBundles.put(string2, bundle);
        }
    }

    public void destroyItem(ViewGroup viewGroup, int n, Object object) {
        String string2 = this.mPanelInfos.get(n).getId();
        super.destroyItem(viewGroup, n, object);
        this.mPanels.remove(string2);
    }

    public void setOnAddPanelListener(OnAddPanelListener onAddPanelListener) {
        this.mAddPanelListener = onAddPanelListener;
    }

    public int getItemPosition(String string2) {
        for (int i = 0; i < this.mPanelInfos.size(); ++i) {
            String string3 = this.mPanelInfos.get(i).getId();
            if (!string3.equals(string2)) continue;
            return i;
        }
        return -1;
    }

    public String getPanelIdAtPosition(int n) {
        if (this.mPanelInfos.isEmpty()) {
            return null;
        }
        return this.mPanelInfos.get(n).getId();
    }

    private void addPanel(PanelInfo panelInfo) {
        this.mPanelInfos.add(panelInfo);
        if (this.mAddPanelListener != null) {
            this.mAddPanelListener.onAddPanel(panelInfo.getTitle());
        }
    }

    public void update(List<HomeConfig.PanelConfig> list) {
        this.mPanels.clear();
        this.mPanelInfos.clear();
        if (list != null) {
            for (HomeConfig.PanelConfig panelConfig : list) {
                PanelInfo panelInfo = new PanelInfo(panelConfig);
                this.addPanel(panelInfo);
            }
        }
        this.notifyDataSetChanged();
    }

    public boolean getCanLoadHint() {
        return this.mCanLoadHint;
    }

    public void setCanLoadHint(boolean bl) {
        this.mCanLoadHint = bl;
        for (Fragment fragment : this.mPanels.values()) {
            HomeFragment homeFragment = (HomeFragment)fragment;
            homeFragment.setCanLoadHint(bl);
        }
    }

    private final class PanelInfo {
        private final HomeConfig.PanelConfig mPanelConfig;

        PanelInfo(HomeConfig.PanelConfig panelConfig) {
            this.mPanelConfig = panelConfig;
        }

        public String getId() {
            return this.mPanelConfig.getId();
        }

        public String getTitle() {
            return this.mPanelConfig.getTitle();
        }

        public String getClassName() {
            HomeConfig.PanelType panelType = this.mPanelConfig.getType();
            return panelType.getPanelClass().getName();
        }

        public Bundle getArgs() {
            Bundle bundle = new Bundle();
            bundle.putBoolean("canLoad", HomeAdapter.this.mCanLoadHint);
            if (this.mPanelConfig.isDynamic()) {
                bundle.putParcelable("panelConfig", (Parcelable)this.mPanelConfig);
            }
            return bundle;
        }
    }

    public static interface OnAddPanelListener {
        public void onAddPanel(String var1);
    }
}

