/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.home;

import android.content.Context;
import android.database.Cursor;
import android.graphics.Color;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import org.mozilla.gecko.R;
import org.mozilla.gecko.home.HomeConfig;
import org.mozilla.gecko.home.ImageLoader;

class PanelItemView
extends LinearLayout {
    private final TextView titleView;
    private final TextView descriptionView;
    private final ImageView imageView;
    private final LinearLayout titleDescContainerView;
    private final ImageView backgroundView;

    private PanelItemView(Context context, int n) {
        super(context);
        LayoutInflater.from((Context)context).inflate(n, (ViewGroup)this);
        this.titleView = (TextView)this.findViewById(R.id.title);
        this.descriptionView = (TextView)this.findViewById(R.id.description);
        this.imageView = (ImageView)this.findViewById(R.id.image);
        this.backgroundView = (ImageView)this.findViewById(R.id.background);
        this.titleDescContainerView = (LinearLayout)this.findViewById(R.id.title_desc_container);
    }

    public void updateFromCursor(Cursor cursor) {
        int n;
        String string2;
        int n2;
        int n3;
        String string3;
        int n4;
        String string4;
        boolean bl;
        int n5 = cursor.getColumnIndexOrThrow("title");
        String string5 = cursor.getString(n5);
        boolean bl2 = !TextUtils.isEmpty((CharSequence)string5);
        this.titleView.setVisibility(bl2 ? 0 : 8);
        if (bl2) {
            this.titleView.setText((CharSequence)string5);
        }
        boolean bl3 = bl = !TextUtils.isEmpty((CharSequence)(string4 = cursor.getString(n4 = cursor.getColumnIndexOrThrow("description"))));
        if (this.descriptionView != null) {
            this.descriptionView.setVisibility(bl ? 0 : 8);
            if (bl) {
                this.descriptionView.setText((CharSequence)string4);
            }
        }
        if (this.titleDescContainerView != null) {
            this.titleDescContainerView.setVisibility(bl2 || bl ? 0 : 8);
        }
        boolean bl4 = !TextUtils.isEmpty((CharSequence)(string3 = cursor.getString(n3 = cursor.getColumnIndexOrThrow("image_url"))));
        this.imageView.setVisibility(bl4 ? 0 : 8);
        if (bl4) {
            ImageLoader.with(this.getContext()).load(string3).into(this.imageView);
        }
        if ((n2 = cursor.getColumnIndex("background_color")) != -1 && !TextUtils.isEmpty((CharSequence)(string2 = cursor.getString(n2)))) {
            this.setBackgroundColor(Color.parseColor((String)string2));
        }
        if ((n = cursor.getColumnIndex("background_url")) != -1) {
            String string6 = cursor.getString(n);
            if (this.backgroundView != null && !TextUtils.isEmpty((CharSequence)string6)) {
                ImageLoader.with(this.getContext()).load(string6).fit().into(this.backgroundView);
            }
        }
    }

    public static PanelItemView create(Context context, HomeConfig.ItemType itemType) {
        switch (itemType) {
            case ARTICLE: {
                return new ArticleItemView(context);
            }
            case IMAGE: {
                return new ImageItemView(context);
            }
            case ICON: {
                return new IconItemView(context);
            }
        }
        throw new IllegalArgumentException("Could not create panel item view from " + (Object)((Object)itemType));
    }

    private static class IconItemView
    extends PanelItemView {
        private IconItemView(Context context) {
            super(context, R.layout.panel_icon_item);
        }
    }

    private static class ImageItemView
    extends PanelItemView {
        private ImageItemView(Context context) {
            super(context, R.layout.panel_image_item);
            this.setOrientation(1);
        }
    }

    private static class ArticleItemView
    extends PanelItemView {
        private ArticleItemView(Context context) {
            super(context, R.layout.panel_article_item);
            this.setOrientation(0);
        }
    }
}

