/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.push;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import org.mozilla.gecko.push.RegisterUserAgentResponse;
import org.mozilla.gecko.push.SubscribeChannelResponse;
import org.mozilla.gecko.push.autopush.AutopushClient;
import org.mozilla.gecko.push.autopush.AutopushClientException;
import org.mozilla.gecko.sync.Utils;

public class PushClient {
    private final AutopushClient autopushClient;

    public PushClient(String string2) {
        this.autopushClient = new AutopushClient(string2, Utils.newSynchronousExecutor());
    }

    public RegisterUserAgentResponse registerUserAgent(@NonNull String string2) throws LocalException, AutopushClientException {
        Delegate delegate = new Delegate();
        this.autopushClient.registerUserAgent(string2, delegate);
        return (RegisterUserAgentResponse)delegate.responseOrThrow();
    }

    public void reregisterUserAgent(@NonNull String string2, @NonNull String string3, @NonNull String string4) throws LocalException, AutopushClientException {
        Delegate delegate = new Delegate();
        this.autopushClient.reregisterUserAgent(string2, string3, string4, delegate);
        delegate.responseOrThrow();
    }

    public void unregisterUserAgent(@NonNull String string2, @NonNull String string3) throws LocalException, AutopushClientException {
        Delegate delegate = new Delegate();
        this.autopushClient.unregisterUserAgent(string2, string3, delegate);
        delegate.responseOrThrow();
    }

    public SubscribeChannelResponse subscribeChannel(@NonNull String string2, @NonNull String string3, @Nullable String string4) throws LocalException, AutopushClientException {
        Delegate delegate = new Delegate();
        this.autopushClient.subscribeChannel(string2, string3, string4, delegate);
        return (SubscribeChannelResponse)delegate.responseOrThrow();
    }

    public void unsubscribeChannel(@NonNull String string2, @NonNull String string3, @NonNull String string4) throws LocalException, AutopushClientException {
        Delegate delegate = new Delegate();
        this.autopushClient.unsubscribeChannel(string2, string3, string4, delegate);
        delegate.responseOrThrow();
    }

    protected static class Delegate<T>
    implements AutopushClient.RequestDelegate<T> {
        Object result;

        protected Delegate() {
        }

        public T responseOrThrow() throws LocalException, AutopushClientException {
            if (this.result instanceof LocalException) {
                throw (LocalException)this.result;
            }
            if (this.result instanceof AutopushClientException) {
                throw (AutopushClientException)this.result;
            }
            return (T)this.result;
        }

        public void handleError(Exception exception) {
            if (this.result == null) {
                this.result = new LocalException(exception);
            }
        }

        public void handleFailure(AutopushClientException autopushClientException) {
            if (this.result == null) {
                this.result = autopushClientException;
            }
        }

        public void handleSuccess(T t) {
            if (this.result == null) {
                this.result = t;
            }
        }
    }

    public static class LocalException
    extends Exception {
        private static final long serialVersionUID = 2387554736L;

        public LocalException(Throwable throwable) {
            super(throwable);
        }
    }
}

