/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.push;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONObject;
import org.mozilla.gecko.gcm.GcmTokenClient;
import org.mozilla.gecko.push.Fetched;
import org.mozilla.gecko.push.PushClient;
import org.mozilla.gecko.push.PushRegistration;
import org.mozilla.gecko.push.PushState;
import org.mozilla.gecko.push.PushSubscription;
import org.mozilla.gecko.push.RegisterUserAgentResponse;
import org.mozilla.gecko.push.SubscribeChannelResponse;
import org.mozilla.gecko.push.autopush.AutopushClientException;
import org.mozilla.gecko.util.ThreadUtils;

public class PushManager {
    public static final long TIME_BETWEEN_AUTOPUSH_UAID_REGISTRATION_IN_MILLIS = 604800000L;
    private static final String LOG_TAG = "GeckoPushManager";
    @NonNull
    protected final PushState state;
    @NonNull
    protected final GcmTokenClient gcmClient;
    @NonNull
    protected final PushClientFactory pushClientFactory;

    public PushManager(@NonNull PushState pushState, @NonNull GcmTokenClient gcmTokenClient, @NonNull PushClientFactory pushClientFactory) {
        this.state = pushState;
        this.gcmClient = gcmTokenClient;
        this.pushClientFactory = pushClientFactory;
    }

    public PushRegistration registrationForSubscription(String string2) {
        for (Map.Entry<String, PushRegistration> entry : this.state.getRegistrations().entrySet()) {
            PushSubscription pushSubscription = entry.getValue().getSubscription(string2);
            if (pushSubscription == null) continue;
            return entry.getValue();
        }
        return null;
    }

    public Map<String, PushSubscription> allSubscriptionsForProfile(String string2) {
        PushRegistration pushRegistration = this.state.getRegistration(string2);
        if (pushRegistration == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(pushRegistration.subscriptions);
    }

    public PushRegistration registerUserAgent(@NonNull String string2, long l) throws ProfileNeedsConfigurationException, AutopushClientException, PushClient.LocalException, GcmTokenClient.NeedsGooglePlayServicesException, IOException {
        Log.i((String)LOG_TAG, (String)("Registering user agent for profile named: " + string2));
        return this.advanceRegistration(string2, l);
    }

    public PushRegistration unregisterUserAgent(@NonNull String string2, long l) throws ProfileNeedsConfigurationException {
        Log.i((String)LOG_TAG, (String)("Unregistering user agent for profile named: " + string2));
        PushRegistration pushRegistration = this.state.getRegistration(string2);
        if (pushRegistration == null) {
            Log.w((String)LOG_TAG, (String)("Cannot find registration corresponding to subscription; not unregistering remote uaid for profileName: " + string2));
            return null;
        }
        String string3 = pushRegistration.uaid.value;
        String string4 = pushRegistration.secret;
        if (string3 == null || string4 == null) {
            Log.e((String)LOG_TAG, (String)"Cannot unregisterUserAgent with null registration uaid or secret!");
            return null;
        }
        this.unregisterUserAgentOnBackgroundThread(pushRegistration);
        return pushRegistration;
    }

    public PushSubscription subscribeChannel(@NonNull String string2, @NonNull String string3, @NonNull JSONObject jSONObject, @Nullable String string4, long l) throws ProfileNeedsConfigurationException, AutopushClientException, PushClient.LocalException, GcmTokenClient.NeedsGooglePlayServicesException, IOException {
        Log.i((String)LOG_TAG, (String)("Subscribing to channel for service: " + string3 + "; for profile named: " + string2));
        PushRegistration pushRegistration = this.advanceRegistration(string2, l);
        PushSubscription pushSubscription = this.subscribeChannel(pushRegistration, string2, string3, jSONObject, string4, System.currentTimeMillis());
        return pushSubscription;
    }

    protected PushSubscription subscribeChannel(@NonNull PushRegistration pushRegistration, @NonNull String string2, @NonNull String string3, @NonNull JSONObject jSONObject, @Nullable String string4, long l) throws AutopushClientException, PushClient.LocalException {
        String string5 = pushRegistration.uaid.value;
        String string6 = pushRegistration.secret;
        if (string5 == null || string6 == null) {
            throw new IllegalStateException("Cannot subscribeChannel with null uaid or secret!");
        }
        PushClient pushClient = this.pushClientFactory.getPushClient(pushRegistration.autopushEndpoint, pushRegistration.debug);
        SubscribeChannelResponse subscribeChannelResponse = pushClient.subscribeChannel(string5, string6, string4);
        if (pushRegistration.debug) {
            Log.i((String)LOG_TAG, (String)("Got chid: " + subscribeChannelResponse.channelID + " and endpoint: " + subscribeChannelResponse.endpoint));
        } else {
            Log.i((String)LOG_TAG, (String)"Got chid and endpoint.");
        }
        PushSubscription pushSubscription = new PushSubscription(subscribeChannelResponse.channelID, string2, subscribeChannelResponse.endpoint, string3, jSONObject);
        pushRegistration.putSubscription(subscribeChannelResponse.channelID, pushSubscription);
        this.state.checkpoint();
        return pushSubscription;
    }

    public PushSubscription unsubscribeChannel(final @NonNull String string2) {
        Log.i((String)LOG_TAG, (String)("Unsubscribing from channel with chid: " + string2));
        final PushRegistration pushRegistration = this.registrationForSubscription(string2);
        if (pushRegistration == null) {
            Log.w((String)LOG_TAG, (String)("Cannot find registration corresponding to subscription; not unregistering remote subscription: " + string2));
            return null;
        }
        PushSubscription pushSubscription = pushRegistration.removeSubscription(string2);
        this.state.checkpoint();
        if (pushSubscription == null) {
            Log.e((String)LOG_TAG, (String)("Subscription did not exist: " + string2));
            return null;
        }
        String string3 = pushRegistration.uaid.value;
        String string4 = pushRegistration.secret;
        if (string3 == null || string4 == null) {
            Log.e((String)LOG_TAG, (String)"Cannot unsubscribeChannel with null registration uaid or secret!");
            return null;
        }
        final PushClient pushClient = this.pushClientFactory.getPushClient(pushRegistration.autopushEndpoint, pushRegistration.debug);
        ThreadUtils.postToBackgroundThread((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    pushClient.unsubscribeChannel(pushRegistration.uaid.value, pushRegistration.secret, string2);
                    Log.i((String)PushManager.LOG_TAG, (String)("Unsubscribed from channel with chid: " + string2));
                }
                catch (PushClient.LocalException | AutopushClientException throwable) {
                    Log.w((String)PushManager.LOG_TAG, (String)("Failed to unsubscribe from channel with chid; ignoring: " + string2), (Throwable)throwable);
                }
            }
        });
        return pushSubscription;
    }

    public PushRegistration configure(@NonNull String string2, @NonNull String string3, boolean bl, long l) {
        PushRegistration pushRegistration;
        Log.i((String)LOG_TAG, (String)"Updating configuration.");
        PushRegistration pushRegistration2 = this.state.getRegistration(string2);
        if (pushRegistration2 != null) {
            if (!string3.equals(pushRegistration2.autopushEndpoint)) {
                if (bl) {
                    Log.i((String)LOG_TAG, (String)("Push configuration autopushEndpoint changed! Was: " + pushRegistration2.autopushEndpoint + "; now: " + string3));
                } else {
                    Log.i((String)LOG_TAG, (String)"Push configuration autopushEndpoint changed!");
                }
                pushRegistration = new PushRegistration(string3, bl, Fetched.now(null), null);
                if (pushRegistration2.uaid.value != null) {
                    this.unregisterUserAgentOnBackgroundThread(pushRegistration2);
                }
            } else if (bl != pushRegistration2.debug) {
                Log.i((String)LOG_TAG, (String)("Push configuration debug changed: " + bl));
                pushRegistration = pushRegistration2.withDebug(bl);
            } else {
                pushRegistration = pushRegistration2;
            }
        } else {
            if (bl) {
                Log.i((String)LOG_TAG, (String)("Push configuration set: " + string3 + "; debug: " + bl));
            } else {
                Log.i((String)LOG_TAG, (String)"Push configuration set!");
            }
            pushRegistration = new PushRegistration(string3, bl, new Fetched(null, l), null);
        }
        if (pushRegistration != pushRegistration2) {
            this.state.putRegistration(string2, pushRegistration);
            this.state.checkpoint();
        }
        return pushRegistration;
    }

    private void unregisterUserAgentOnBackgroundThread(final PushRegistration pushRegistration) {
        ThreadUtils.postToBackgroundThread((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    PushManager.this.pushClientFactory.getPushClient(pushRegistration.autopushEndpoint, pushRegistration.debug).unregisterUserAgent(pushRegistration.uaid.value, pushRegistration.secret);
                    Log.i((String)PushManager.LOG_TAG, (String)("Unregistered user agent with uaid: " + pushRegistration.uaid.value));
                }
                catch (PushClient.LocalException | AutopushClientException throwable) {
                    Log.w((String)PushManager.LOG_TAG, (String)("Failed to unregister user agent with uaid; ignoring: " + pushRegistration.uaid.value), (Throwable)throwable);
                }
            }
        });
    }

    @NonNull
    protected PushRegistration advanceRegistration(@NonNull String string2, long l) throws ProfileNeedsConfigurationException, AutopushClientException, PushClient.LocalException, GcmTokenClient.NeedsGooglePlayServicesException, IOException {
        PushRegistration pushRegistration = this.state.getRegistration(string2);
        if (pushRegistration == null || pushRegistration.autopushEndpoint == null) {
            Log.i((String)LOG_TAG, (String)"Cannot advance to registered: registration needs configuration.");
            throw new ProfileNeedsConfigurationException();
        }
        return this.advanceRegistration(pushRegistration, string2, l);
    }

    @NonNull
    protected PushRegistration advanceRegistration(PushRegistration pushRegistration, @NonNull String string2, long l) throws AutopushClientException, PushClient.LocalException, GcmTokenClient.NeedsGooglePlayServicesException, IOException {
        Fetched fetched = this.gcmClient.getToken("829133274407", pushRegistration.debug);
        PushClient pushClient = this.pushClientFactory.getPushClient(pushRegistration.autopushEndpoint, pushRegistration.debug);
        if (pushRegistration.uaid.value == null) {
            if (pushRegistration.debug) {
                Log.i((String)LOG_TAG, (String)("No uaid; requesting from autopush endpoint: " + pushRegistration.autopushEndpoint));
            } else {
                Log.i((String)LOG_TAG, (String)"No uaid: requesting from autopush endpoint.");
            }
            RegisterUserAgentResponse registerUserAgentResponse = pushClient.registerUserAgent(fetched.value);
            if (pushRegistration.debug) {
                Log.i((String)LOG_TAG, (String)("Got uaid: " + registerUserAgentResponse.uaid + " and secret: " + registerUserAgentResponse.secret));
            } else {
                Log.i((String)LOG_TAG, (String)"Got uaid and secret.");
            }
            long l2 = System.currentTimeMillis();
            PushRegistration pushRegistration2 = pushRegistration.withUserAgentID(registerUserAgentResponse.uaid, registerUserAgentResponse.secret, l2);
            this.state.putRegistration(string2, pushRegistration2);
            this.state.checkpoint();
            return this.advanceRegistration(pushRegistration2, string2, l2);
        }
        if (pushRegistration.uaid.timestamp + 604800000L < l || pushRegistration.uaid.timestamp < fetched.timestamp) {
            if (pushRegistration.debug) {
                Log.i((String)LOG_TAG, (String)("Stale uaid; re-registering with autopush endpoint: " + pushRegistration.autopushEndpoint));
            } else {
                Log.i((String)LOG_TAG, (String)"Stale uaid: re-registering with autopush endpoint.");
            }
            pushClient.reregisterUserAgent(pushRegistration.uaid.value, pushRegistration.secret, fetched.value);
            Log.i((String)LOG_TAG, (String)"Re-registered uaid and secret.");
            long l3 = System.currentTimeMillis();
            PushRegistration pushRegistration3 = pushRegistration.withUserAgentID(pushRegistration.uaid.value, pushRegistration.secret, l3);
            this.state.putRegistration(string2, pushRegistration3);
            this.state.checkpoint();
            return this.advanceRegistration(pushRegistration3, string2, l3);
        }
        Log.d((String)LOG_TAG, (String)"Existing uaid is fresh; no need to request from autopush endpoint.");
        return pushRegistration;
    }

    public void invalidateGcmToken() {
        this.gcmClient.invalidateToken();
    }

    public void startup(long l) {
        try {
            Log.i((String)LOG_TAG, (String)"Startup: requesting GCM token.");
            this.gcmClient.getToken("829133274407", false);
        }
        catch (GcmTokenClient.NeedsGooglePlayServicesException needsGooglePlayServicesException) {
            Log.w((String)LOG_TAG, (String)"Startup: needs Google Play Services.  Ignoring until GCM is requested in response to user activity.");
            return;
        }
        catch (IOException iOException) {
            Log.w((String)LOG_TAG, (String)"Startup: Google Play Services is available, but we can't get a token; ignoring.", (Throwable)iOException);
            return;
        }
        Log.i((String)LOG_TAG, (String)"Startup: advancing all registrations.");
        Map<String, PushRegistration> map = this.state.getRegistrations();
        try {
            Iterator<Map.Entry<String, PushRegistration>> iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, PushRegistration> entry = iterator.next();
                String string2 = entry.getKey();
                PushRegistration pushRegistration = entry.getValue();
                if (pushRegistration.subscriptions.isEmpty()) {
                    Log.i((String)LOG_TAG, (String)("Startup: no subscriptions for profileName; not advancing registration: " + string2));
                    continue;
                }
                try {
                    this.advanceRegistration(string2, l);
                    Log.i((String)LOG_TAG, (String)("Startup: advanced registration for profileName: " + string2));
                }
                catch (ProfileNeedsConfigurationException profileNeedsConfigurationException) {
                    Log.i((String)LOG_TAG, (String)("Startup: cannot advance registration for profileName: " + string2 + "; profile needs configuration from Gecko."));
                }
                catch (AutopushClientException autopushClientException) {
                    if (autopushClientException.isTransientError()) {
                        Log.w((String)LOG_TAG, (String)("Startup: cannot advance registration for profileName: " + string2 + "; got transient autopush error.  Ignoring; will advance on demand."), (Throwable)autopushClientException);
                        continue;
                    }
                    Log.w((String)LOG_TAG, (String)("Startup: cannot advance registration for profileName: " + string2 + "; got permanent autopush error.  Removing registration entirely."), (Throwable)autopushClientException);
                    iterator.remove();
                }
                catch (PushClient.LocalException localException) {
                    Log.w((String)LOG_TAG, (String)("Startup: cannot advance registration for profileName: " + string2 + "; got local exception.  Ignoring; will advance on demand."), (Throwable)localException);
                }
            }
        }
        catch (GcmTokenClient.NeedsGooglePlayServicesException needsGooglePlayServicesException) {
            Log.w((String)LOG_TAG, (String)"Startup: cannot advance any registrations; need Google Play Services!", (Throwable)needsGooglePlayServicesException);
            return;
        }
        catch (IOException iOException) {
            Log.w((String)LOG_TAG, (String)"Startup: cannot advance any registrations; intermittent Google Play Services exception; ignoring, will advance on demand.", (Throwable)iOException);
            return;
        }
        this.state.checkpoint();
    }

    public static interface PushClientFactory {
        public PushClient getPushClient(String var1, boolean var2);
    }

    public static class ProfileNeedsConfigurationException
    extends Exception {
        private static final long serialVersionUID = 3326738888L;
    }
}

