/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.telemetry;

import android.content.Context;
import android.content.SharedPreferences;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import android.util.Log;
import java.io.IOException;
import org.mozilla.gecko.BrowserApp;
import org.mozilla.gecko.GeckoProfile;
import org.mozilla.gecko.GeckoSharedPrefs;
import org.mozilla.gecko.delegates.BrowserAppDelegateWithReference;
import org.mozilla.gecko.search.SearchEngine;
import org.mozilla.gecko.search.SearchEngineManager;
import org.mozilla.gecko.sync.ExtendedJSONObject;
import org.mozilla.gecko.telemetry.TelemetryDispatcher;
import org.mozilla.gecko.telemetry.TelemetryUploadService;
import org.mozilla.gecko.telemetry.measurements.SearchCountMeasurements;
import org.mozilla.gecko.telemetry.measurements.SessionMeasurements;
import org.mozilla.gecko.telemetry.pingbuilders.TelemetryCorePingBuilder;
import org.mozilla.gecko.util.StringUtils;
import org.mozilla.gecko.util.ThreadUtils;

public class TelemetryCorePingDelegate
extends BrowserAppDelegateWithReference
implements SearchEngineManager.SearchEngineCallback {
    private static final String LOGTAG = StringUtils.safeSubstring((String)("Gecko" + TelemetryCorePingDelegate.class.getSimpleName()), (int)0, (int)23);
    private static final String PREF_IS_FIRST_RUN = "telemetry-isFirstRun";
    private TelemetryDispatcher telemetryDispatcher;
    private final SessionMeasurements sessionMeasurements = new SessionMeasurements();

    @Override
    public void onStart(BrowserApp browserApp) {
        this.uploadPing(browserApp);
    }

    @Override
    public void onStop(BrowserApp browserApp) {
        SharedPreferences sharedPreferences = this.getSharedPreferences(browserApp);
        if (sharedPreferences.getBoolean(PREF_IS_FIRST_RUN, true)) {
            sharedPreferences.edit().putBoolean(PREF_IS_FIRST_RUN, false).apply();
            this.uploadPing(browserApp);
        }
    }

    private void uploadPing(BrowserApp browserApp) {
        SearchEngineManager searchEngineManager = browserApp.getSearchEngineManager();
        searchEngineManager.getEngine(this);
    }

    @Override
    public void onResume(BrowserApp browserApp) {
        this.sessionMeasurements.recordSessionStart();
    }

    @Override
    public void onPause(BrowserApp browserApp) {
        this.sessionMeasurements.recordSessionEnd((Context)browserApp);
    }

    @WorkerThread
    private TelemetryDispatcher getTelemetryDispatcher(BrowserApp browserApp) {
        if (this.telemetryDispatcher == null) {
            String string2 = browserApp.getProfile().getDir().getAbsolutePath();
            this.telemetryDispatcher = new TelemetryDispatcher(string2);
        }
        return this.telemetryDispatcher;
    }

    private SharedPreferences getSharedPreferences(BrowserApp browserApp) {
        return GeckoSharedPrefs.forProfileName((Context)browserApp, browserApp.getProfile().getName());
    }

    @Override
    public void execute(final @Nullable SearchEngine searchEngine) {
        if (this.getBrowserApp() == null) {
            return;
        }
        ThreadUtils.postToBackgroundThread((Runnable)new Runnable(){

            @Override
            @WorkerThread
            public void run() {
                String string2;
                BrowserApp browserApp = TelemetryCorePingDelegate.this.getBrowserApp();
                if (browserApp == null) {
                    return;
                }
                GeckoProfile geckoProfile = browserApp.getProfile();
                if (!TelemetryUploadService.isUploadEnabledByProfileConfig((Context)browserApp, geckoProfile)) {
                    Log.d((String)LOGTAG, (String)"Core ping upload disabled by profile config. Returning.");
                    return;
                }
                try {
                    string2 = geckoProfile.getClientId();
                }
                catch (IOException iOException) {
                    Log.w((String)LOGTAG, (String)("Unable to get client ID to generate core ping: " + iOException));
                    return;
                }
                SharedPreferences sharedPreferences = TelemetryCorePingDelegate.this.getSharedPreferences(browserApp);
                SessionMeasurements.SessionMeasurementsContainer sessionMeasurementsContainer = TelemetryCorePingDelegate.this.sessionMeasurements.getAndResetSessionMeasurements((Context)browserApp);
                TelemetryCorePingBuilder telemetryCorePingBuilder = new TelemetryCorePingBuilder((Context)browserApp).setClientID(string2).setDefaultSearchEngine(TelemetryCorePingBuilder.getEngineIdentifier(searchEngine)).setProfileCreationDate(TelemetryCorePingBuilder.getProfileCreationDate((Context)browserApp, geckoProfile)).setSequenceNumber(TelemetryCorePingBuilder.getAndIncrementSequenceNumber(sharedPreferences)).setSessionCount(sessionMeasurementsContainer.sessionCount).setSessionDuration(sessionMeasurementsContainer.elapsedSeconds);
                TelemetryCorePingDelegate.this.maybeSetOptionalMeasurements(sharedPreferences, telemetryCorePingBuilder);
                TelemetryCorePingDelegate.this.getTelemetryDispatcher(browserApp).queuePingForUpload((Context)browserApp, telemetryCorePingBuilder);
            }
        });
    }

    private void maybeSetOptionalMeasurements(SharedPreferences sharedPreferences, TelemetryCorePingBuilder telemetryCorePingBuilder) {
        ExtendedJSONObject extendedJSONObject;
        String string2 = sharedPreferences.getString("distribution.id", null);
        if (string2 != null) {
            telemetryCorePingBuilder.setOptDistributionID(string2);
        }
        if ((extendedJSONObject = SearchCountMeasurements.getAndZeroSearch(sharedPreferences)).size() > 0) {
            telemetryCorePingBuilder.setOptSearchCounts(extendedJSONObject);
        }
    }
}

