/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.toolbar;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.AnimationSet;
import android.widget.ViewSwitcher;
import org.mozilla.gecko.AppConstants;
import org.mozilla.gecko.R;
import org.mozilla.gecko.animation.Rotate3DAnimation;
import org.mozilla.gecko.widget.themed.ThemedTextSwitcher;

public class TabCounter
extends ThemedTextSwitcher
implements ViewSwitcher.ViewFactory {
    private static final float CENTER_X = 0.5f;
    private static final float CENTER_Y = 1.25f;
    private static final int DURATION = 500;
    private static final float Z_DISTANCE = 200.0f;
    private final AnimationSet mFlipInForward;
    private final AnimationSet mFlipInBackward;
    private final AnimationSet mFlipOutForward;
    private final AnimationSet mFlipOutBackward;
    private final LayoutInflater mInflater;
    private final int mLayoutId;
    private int mCount;
    public static final int MAX_VISIBLE_TABS = 99;
    public static final String SO_MANY_TABS_OPEN = "\u221e";

    public TabCounter(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.TabCounter);
        this.mLayoutId = typedArray.getResourceId(R.styleable.TabCounter_android_layout, R.layout.tabs_counter);
        typedArray.recycle();
        this.mInflater = LayoutInflater.from((Context)context);
        this.mFlipInForward = this.createAnimation(-90.0f, 0.0f, FadeMode.FADE_IN, -200.0f, false);
        this.mFlipInBackward = this.createAnimation(90.0f, 0.0f, FadeMode.FADE_IN, 200.0f, false);
        this.mFlipOutForward = this.createAnimation(0.0f, -90.0f, FadeMode.FADE_OUT, -200.0f, true);
        this.mFlipOutBackward = this.createAnimation(0.0f, 90.0f, FadeMode.FADE_OUT, 200.0f, true);
        this.removeAllViews();
        this.setFactory(this);
        if (AppConstants.Versions.feature16Plus) {
            this.setImportantForAccessibility(1);
            this.setAccessibilityDelegate(new View.AccessibilityDelegate(){

                public void onInitializeAccessibilityNodeInfo(View view, AccessibilityNodeInfo accessibilityNodeInfo) {
                }
            });
        }
    }

    void setCountWithAnimation(int n) {
        if (this.mCount == 0) {
            this.setCount(n);
            return;
        }
        if (this.mCount == n) {
            return;
        }
        if (this.mCount > 99 && n > 99) {
            this.mCount = n;
            return;
        }
        if (n < this.mCount) {
            this.setInAnimation((Animation)this.mFlipInBackward);
            this.setOutAnimation((Animation)this.mFlipOutForward);
        } else {
            this.setInAnimation((Animation)this.mFlipInForward);
            this.setOutAnimation((Animation)this.mFlipOutBackward);
        }
        this.setDisplayedChild(0);
        this.setCurrentText(this.formatForDisplay(this.mCount));
        this.setText(this.formatForDisplay(n));
        this.mCount = n;
    }

    private String formatForDisplay(int n) {
        if (n > 99) {
            return SO_MANY_TABS_OPEN;
        }
        return String.valueOf(n);
    }

    void setCount(int n) {
        this.setCurrentText(this.formatForDisplay(n));
        this.mCount = n;
    }

    void onEnterEditingMode() {
        int n = this.getChildCount();
        for (int i = 0; i < n; ++i) {
            this.getChildAt(i).clearAnimation();
        }
    }

    private AnimationSet createAnimation(float f, float f2, FadeMode fadeMode, float f3, boolean bl) {
        Context context = this.getContext();
        AnimationSet animationSet = new AnimationSet(context, null);
        animationSet.addAnimation((Animation)new Rotate3DAnimation(f, f2, 0.5f, 1.25f, f3, bl));
        animationSet.addAnimation((Animation)(fadeMode == FadeMode.FADE_IN ? new AlphaAnimation(0.0f, 1.0f) : new AlphaAnimation(1.0f, 0.0f)));
        animationSet.setDuration(500L);
        animationSet.setInterpolator(context, 17432581);
        return animationSet;
    }

    public View makeView() {
        return this.mInflater.inflate(this.mLayoutId, null);
    }

    private static enum FadeMode {
        FADE_IN,
        FADE_OUT;

    }
}

