/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.updater;

import android.content.Context;
import android.content.SharedPreferences;
import android.util.Log;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.mozilla.gecko.BrowserApp;
import org.mozilla.gecko.GeckoSharedPrefs;
import org.mozilla.gecko.delegates.BrowserAppDelegateWithReference;
import org.mozilla.gecko.util.ThreadUtils;

public class PostUpdateHandler
extends BrowserAppDelegateWithReference {
    private static final String LOGTAG = "PostUpdateHandler";

    @Override
    public void onStart(BrowserApp browserApp) {
        SharedPreferences sharedPreferences = GeckoSharedPrefs.forApp((Context)browserApp);
        if (!"20160610030239".equals(sharedPreferences.getString("app.update.last_build_id", null))) {
            Log.d((String)LOGTAG, (String)("Build ID changed since last start: '20160610030239', '" + sharedPreferences.getString("app.update.last_build_id", null) + "'"));
            this.copyFeaturesFromAPK();
        }
    }

    private void copyFeaturesFromAPK() {
        BrowserApp browserApp = this.getBrowserApp();
        if (browserApp == null) {
            return;
        }
        final String string2 = browserApp.getApplicationInfo().dataDir;
        String string3 = browserApp.getApplicationInfo().sourceDir;
        final File file = new File(string3);
        final SharedPreferences sharedPreferences = GeckoSharedPrefs.forApp((Context)browserApp);
        ThreadUtils.postToBackgroundThread((Runnable)new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Log.d((String)PostUpdateHandler.LOGTAG, (String)"Copying system add-ons from APK to dataDir");
                try {
                    ZipFile zipFile = new ZipFile(file);
                    Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
                    byte[] byArray = new byte[1024];
                    while (enumeration.hasMoreElements()) {
                        String string22;
                        File file2;
                        ZipEntry zipEntry = enumeration.nextElement();
                        String string3 = zipEntry.getName();
                        if (zipEntry.isDirectory() || !string3.startsWith("assets/features/") || (file2 = PostUpdateHandler.this.getDataFile(string2, string22 = string3.substring("assets/".length()))) == null) continue;
                        try (InputStream inputStream = zipFile.getInputStream(zipEntry);){
                            PostUpdateHandler.this.writeStream(inputStream, file2, zipEntry.getTime(), byArray);
                        }
                    }
                    zipFile.close();
                }
                catch (IOException iOException) {
                    Log.e((String)PostUpdateHandler.LOGTAG, (String)"Error copying system add-ons from APK.", (Throwable)iOException);
                }
                sharedPreferences.edit().putString("app.update.last_build_id", "20160610030239").apply();
            }
        });
    }

    private File getDataFile(String string2, String string3) {
        File file = new File(string2, string3);
        File file2 = file.getParentFile();
        if (!file2.exists()) {
            Log.d((String)LOGTAG, (String)("Creating " + file2.getAbsolutePath()));
            if (!file2.mkdirs()) {
                Log.e((String)LOGTAG, (String)("Unable to create directories: " + file2.getAbsolutePath()));
                return null;
            }
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeStream(InputStream inputStream, File file, long l, byte[] byArray) throws FileNotFoundException, IOException {
        try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
            int n;
            while ((n = inputStream.read(byArray)) > 0) {
                ((OutputStream)fileOutputStream).write(byArray, 0, n);
            }
            file.setLastModified(l);
        }
    }
}

