/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.util;

import android.util.Log;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.Comparator;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.gecko.annotation.RobocopTarget;
import org.mozilla.gecko.util.IOUtils;

public class FileUtils {
    private static final String LOGTAG = "GeckoFileUtils";

    @RobocopTarget
    public static void delTree(File file, FilenameFilter filenameFilter, boolean bl) {
        String[] stringArray = null;
        stringArray = filenameFilter != null ? file.list(filenameFilter) : file.list();
        if (stringArray == null) {
            return;
        }
        for (String string : stringArray) {
            File file2 = new File(file, string);
            FileUtils.delete(file2, bl);
        }
    }

    public static boolean delete(File file) throws IOException {
        return FileUtils.delete(file, true);
    }

    public static boolean delete(File file, boolean bl) {
        if (file.isDirectory() && bl) {
            String[] stringArray;
            for (String string : stringArray = file.list()) {
                File file2 = new File(file, string);
                try {
                    FileUtils.delete(file2);
                }
                catch (IOException iOException) {
                    Log.i((String)LOGTAG, (String)("Error deleting " + file2.getPath()), (Throwable)iOException);
                }
            }
        }
        return file.delete();
    }

    public static JSONObject readJSONObjectFromFile(File file) throws IOException, JSONException {
        if (file.length() == 0L) {
            throw new IOException("Given file is empty - the JSON parser cannot create an object from an empty file");
        }
        return new JSONObject(FileUtils.readStringFromFile(file));
    }

    public static String readStringFromFile(File file) throws IOException {
        if (!file.exists()) {
            throw new FileNotFoundException("Given file, " + file + ", does not exist");
        }
        if (file.length() == 0L) {
            return "";
        }
        int n = (int)file.length();
        return FileUtils.readStringFromInputStreamAndCloseStream(new FileInputStream(file), n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readStringFromInputStreamAndCloseStream(InputStream inputStream, int n) throws IOException {
        if (n <= 0) {
            IOUtils.safeStreamClose(inputStream);
            throw new IllegalArgumentException("Expected buffer size larger than 0. Got: " + n);
        }
        StringBuilder stringBuilder = new StringBuilder(n);
        try (InputStreamReader inputStreamReader = new InputStreamReader(inputStream, Charset.forName("UTF-8"));){
            int n2;
            char[] cArray = new char[n];
            while ((n2 = inputStreamReader.read(cArray, 0, n)) != -1) {
                stringBuilder.append(cArray, 0, n2);
            }
        }
        return stringBuilder.toString();
    }

    public static void writeJSONObjectToFile(File file, JSONObject jSONObject) throws IOException {
        FileUtils.writeStringToFile(file, jSONObject.toString());
    }

    public static void writeStringToFile(File file, String string) throws IOException {
        FileUtils.writeStringToOutputStreamAndCloseStream(new FileOutputStream(file, false), string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeStringToOutputStreamAndCloseStream(OutputStream outputStream, String string) throws IOException {
        try (OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, Charset.forName("UTF-8"));){
            outputStreamWriter.write(string);
        }
        finally {
            outputStream.close();
        }
    }

    public static class FileLastModifiedComparator
    implements Comparator<File> {
        @Override
        public int compare(File file, File file2) {
            long l;
            long l2 = file.lastModified();
            if (l2 < (l = file2.lastModified())) {
                return -1;
            }
            if (l2 == l) {
                return 0;
            }
            return 1;
        }
    }

    public static class FilenameRegexFilter
    implements FilenameFilter {
        private final Pattern mPattern;
        private Matcher mCachedMatcher;

        public FilenameRegexFilter(Pattern pattern) {
            this.mPattern = pattern;
        }

        @Override
        public boolean accept(File file, String string) {
            if (this.mCachedMatcher == null) {
                this.mCachedMatcher = this.mPattern.matcher(string);
            } else {
                this.mCachedMatcher.reset(string);
            }
            return this.mCachedMatcher.matches();
        }
    }

    public static class FilenameWhitelistFilter
    implements FilenameFilter {
        private final Set<String> mFilenameWhitelist;

        public FilenameWhitelistFilter(Set<String> set) {
            this.mFilenameWhitelist = set;
        }

        @Override
        public boolean accept(File file, String string) {
            return this.mFilenameWhitelist.contains(string);
        }
    }

    public static class NameAndAgeFilter
    implements FilenameFilter {
        private final String mName;
        private final double mMaxAge;

        public NameAndAgeFilter(String string, double d) {
            this.mName = string;
            this.mMaxAge = d;
        }

        @Override
        public boolean accept(File file, String string) {
            if (this.mName == null || this.mName.matches(string)) {
                File file2 = new File(file, string);
                if (this.mMaxAge < 0.0 || (double)(System.currentTimeMillis() - file2.lastModified()) > this.mMaxAge) {
                    return true;
                }
            }
            return false;
        }
    }
}

