/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.util;

import android.content.Context;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.Display;
import android.view.WindowManager;
import java.lang.reflect.Method;
import org.mozilla.gecko.AppConstants;

public class WindowUtils {
    private static final String LOGTAG = "Gecko" + WindowUtils.class.getSimpleName();

    private WindowUtils() {
    }

    public static int getLargestDimension(Context context) {
        Display display = ((WindowManager)context.getSystemService("window")).getDefaultDisplay();
        if (AppConstants.Versions.feature17Plus) {
            DisplayMetrics displayMetrics = new DisplayMetrics();
            display.getRealMetrics(displayMetrics);
            return Math.max(displayMetrics.widthPixels, displayMetrics.heightPixels);
        }
        if (AppConstants.Versions.feature14Plus) {
            int n;
            int n2;
            try {
                Method method = Display.class.getMethod("getRawHeight", new Class[0]);
                Method method2 = Display.class.getMethod("getRawWidth", new Class[0]);
                n2 = (Integer)method2.invoke((Object)display, new Object[0]);
                n = (Integer)method.invoke((Object)display, new Object[0]);
            }
            catch (Exception exception) {
                n2 = display.getWidth();
                n = display.getHeight();
                Log.w((String)LOGTAG, (String)"Couldn't use reflection to get the real display metrics.");
            }
            return Math.max(n2, n);
        }
        return Math.max(display.getWidth(), display.getHeight());
    }
}

