/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.fxa.sync;

import android.accounts.AccountManager;
import android.app.IntentService;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.ResultReceiver;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.background.fxa.FxAccountUtils;
import org.mozilla.gecko.background.fxa.oauth.FxAccountAbstractClient;
import org.mozilla.gecko.background.fxa.oauth.FxAccountAbstractClientException;
import org.mozilla.gecko.background.fxa.profile.FxAccountProfileClient10;
import org.mozilla.gecko.sync.ExtendedJSONObject;

public class FxAccountProfileService
extends IntentService {
    private static final String LOG_TAG = "FxAccountProfileService";
    private static final Executor EXECUTOR_SERVICE = Executors.newSingleThreadExecutor();
    public static final String KEY_AUTH_TOKEN = "auth_token";
    public static final String KEY_PROFILE_SERVER_URI = "profileServerURI";
    public static final String KEY_RESULT_RECEIVER = "resultReceiver";
    public static final String KEY_RESULT_STRING = "RESULT_STRING";

    public FxAccountProfileService() {
        super(LOG_TAG);
    }

    protected void onHandleIntent(Intent intent) {
        final String string2 = intent.getStringExtra(KEY_AUTH_TOKEN);
        String string3 = intent.getStringExtra(KEY_PROFILE_SERVER_URI);
        final ResultReceiver resultReceiver = (ResultReceiver)intent.getParcelableExtra(KEY_RESULT_RECEIVER);
        if (resultReceiver == null) {
            Logger.warn(LOG_TAG, "Result receiver must not be null; ignoring intent.");
            return;
        }
        if (string2 == null || string2.length() == 0) {
            Logger.warn(LOG_TAG, "Invalid Auth Token");
            this.sendResult("Invalid Auth Token", resultReceiver, 0);
            return;
        }
        if (string3 == null || string3.length() == 0) {
            Logger.warn(LOG_TAG, "Invalid profile Server Endpoint");
            this.sendResult("Invalid profile Server Endpoint", resultReceiver, 0);
            return;
        }
        FxAccountAbstractClient.RequestDelegate<ExtendedJSONObject> requestDelegate = new FxAccountAbstractClient.RequestDelegate<ExtendedJSONObject>(){

            @Override
            public void handleError(Exception exception) {
                Logger.error(FxAccountProfileService.LOG_TAG, "Error fetching Account profile.", exception);
                FxAccountProfileService.this.sendResult("Error fetching Account profile.", resultReceiver, 0);
            }

            @Override
            public void handleFailure(FxAccountAbstractClientException.FxAccountAbstractClientRemoteException fxAccountAbstractClientRemoteException) {
                Logger.warn(FxAccountProfileService.LOG_TAG, "Failed to fetch Account profile.", fxAccountAbstractClientRemoteException);
                if (fxAccountAbstractClientRemoteException.isInvalidAuthentication()) {
                    Logger.info(FxAccountProfileService.LOG_TAG, "Invalidating oauth token after 401!");
                    AccountManager.get((Context)FxAccountProfileService.this).invalidateAuthToken("org.mozilla.fennec_fxaccount", string2);
                }
                FxAccountProfileService.this.sendResult("Failed to fetch Account profile.", resultReceiver, 0);
            }

            @Override
            public void handleSuccess(ExtendedJSONObject extendedJSONObject) {
                if (extendedJSONObject != null) {
                    FxAccountUtils.pii(FxAccountProfileService.LOG_TAG, "Profile server return profile: " + extendedJSONObject.toJSONString());
                    FxAccountProfileService.this.sendResult(extendedJSONObject.toJSONString(), resultReceiver, -1);
                }
            }
        };
        FxAccountProfileClient10 fxAccountProfileClient10 = new FxAccountProfileClient10(string3, EXECUTOR_SERVICE);
        try {
            fxAccountProfileClient10.profile(string2, requestDelegate);
        }
        catch (Exception exception) {
            Logger.error(LOG_TAG, "Got exception fetching profile.", exception);
            requestDelegate.handleError(exception);
        }
    }

    private void sendResult(String string2, ResultReceiver resultReceiver, int n) {
        if (resultReceiver != null) {
            Bundle bundle = new Bundle();
            bundle.putString(KEY_RESULT_STRING, string2);
            resultReceiver.send(n, bundle);
        }
    }
}

