/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.database.Cursor;
import android.net.Uri;
import android.os.Bundle;
import android.provider.Telephony;
import android.telephony.SmsManager;
import android.telephony.SmsMessage;
import android.util.Log;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicInteger;
import org.mozilla.gecko.Envelope;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.MessagesListManager;
import org.mozilla.gecko.Postman;
import org.mozilla.gecko.SmsIOThread;
import org.mozilla.gecko.SmsManager;
import org.mozilla.gecko.annotation.WrapForJNI;

public class GeckoSmsManager
extends BroadcastReceiver
implements SmsManager.ISmsManager {
    public static final String ACTION_SMS_SENT = "org.mozilla.gecko.SMS_SENT";
    public static final String ACTION_SMS_DELIVERED = "org.mozilla.gecko.SMS_DELIVERED";
    public static final int kNoError = 0;
    public static final int kNoSignalError = 1;
    public static final int kNotFoundError = 2;
    public static final int kUnknownError = 3;
    public static final int kInternalError = 4;
    public static final int kNoSimCardError = 5;
    public static final int kRadioDisabledError = 6;
    public static final int kInvalidAddressError = 7;
    public static final int kFdnCheckError = 8;
    public static final int kNonActiveSimCardError = 9;
    public static final int kStorageFullError = 10;
    public static final int kSimNotMatchedError = 11;
    public static final int kNetworkProblemsError = 12;
    public static final int kGeneralProblemsError = 13;
    public static final int kServiceNotAvailableError = 14;
    public static final int kMessageTooLongForNetworkError = 15;
    public static final int kServiceNotSupportedError = 16;
    public static final int kRetryRequiredError = 17;
    private static final int kMaxMessageSize = 160;
    private static final Uri kSmsContentUri = Telephony.Sms.Inbox.CONTENT_URI;
    private static final Uri kSmsSentContentUri = Telephony.Sms.Sent.CONTENT_URI;
    private static final Uri kSmsThreadsContentUri = Telephony.Sms.Conversations.CONTENT_URI;
    private static final int kSmsTypeInbox = 1;
    private static final int kSmsTypeSentbox = 2;
    private static final int kDeliveryStateSent = 0;
    private static final int kDeliveryStateReceived = 1;
    private static final int kDeliveryStateSending = 2;
    private static final int kDeliveryStateError = 3;
    private static final int kDeliveryStateUnknown = 4;
    private static final int kDeliveryStateNotDownloaded = 5;
    private static final int kDeliveryStateEndGuard = 6;
    private static final int kDeliveryStatusNotApplicable = 0;
    private static final int kDeliveryStatusSuccess = 1;
    private static final int kDeliveryStatusPending = 2;
    private static final int kDeliveryStatusError = 3;
    private static final int kMessageClassNormal = 0;
    private static final int kMessageClassClass0 = 1;
    private static final int kMessageClassClass1 = 2;
    private static final int kMessageClassClass2 = 3;
    private static final int kMessageClassClass3 = 4;
    private static final String[] kRequiredMessageRows = new String[]{"_id", "address", "body", "date", "type", "status", "read", "thread_id"};
    private static final String[] kRequiredMessageRowsForThread = new String[]{"_id", "address", "body", "read", "subject", "date"};
    private static final String[] kThreadProjection = new String[]{"thread_id"};
    private static final AtomicInteger pendingIntentGuid = new AtomicInteger(Integer.MIN_VALUE);
    private static final long UNSIGNED_INTEGER_MAX_VALUE = 0xFFFFFFFFL;

    public GeckoSmsManager() {
        if (SmsIOThread.getInstance().getState() == Thread.State.NEW) {
            SmsIOThread.getInstance().start();
        }
    }

    private boolean isDefaultSmsApp(Context context) {
        String string2 = context.getPackageName();
        return Telephony.Sms.getDefaultSmsPackage((Context)context).equals(string2);
    }

    @Override
    public void start() {
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.provider.Telephony.SMS_RECEIVED");
        intentFilter.addAction(ACTION_SMS_SENT);
        intentFilter.addAction(ACTION_SMS_DELIVERED);
        GeckoAppShell.getContext().registerReceiver((BroadcastReceiver)this, intentFilter);
    }

    private static String buildMessageBodyFromPdus(SmsMessage[] smsMessageArray) {
        if (smsMessageArray.length == 1) {
            return GeckoSmsManager.replaceFormFeeds(smsMessageArray[0].getDisplayMessageBody());
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (SmsMessage smsMessage : smsMessageArray) {
            stringBuilder.append(smsMessage.getDisplayMessageBody());
        }
        return GeckoSmsManager.replaceFormFeeds(stringBuilder.toString());
    }

    private static String replaceFormFeeds(String string2) {
        return string2 == null ? "" : string2.replace('\f', '\n');
    }

    public void onReceive(Context context, Intent intent) {
        if (intent.getAction().equals("android.provider.Telephony.SMS_DELIVER") || intent.getAction().equals("android.provider.Telephony.SMS_RECEIVED")) {
            if (this.isDefaultSmsApp(GeckoAppShell.getContext()) && intent.getAction().equals("android.provider.Telephony.SMS_RECEIVED")) {
                return;
            }
            SmsMessage[] smsMessageArray = Telephony.Sms.Intents.getMessagesFromIntent((Intent)intent);
            if (smsMessageArray == null || smsMessageArray.length == 0) {
                return;
            }
            SmsMessage smsMessage = smsMessageArray[0];
            String string2 = GeckoSmsManager.buildMessageBodyFromPdus(smsMessageArray);
            long l = System.currentTimeMillis();
            int n = 0;
            if (intent.getAction().equals("android.provider.Telephony.SMS_DELIVER")) {
                n = this.saveReceivedMessage(context, smsMessage.getDisplayOriginatingAddress(), string2, smsMessage.getTimestampMillis(), l, smsMessage.getPseudoSubject());
            }
            GeckoSmsManager.notifySmsReceived(n, smsMessage.getDisplayOriginatingAddress(), string2, this.getGeckoMessageClass(smsMessage.getMessageClass()), smsMessage.getTimestampMillis(), l);
            return;
        }
        if (intent.getAction().equals(ACTION_SMS_SENT) || intent.getAction().equals(ACTION_SMS_DELIVERED)) {
            Bundle bundle = intent.getExtras();
            if (!(bundle != null && bundle.containsKey("envelopeId") && bundle.containsKey("number") && bundle.containsKey("message") && bundle.containsKey("requestId"))) {
                Log.e((String)"GeckoSmsManager", (String)"Got an invalid ACTION_SMS_SENT/ACTION_SMS_DELIVERED!");
                return;
            }
            int n = bundle.getInt("envelopeId");
            Postman postman = Postman.getInstance();
            Envelope envelope = postman.getEnvelope(n);
            if (envelope == null) {
                Log.e((String)"GeckoSmsManager", (String)"Got an invalid envelope id (or Envelope has been destroyed)!");
                return;
            }
            Envelope.SubParts subParts = intent.getAction().equals(ACTION_SMS_SENT) ? Envelope.SubParts.SENT_PART : Envelope.SubParts.DELIVERED_PART;
            envelope.decreaseRemainingParts(subParts);
            if (this.getResultCode() != -1) {
                switch (this.getResultCode()) {
                    case 3: {
                        envelope.setError(4);
                        break;
                    }
                    case 2: 
                    case 4: {
                        envelope.setError(1);
                        break;
                    }
                    default: {
                        envelope.setError(3);
                    }
                }
                envelope.markAsFailed(subParts);
                Log.i((String)"GeckoSmsManager", (String)"SMS part sending failed!");
            }
            if (envelope.arePartsRemaining(subParts)) {
                return;
            }
            if (envelope.isFailing(subParts)) {
                if (subParts == Envelope.SubParts.SENT_PART) {
                    if (bundle.getBoolean("shouldNotify")) {
                        GeckoSmsManager.notifySmsSendFailed(envelope.getError(), bundle.getInt("requestId"));
                    }
                    Log.i((String)"GeckoSmsManager", (String)"SMS sending failed!");
                } else {
                    GeckoSmsManager.notifySmsDelivery(envelope.getMessageId(), 3, bundle.getString("number"), bundle.getString("message"), envelope.getMessageTimestamp());
                    Log.i((String)"GeckoSmsManager", (String)"SMS delivery failed!");
                }
            } else if (subParts == Envelope.SubParts.SENT_PART) {
                String string3 = bundle.getString("number");
                String string4 = bundle.getString("message");
                long l = System.currentTimeMillis();
                int n2 = 0;
                if (this.isDefaultSmsApp(GeckoAppShell.getContext())) {
                    n2 = this.saveSentMessage(string3, string4, l);
                }
                if (bundle.getBoolean("shouldNotify")) {
                    GeckoSmsManager.notifySmsSent(n2, string3, string4, l, bundle.getInt("requestId"));
                }
                envelope.setMessageId(n2);
                envelope.setMessageTimestamp(l);
                Log.i((String)"GeckoSmsManager", (String)"SMS sending was successful!");
            } else {
                Uri uri = ContentUris.withAppendedId((Uri)kSmsContentUri, (long)envelope.getMessageId());
                this.updateMessageStatus(uri, 0);
                GeckoSmsManager.notifySmsDelivery(envelope.getMessageId(), 1, bundle.getString("number"), bundle.getString("message"), envelope.getMessageTimestamp());
                Log.i((String)"GeckoSmsManager", (String)"SMS successfully delivered!");
            }
            if (!envelope.arePartsRemaining(Envelope.SubParts.SENT_PART) && !envelope.arePartsRemaining(Envelope.SubParts.DELIVERED_PART)) {
                postman.destroyEnvelope(n);
            }
        }
    }

    @Override
    public void send(String string2, String string3, int n, boolean bl) {
        int n2 = -1;
        try {
            SmsManager smsManager = SmsManager.getDefault();
            Intent intent = new Intent(GeckoAppShell.getContext(), GeckoSmsManager.class);
            intent.setAction(ACTION_SMS_SENT);
            Intent intent2 = new Intent(GeckoAppShell.getContext(), GeckoSmsManager.class);
            intent2.setAction(ACTION_SMS_DELIVERED);
            Bundle bundle = new Bundle();
            bundle.putString("number", string2);
            bundle.putString("message", string3);
            bundle.putInt("requestId", n);
            bundle.putBoolean("shouldNotify", bl);
            if (string3.length() <= 160) {
                n2 = Postman.getInstance().createEnvelope(1);
                bundle.putInt("envelopeId", n2);
                intent.putExtras(bundle);
                intent2.putExtras(bundle);
                PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)GeckoAppShell.getContext(), (int)pendingIntentGuid.incrementAndGet(), (Intent)intent, (int)0x10000000);
                PendingIntent pendingIntent2 = PendingIntent.getBroadcast((Context)GeckoAppShell.getContext(), (int)pendingIntentGuid.incrementAndGet(), (Intent)intent2, (int)0x10000000);
                smsManager.sendTextMessage(string2, null, string3, pendingIntent, pendingIntent2);
            } else {
                ArrayList arrayList = smsManager.divideMessage(string3);
                n2 = Postman.getInstance().createEnvelope(arrayList.size());
                bundle.putInt("envelopeId", n2);
                intent.putExtras(bundle);
                intent2.putExtras(bundle);
                ArrayList<PendingIntent> arrayList2 = new ArrayList<PendingIntent>(arrayList.size());
                ArrayList<PendingIntent> arrayList3 = new ArrayList<PendingIntent>(arrayList.size());
                for (int i = 0; i < arrayList.size(); ++i) {
                    arrayList2.add(PendingIntent.getBroadcast((Context)GeckoAppShell.getContext(), (int)pendingIntentGuid.incrementAndGet(), (Intent)intent, (int)0x10000000));
                    arrayList3.add(PendingIntent.getBroadcast((Context)GeckoAppShell.getContext(), (int)pendingIntentGuid.incrementAndGet(), (Intent)intent2, (int)0x10000000));
                }
                smsManager.sendMultipartTextMessage(string2, null, arrayList, arrayList2, arrayList3);
            }
        }
        catch (Exception exception) {
            Log.e((String)"GeckoSmsManager", (String)"Failed to send an SMS: ", (Throwable)exception);
            if (n2 != -1) {
                Postman.getInstance().destroyEnvelope(n2);
            }
            GeckoSmsManager.notifySmsSendFailed(3, n);
        }
    }

    public int saveSentMessage(String string2, String string3, long l) {
        try {
            ContentValues contentValues = new ContentValues();
            contentValues.put("address", string2);
            contentValues.put("body", string3);
            contentValues.put("date", Long.valueOf(l));
            contentValues.put("status", Integer.valueOf(32));
            contentValues.put("seen", Integer.valueOf(0));
            contentValues.put("read", Integer.valueOf(0));
            ContentResolver contentResolver = GeckoAppShell.getContext().getContentResolver();
            Uri uri = contentResolver.insert(kSmsSentContentUri, contentValues);
            long l2 = ContentUris.parseId((Uri)uri);
            if (l2 > 0xFFFFFFFFL) {
                throw new IdTooHighException();
            }
            return (int)l2;
        }
        catch (IdTooHighException idTooHighException) {
            Log.e((String)"GeckoSmsManager", (String)"The id we received is higher than the higher allowed value.");
            return -1;
        }
        catch (Exception exception) {
            Log.e((String)"GeckoSmsManager", (String)"Something went wrong when trying to write a sent message", (Throwable)exception);
            return -1;
        }
    }

    public void updateMessageStatus(Uri uri, int n) {
        ContentValues contentValues = new ContentValues(1);
        contentValues.put("status", Integer.valueOf(n));
        ContentResolver contentResolver = GeckoAppShell.getContext().getContentResolver();
        if (contentResolver.update(uri, contentValues, null, null) != 1) {
            Log.i((String)"GeckoSmsManager", (String)"Failed to update message status!");
        }
    }

    public int saveReceivedMessage(Context context, String string2, String string3, long l, long l2, String string4) {
        ContentValues contentValues = new ContentValues();
        contentValues.put("address", string2);
        contentValues.put("body", string3);
        contentValues.put("date_sent", Long.valueOf(l));
        contentValues.put("date", Long.valueOf(l2));
        contentValues.put("status", Integer.valueOf(0));
        contentValues.put("read", Integer.valueOf(0));
        contentValues.put("seen", Integer.valueOf(0));
        ContentResolver contentResolver = context.getContentResolver();
        Uri uri = contentResolver.insert(kSmsContentUri, contentValues);
        long l3 = ContentUris.parseId((Uri)uri);
        if (l3 > 0xFFFFFFFFL) {
            Log.i((String)"GeckoSmsManager", (String)"The id we received is higher than the higher allowed value.");
            return -1;
        }
        return (int)l3;
    }

    @Override
    public void getMessage(int n, int n2) {
        class GetMessageRunnable
        implements Runnable {
            private final int mMessageId;
            private final int mRequestId;

            GetMessageRunnable(int n, int n2) {
                this.mMessageId = n;
                this.mRequestId = n2;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try (Cursor cursor = null;){
                    int n;
                    ContentResolver contentResolver = GeckoAppShell.getContext().getContentResolver();
                    Uri uri = ContentUris.withAppendedId((Uri)kSmsContentUri, (long)this.mMessageId);
                    cursor = contentResolver.query(uri, kRequiredMessageRows, null, null, null);
                    if (cursor == null || cursor.getCount() == 0) {
                        throw new NotFoundException();
                    }
                    if (cursor.getCount() != 1) {
                        throw new TooManyResultsException();
                    }
                    cursor.moveToFirst();
                    if (cursor.getInt(cursor.getColumnIndex("_id")) != this.mMessageId) {
                        throw new UnmatchingIdException();
                    }
                    int n2 = cursor.getInt(cursor.getColumnIndex("type"));
                    String string2 = "";
                    String string3 = "";
                    if (n2 == 1) {
                        n = 1;
                        string2 = cursor.getString(cursor.getColumnIndex("address"));
                    } else if (n2 == 2) {
                        n = GeckoSmsManager.this.getGeckoDeliveryStatus(cursor.getInt(cursor.getColumnIndex("status")));
                        string3 = cursor.getString(cursor.getColumnIndex("address"));
                    } else {
                        throw new InvalidTypeException();
                    }
                    boolean bl = cursor.getInt(cursor.getColumnIndex("read")) != 0;
                    GeckoSmsManager.notifyGetSms(cursor.getInt(cursor.getColumnIndex("_id")), n, string3, string2, cursor.getString(cursor.getColumnIndex("body")), cursor.getLong(cursor.getColumnIndex("date")), bl, this.mRequestId);
                }
            }
        }
        if (!SmsIOThread.getInstance().execute(new GetMessageRunnable(n, n2))) {
            Log.e((String)"GeckoSmsManager", (String)"Failed to add GetMessageRunnable to the SmsIOThread");
            GeckoSmsManager.notifyGetSmsFailed(3, n2);
        }
    }

    @Override
    public void deleteMessage(int n, int n2) {
        class DeleteMessageRunnable
        implements Runnable {
            private final int mMessageId;
            private final int mRequestId;

            DeleteMessageRunnable(int n, int n2) {
                this.mMessageId = n;
                this.mRequestId = n2;
            }

            @Override
            public void run() {
                try {
                    ContentResolver contentResolver = GeckoAppShell.getContext().getContentResolver();
                    Uri uri = ContentUris.withAppendedId((Uri)kSmsContentUri, (long)this.mMessageId);
                    int n = contentResolver.delete(uri, null, null);
                    if (n > 1) {
                        throw new TooManyResultsException();
                    }
                    GeckoSmsManager.notifySmsDeleted(n == 1, this.mRequestId);
                }
                catch (TooManyResultsException tooManyResultsException) {
                    Log.e((String)"GeckoSmsManager", (String)"Delete more than one message?", (Throwable)tooManyResultsException);
                    GeckoSmsManager.notifySmsDeleteFailed(3, this.mRequestId);
                }
                catch (Exception exception) {
                    Log.e((String)"GeckoSmsManager", (String)"Error while trying to delete a message", (Throwable)exception);
                    GeckoSmsManager.notifySmsDeleteFailed(3, this.mRequestId);
                }
            }
        }
        if (!SmsIOThread.getInstance().execute(new DeleteMessageRunnable(n, n2))) {
            Log.e((String)"GeckoSmsManager", (String)"Failed to add GetMessageRunnable to the SmsIOThread");
            GeckoSmsManager.notifySmsDeleteFailed(3, n2);
        }
    }

    private void getMessageFromCursorAndNotify(Cursor cursor, int n) throws Exception {
        int n2 = cursor.getInt(cursor.getColumnIndex("type"));
        int n3 = 4;
        String string2 = "";
        String string3 = "";
        if (n2 == 1) {
            n3 = 1;
            string2 = cursor.getString(cursor.getColumnIndex("address"));
        } else if (n2 == 2) {
            n3 = this.getGeckoDeliveryStatus(cursor.getInt(cursor.getColumnIndex("status")));
            string3 = cursor.getString(cursor.getColumnIndex("address"));
        } else {
            throw new Exception("Shouldn't ever get a message here that's not from inbox or sentbox");
        }
        boolean bl = cursor.getInt(cursor.getColumnIndex("read")) != 0;
        GeckoSmsManager.notifyMessageCursorResult(cursor.getInt(cursor.getColumnIndex("_id")), n3, string3, string2, cursor.getString(cursor.getColumnIndex("body")), cursor.getLong(cursor.getColumnIndex("date")), cursor.getLong(cursor.getColumnIndex("thread_id")), bl, n);
    }

    @Override
    public void markMessageRead(int n, boolean bl, boolean bl2, int n2) {
        if (bl2) {
            Log.w((String)"GeckoSmsManager", (String)"Android SmsManager doesn't suport read receipts for SMS.");
        }
        class MarkMessageReadRunnable
        implements Runnable {
            private final int mMessageId;
            private final boolean mValue;
            private final int mRequestId;

            MarkMessageReadRunnable(int n, boolean bl, int n2) {
                this.mMessageId = n;
                this.mValue = bl;
                this.mRequestId = n2;
            }

            @Override
            public void run() {
                try {
                    ContentResolver contentResolver = GeckoAppShell.getContext().getContentResolver();
                    Uri uri = ContentUris.withAppendedId((Uri)kSmsContentUri, (long)this.mMessageId);
                    ContentValues contentValues = new ContentValues();
                    contentValues.put("read", Boolean.valueOf(this.mValue));
                    int n = contentResolver.update(uri, contentValues, null, null);
                    GeckoSmsManager.notifySmsMarkedAsRead(n == 1, this.mRequestId);
                }
                catch (Exception exception) {
                    Log.e((String)"GeckoSmsManager", (String)("Error while trying to mark message as read: " + exception));
                    GeckoSmsManager.notifySmsMarkAsReadFailed(3, this.mRequestId);
                }
            }
        }
        if (!SmsIOThread.getInstance().execute(new MarkMessageReadRunnable(n, bl, n2))) {
            Log.e((String)"GeckoSmsManager", (String)"Failed to add MarkMessageReadRunnable to the SmsIOThread");
            GeckoSmsManager.notifySmsMarkAsReadFailed(3, n2);
        }
    }

    @Override
    public void createMessageCursor(long l, long l2, String[] stringArray, int n, String string2, boolean bl, boolean bl2, boolean bl3, long l3, boolean bl4, int n2) {
        class CreateMessageCursorRunnable
        implements Runnable {
            private final long mStartDate;
            private final long mEndDate;
            private final String[] mNumbers;
            private final int mNumbersCount;
            private final String mDelivery;
            private final boolean mHasThreadId;
            private final long mThreadId;
            private final boolean mReverse;
            private final int mRequestId;

            CreateMessageCursorRunnable(long l, long l2, String[] stringArray, int n, String string2, boolean bl, boolean bl2, boolean bl3, long l3, boolean bl4, int n2) {
                this.mStartDate = l;
                this.mEndDate = l2;
                this.mNumbers = stringArray;
                this.mNumbersCount = n;
                this.mDelivery = string2;
                this.mHasThreadId = bl3;
                this.mThreadId = l3;
                this.mReverse = bl4;
                this.mRequestId = n2;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Cursor cursor = null;
                boolean bl = true;
                try {
                    StringBuilder stringBuilder = new StringBuilder();
                    Formatter formatter = new Formatter(stringBuilder);
                    if (this.mStartDate >= 0L) {
                        formatter.format("date >= '%d' AND ", this.mStartDate);
                    }
                    if (this.mEndDate >= 0L) {
                        formatter.format("date <= '%d' AND ", this.mEndDate);
                    }
                    if (this.mNumbersCount > 0) {
                        formatter.format("address IN ('%s'", this.mNumbers[0]);
                        for (int i = 1; i < this.mNumbersCount; ++i) {
                            formatter.format(", '%s'", this.mNumbers[i]);
                        }
                        formatter.format(") AND ", new Object[0]);
                    }
                    if (this.mDelivery == null || this.mDelivery.isEmpty()) {
                        formatter.format("type IN ('%d', '%d') AND ", 2, 1);
                    } else if (this.mDelivery.equals("sent")) {
                        formatter.format("type = '%d' AND ", 2);
                    } else if (this.mDelivery.equals("received")) {
                        formatter.format("type = '%d' AND ", 1);
                    } else {
                        throw new Exception("Unexpected delivery state: " + this.mDelivery);
                    }
                    if (this.mHasThreadId) {
                        formatter.format("thread_id = '%d' AND ", this.mThreadId);
                    }
                    formatter.format("1", new Object[0]);
                    ContentResolver contentResolver = GeckoAppShell.getContext().getContentResolver();
                    cursor = contentResolver.query(kSmsContentUri, kRequiredMessageRows, stringBuilder.toString(), null, this.mReverse ? "date DESC" : "date ASC");
                    if (cursor.getCount() == 0) {
                        GeckoSmsManager.notifyCursorDone(this.mRequestId);
                        return;
                    }
                    MessagesListManager.getInstance().add(this.mRequestId, cursor);
                    cursor.moveToFirst();
                    GeckoSmsManager.this.getMessageFromCursorAndNotify(cursor, this.mRequestId);
                    bl = false;
                }
                catch (Exception exception) {
                    Log.e((String)"GeckoSmsManager", (String)"Error while trying to create a message list cursor", (Throwable)exception);
                    GeckoSmsManager.notifyCursorError(3, this.mRequestId);
                }
                finally {
                    if (bl && cursor != null) {
                        cursor.close();
                    }
                }
            }
        }
        if (!SmsIOThread.getInstance().execute(new CreateMessageCursorRunnable(l, l2, stringArray, n, string2, bl, bl2, bl3, l3, bl4, n2))) {
            Log.e((String)"GeckoSmsManager", (String)"Failed to add CreateMessageCursorRunnable to the SmsIOThread");
            GeckoSmsManager.notifyCursorError(3, n2);
        }
    }

    @Override
    public void getNextMessage(int n) {
        class GetNextMessageRunnable
        implements Runnable {
            private final int mRequestId;

            GetNextMessageRunnable(int n) {
                this.mRequestId = n;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Cursor cursor = null;
                boolean bl = true;
                try {
                    cursor = MessagesListManager.getInstance().get(this.mRequestId);
                    if (!cursor.moveToNext()) {
                        MessagesListManager.getInstance().remove(this.mRequestId);
                        GeckoSmsManager.notifyCursorDone(this.mRequestId);
                        return;
                    }
                    GeckoSmsManager.this.getMessageFromCursorAndNotify(cursor, this.mRequestId);
                    bl = false;
                }
                catch (Exception exception) {
                    Log.e((String)"GeckoSmsManager", (String)"Error while trying to get the next message of a list", (Throwable)exception);
                    GeckoSmsManager.notifyCursorError(3, this.mRequestId);
                }
                finally {
                    if (bl) {
                        cursor.close();
                    }
                }
            }
        }
        if (!SmsIOThread.getInstance().execute(new GetNextMessageRunnable(n))) {
            Log.e((String)"GeckoSmsManager", (String)"Failed to add GetNextMessageRunnable to the SmsIOThread");
            GeckoSmsManager.notifyCursorError(3, n);
        }
    }

    private void getThreadFromCursorAndNotify(Cursor cursor, int n) throws Exception {
        String string2;
        ContentResolver contentResolver = GeckoAppShell.getContext().getContentResolver();
        long l = cursor.getLong(cursor.getColumnIndex("thread_id"));
        Cursor cursor2 = contentResolver.query(kSmsContentUri, kRequiredMessageRowsForThread, "thread_id = " + l, null, "date DESC");
        if (cursor2 == null || cursor2.getCount() == 0) {
            throw new Exception("Empty thread " + l);
        }
        cursor2.moveToFirst();
        String string3 = cursor2.getString(cursor2.getColumnIndex("subject"));
        String string4 = cursor2.getString(cursor2.getColumnIndex("body"));
        long l2 = cursor2.getLong(cursor2.getColumnIndex("date"));
        HashSet<String> hashSet = new HashSet<String>();
        do {
            string2 = cursor2.getString(cursor2.getColumnIndex("address"));
            hashSet.add(string2);
        } while (cursor2.moveToNext());
        string2 = "sms";
        cursor2 = contentResolver.query(kSmsContentUri, kRequiredMessageRowsForThread, "thread_id = " + l + " AND read = 0", null, null);
        if (cursor2 == null) {
            Log.e((String)"GeckoSmsManager", (String)"We should never get here, should have errored before");
            throw new Exception("Empty thread " + l);
        }
        long l3 = cursor2.getCount();
        GeckoSmsManager.notifyThreadCursorResult(l, string3, string4, l3, hashSet.toArray(), l2, string2, n);
    }

    @Override
    public void createThreadCursor(int n) {
        class CreateThreadCursorRunnable
        implements Runnable {
            private final int mRequestId;

            CreateThreadCursorRunnable(int n) {
                this.mRequestId = n;
            }

            @Override
            public void run() {
                try {
                    ContentResolver contentResolver = GeckoAppShell.getContext().getContentResolver();
                    Cursor cursor = contentResolver.query(kSmsThreadsContentUri, kThreadProjection, null, null, "date DESC");
                    if (cursor == null || !cursor.moveToFirst()) {
                        GeckoSmsManager.notifyCursorDone(this.mRequestId);
                        return;
                    }
                    MessagesListManager.getInstance().add(this.mRequestId, cursor);
                    GeckoSmsManager.this.getThreadFromCursorAndNotify(cursor, this.mRequestId);
                }
                catch (Exception exception) {
                    Log.e((String)"GeckoSmsManager", (String)("Error while trying to create thread cursor: " + exception));
                    GeckoSmsManager.notifyCursorError(3, this.mRequestId);
                }
            }
        }
        if (!SmsIOThread.getInstance().execute(new CreateThreadCursorRunnable(n))) {
            Log.e((String)"GeckoSmsManager", (String)"Failed to add CreateThreadCursorRunnable to the SmsIOThread");
            GeckoSmsManager.notifyCursorError(3, n);
        }
    }

    @Override
    public void getNextThread(int n) {
        class GetNextThreadRunnable
        implements Runnable {
            private final int mRequestId;

            GetNextThreadRunnable(int n) {
                this.mRequestId = n;
            }

            @Override
            public void run() {
                try {
                    Cursor cursor = MessagesListManager.getInstance().get(this.mRequestId);
                    if (!cursor.moveToNext()) {
                        MessagesListManager.getInstance().remove(this.mRequestId);
                        GeckoSmsManager.notifyCursorDone(this.mRequestId);
                        return;
                    }
                    GeckoSmsManager.this.getThreadFromCursorAndNotify(cursor, this.mRequestId);
                }
                catch (Exception exception) {
                    Log.e((String)"GeckoSmsManager", (String)("Error while trying to create thread cursor: " + exception));
                    GeckoSmsManager.notifyCursorError(3, this.mRequestId);
                }
            }
        }
        if (!SmsIOThread.getInstance().execute(new GetNextThreadRunnable(n))) {
            Log.e((String)"GeckoSmsManager", (String)"Failed to add GetNextThreadRunnable to the SmsIOThread");
            GeckoSmsManager.notifyCursorError(3, n);
        }
    }

    @Override
    public void stop() {
        GeckoAppShell.getContext().unregisterReceiver((BroadcastReceiver)this);
    }

    @Override
    public void shutdown() {
        SmsIOThread.getInstance().interrupt();
        MessagesListManager.getInstance().clear();
    }

    private int getGeckoDeliveryStatus(int n) {
        if (n == -1) {
            return 0;
        }
        if (n >= 64) {
            return 3;
        }
        if (n >= 32) {
            return 2;
        }
        return 1;
    }

    private int getGeckoMessageClass(SmsMessage.MessageClass messageClass) {
        switch (messageClass) {
            case CLASS_0: {
                return 1;
            }
            case CLASS_1: {
                return 2;
            }
            case CLASS_2: {
                return 3;
            }
            case CLASS_3: {
                return 4;
            }
        }
        return 0;
    }

    @WrapForJNI
    public static native void notifySmsReceived(int var0, String var1, String var2, int var3, long var4, long var6);

    @WrapForJNI
    private static native void notifySmsSent(int var0, String var1, String var2, long var3, int var5);

    @WrapForJNI
    private static native void notifySmsDelivery(int var0, int var1, String var2, String var3, long var4);

    @WrapForJNI
    private static native void notifySmsSendFailed(int var0, int var1);

    @WrapForJNI
    private static native void notifyGetSms(int var0, int var1, String var2, String var3, String var4, long var5, boolean var7, int var8);

    @WrapForJNI
    private static native void notifyGetSmsFailed(int var0, int var1);

    @WrapForJNI
    private static native void notifySmsDeleted(boolean var0, int var1);

    @WrapForJNI
    private static native void notifySmsDeleteFailed(int var0, int var1);

    @WrapForJNI
    private static native void notifySmsMarkedAsRead(boolean var0, int var1);

    @WrapForJNI
    private static native void notifySmsMarkAsReadFailed(int var0, int var1);

    @WrapForJNI
    private static native void notifyCursorError(int var0, int var1);

    @WrapForJNI
    private static native void notifyThreadCursorResult(long var0, String var2, String var3, long var4, Object[] var6, long var7, String var9, int var10);

    @WrapForJNI
    private static native void notifyMessageCursorResult(int var0, int var1, String var2, String var3, String var4, long var5, long var7, boolean var9, int var10);

    @WrapForJNI
    private static native void notifyCursorDone(int var0);

    static /* synthetic */ void access$400(int n, int n2) {
        GeckoSmsManager.notifyGetSmsFailed(n, n2);
    }

    static class UnmatchingIdException
    extends Exception {
        private static final long serialVersionUID = 158467542575633280L;

        UnmatchingIdException() {
        }
    }

    static class TooManyResultsException
    extends Exception {
        private static final long serialVersionUID = 51883196784325305L;

        TooManyResultsException() {
        }
    }

    static class NotFoundException
    extends Exception {
        private static final long serialVersionUID = 1940676816633984L;

        NotFoundException() {
        }
    }

    static class InvalidTypeException
    extends Exception {
        private static final long serialVersionUID = 47436856832535912L;

        InvalidTypeException() {
        }
    }

    static class IdTooHighException
    extends Exception {
        private static final long serialVersionUID = 29935575131092050L;

        IdTooHighException() {
        }
    }
}

