/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.app.Notification;
import android.app.PendingIntent;
import android.text.TextUtils;
import android.util.Log;
import java.util.LinkedList;
import java.util.concurrent.ConcurrentHashMap;
import org.mozilla.gecko.NotificationHandler;

public abstract class NotificationClient {
    private static final String LOGTAG = "GeckoNotificationClient";
    private volatile NotificationHandler mHandler;
    private boolean mReady;
    private final LinkedList<Runnable> mTaskQueue = new LinkedList();
    private final ConcurrentHashMap<Integer, UpdateRunnable> mUpdatesMap = new ConcurrentHashMap();

    public synchronized void add(final int n, final String string2, final String string3, final String string4, final String string5, final PendingIntent pendingIntent) {
        this.mTaskQueue.add(new Runnable(){

            @Override
            public void run() {
                NotificationClient.this.mHandler.add(n, string2, string3, string4, string5, pendingIntent);
            }
        });
        this.notify();
        if (!this.mReady) {
            this.bind();
        }
    }

    public synchronized void add(final int n, final Notification notification) {
        this.mTaskQueue.add(new Runnable(){

            @Override
            public void run() {
                NotificationClient.this.mHandler.add(n, notification);
            }
        });
        this.notify();
        if (!this.mReady) {
            this.bind();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(int n, long l, long l2, String string2) {
        UpdateRunnable updateRunnable = this.mUpdatesMap.get(n);
        if (updateRunnable == null) {
            updateRunnable = new UpdateRunnable(n);
            this.mUpdatesMap.put(n, updateRunnable);
        }
        if (!updateRunnable.updateProgress(l, l2, string2)) {
            return;
        }
        NotificationClient notificationClient = this;
        synchronized (notificationClient) {
            if (this.mReady) {
                this.mTaskQueue.add(updateRunnable);
                this.notify();
            }
        }
    }

    public synchronized void remove(final int n) {
        this.mTaskQueue.add(new Runnable(){

            @Override
            public void run() {
                NotificationClient.this.mHandler.remove(n);
                NotificationClient.this.mUpdatesMap.remove(n);
            }
        });
        if (!this.mReady) {
            this.bind();
        }
        this.notify();
    }

    public boolean isOngoing(int n) {
        NotificationHandler notificationHandler = this.mHandler;
        return notificationHandler != null && notificationHandler.isOngoing(n);
    }

    protected void bind() {
        this.mReady = true;
    }

    protected void unbind() {
        this.mReady = false;
        this.mUpdatesMap.clear();
    }

    protected void connectHandler(NotificationHandler notificationHandler) {
        this.mHandler = notificationHandler;
        new Thread(new NotificationRunnable()).start();
    }

    private class NotificationRunnable
    implements Runnable {
        private NotificationRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                while (true) {
                    Runnable runnable;
                    NotificationClient notificationClient = NotificationClient.this;
                    synchronized (notificationClient) {
                        runnable = (Runnable)NotificationClient.this.mTaskQueue.poll();
                        while (runnable == null) {
                            if (NotificationClient.this.mHandler.isDone()) {
                                NotificationClient.this.unbind();
                                return;
                            }
                            NotificationClient.this.wait();
                            runnable = (Runnable)NotificationClient.this.mTaskQueue.poll();
                        }
                    }
                    runnable.run();
                }
            }
            catch (InterruptedException interruptedException) {
                Log.e((String)NotificationClient.LOGTAG, (String)"Notification task queue processing interrupted", (Throwable)interruptedException);
                return;
            }
        }
    }

    private class UpdateRunnable
    implements Runnable {
        private long mProgress;
        private long mProgressMax;
        private String mAlertText;
        private final int mNotificationID;

        public UpdateRunnable(int n) {
            this.mNotificationID = n;
        }

        public synchronized boolean updateProgress(long l, long l2, String string2) {
            if (l == this.mProgress && this.mProgressMax == l2 && TextUtils.equals((CharSequence)this.mAlertText, (CharSequence)string2)) {
                return false;
            }
            this.mProgress = l;
            this.mProgressMax = l2;
            this.mAlertText = string2;
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            String string2;
            long l;
            long l2;
            UpdateRunnable updateRunnable = this;
            synchronized (updateRunnable) {
                l2 = this.mProgress;
                l = this.mProgressMax;
                string2 = this.mAlertText;
            }
            NotificationClient.this.mHandler.update(this.mNotificationID, l2, l, string2);
        }
    }
}

