/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.delegates;

import android.content.Context;
import android.os.Bundle;
import org.mozilla.gecko.BrowserApp;
import org.mozilla.gecko.ScreenshotObserver;
import org.mozilla.gecko.Telemetry;
import org.mozilla.gecko.TelemetryContract;
import org.mozilla.gecko.delegates.BrowserAppDelegateWithReference;

public class ScreenshotDelegate
extends BrowserAppDelegateWithReference
implements ScreenshotObserver.OnScreenshotListener {
    private static final String LOGTAG = "GeckoScreenshotDelegate";
    private final ScreenshotObserver mScreenshotObserver = new ScreenshotObserver();

    @Override
    public void onCreate(BrowserApp browserApp, Bundle bundle) {
        super.onCreate(browserApp, bundle);
        this.mScreenshotObserver.setListener((Context)browserApp, this);
    }

    @Override
    public void onScreenshotTaken(String string2, String string3) {
        Telemetry.sendUIEvent(TelemetryContract.Event.SHARE, TelemetryContract.Method.BUTTON, "screenshot");
    }

    @Override
    public void onResume(BrowserApp browserApp) {
        this.mScreenshotObserver.start();
    }

    @Override
    public void onPause(BrowserApp browserApp) {
        this.mScreenshotObserver.stop();
    }
}

